/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.cleanup;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.ChangeMethodAccessLevelVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class TestsShouldNotBePublic
extends ScanningRecipe<Accumulator> {
    @Option(displayName="Remove protected modifiers", description="Also remove protected modifiers from test methods", example="true", required=false)
    private @Nullable Boolean removeProtectedModifiers;

    public String getDisplayName() {
        return "Remove `public` visibility of JUnit 5 tests";
    }

    public String getDescription() {
        return "Remove `public` and optionally `protected` modifiers from methods with `@Test`, `@ParameterizedTest`, `@RepeatedTest`, `@TestFactory`, `@BeforeEach`, `@AfterEach`, `@BeforeAll`, or `@AfterAll`. They no longer have to be public visibility to be usable by JUnit 5.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S5786");
    }

    public Accumulator getInitialValue(ExecutionContext ctx) {
        return new Accumulator();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDeclaration, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDeclaration, (Object)ctx);
                if (cd.getExtends() != null) {
                    acc.extendedClasses.add(String.valueOf(cd.getExtends().getType()));
                }
                return cd;
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(Accumulator acc) {
        return new TestsNotPublicVisitor(Boolean.TRUE.equals(this.removeProtectedModifiers), acc);
    }

    @ConstructorProperties(value={"removeProtectedModifiers"})
    @Generated
    public TestsShouldNotBePublic(@Nullable Boolean removeProtectedModifiers) {
        this.removeProtectedModifiers = removeProtectedModifiers;
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestsShouldNotBePublic)) {
            return false;
        }
        TestsShouldNotBePublic other = (TestsShouldNotBePublic)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$removeProtectedModifiers = this.removeProtectedModifiers;
        Boolean other$removeProtectedModifiers = other.removeProtectedModifiers;
        return !(this$removeProtectedModifiers == null ? other$removeProtectedModifiers != null : !((Object)this$removeProtectedModifiers).equals(other$removeProtectedModifiers));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof TestsShouldNotBePublic;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $removeProtectedModifiers = this.removeProtectedModifiers;
        result = result * 59 + ($removeProtectedModifiers == null ? 43 : ((Object)$removeProtectedModifiers).hashCode());
        return result;
    }

    public static class Accumulator {
        Set<String> extendedClasses = new HashSet<String>();
    }

    private static final class TestsNotPublicVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final Boolean orProtected;
        private final Accumulator acc;

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            J.ClassDeclaration c = super.visitClassDeclaration(classDecl, (Object)ctx);
            if (c.getKind() != J.ClassDeclaration.Kind.Type.Interface && c.getModifiers().stream().anyMatch(mod -> mod.getType() == J.Modifier.Type.Public) && c.getModifiers().stream().noneMatch(mod -> mod.getType() == J.Modifier.Type.Abstract) && !this.acc.extendedClasses.contains(String.valueOf(c.getType()))) {
                boolean hasTestMethods = c.getBody().getStatements().stream().filter(J.MethodDeclaration.class::isInstance).map(J.MethodDeclaration.class::cast).anyMatch(this::hasJUnit5MethodAnnotation);
                boolean hasPublicNonTestMethods = c.getBody().getStatements().stream().filter(J.MethodDeclaration.class::isInstance).map(J.MethodDeclaration.class::cast).filter(m -> m.getModifiers().stream().anyMatch(mod -> mod.getType() == J.Modifier.Type.Public)).anyMatch(method -> !this.hasJUnit5MethodAnnotation((J.MethodDeclaration)method));
                boolean hasPublicVariableDeclarations = c.getBody().getStatements().stream().filter(J.VariableDeclarations.class::isInstance).map(J.VariableDeclarations.class::cast).anyMatch(m -> m.getModifiers().stream().anyMatch(mod -> mod.getType() == J.Modifier.Type.Public));
                if (hasTestMethods && !hasPublicNonTestMethods && !hasPublicVariableDeclarations) {
                    ArrayList modifierComments = new ArrayList();
                    List modifiers = ListUtils.map((List)c.getModifiers(), mod -> {
                        if (mod.getType() == J.Modifier.Type.Public) {
                            modifierComments.addAll(mod.getComments());
                            return null;
                        }
                        if (!modifierComments.isEmpty()) {
                            J.Modifier nextModifier = (J.Modifier)mod.withComments(ListUtils.concatAll(new ArrayList(modifierComments), (List)mod.getComments()));
                            modifierComments.clear();
                            return nextModifier;
                        }
                        return mod;
                    });
                    if (!modifierComments.isEmpty()) {
                        c = (J.ClassDeclaration)c.withComments(ListUtils.concatAll((List)c.getComments(), modifierComments));
                    }
                    c = (J.ClassDeclaration)this.maybeAutoFormat((J)c, (J)c.withModifiers(modifiers), (J)c.getName(), ctx, this.getCursor().getParentTreeCursor());
                }
            }
            return c;
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
            J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)ctx);
            if (method.getMethodType() == null || method.getMethodType().getDeclaringType().hasFlags(new Flag[]{Flag.Abstract, Flag.Public})) {
                return m;
            }
            if (m.hasModifier(J.Modifier.Type.Abstract) || TypeUtils.isOverride((JavaType.Method)method.getMethodType())) {
                return m;
            }
            if ((m.hasModifier(J.Modifier.Type.Public) || this.orProtected.booleanValue() && m.hasModifier(J.Modifier.Type.Protected)) && this.hasJUnit5MethodAnnotation(m)) {
                this.doAfterVisit((TreeVisitor)new ChangeMethodAccessLevelVisitor(new MethodMatcher(method), null));
            }
            return m;
        }

        private boolean hasJUnit5MethodAnnotation(J.MethodDeclaration method) {
            for (J.Annotation a : method.getLeadingAnnotations()) {
                if (!TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.jupiter.api.Test") && !TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.jupiter.api.RepeatedTest") && !TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.jupiter.params.ParameterizedTest") && !TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.jupiter.api.TestFactory") && !TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.jupiter.api.AfterEach") && !TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.jupiter.api.BeforeEach") && !TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.jupiter.api.AfterAll") && !TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.jupiter.api.BeforeAll")) continue;
                return true;
            }
            return false;
        }

        @ConstructorProperties(value={"orProtected", "acc"})
        @Generated
        public TestsNotPublicVisitor(Boolean orProtected, Accumulator acc) {
            this.orProtected = orProtected;
            this.acc = acc;
        }
    }
}

