/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.cleanup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;

public class AssertionsArgumentOrder
extends Recipe {
    private static final MethodMatcher[] jupiterAssertionMatchers = new MethodMatcher[]{new MethodMatcher("org.junit.jupiter.api.Assertions assertArrayEquals(..)"), new MethodMatcher("org.junit.jupiter.api.Assertions assertEquals(..)"), new MethodMatcher("org.junit.jupiter.api.Assertions assertNotEquals(..)"), new MethodMatcher("org.junit.jupiter.api.Assertions assertSame(..)"), new MethodMatcher("org.junit.jupiter.api.Assertions assertNotSame(..)")};
    private static final MethodMatcher[] junitAssertMatchers = new MethodMatcher[]{new MethodMatcher("org.junit.Assert assertEquals(..)"), new MethodMatcher("org.junit.Assert assertEquals(..)"), new MethodMatcher("org.junit.Assert assertArrayEquals(..)"), new MethodMatcher("org.junit.Assert assertSame(..)"), new MethodMatcher("org.junit.Assert assertNotSame(..)"), new MethodMatcher("org.junit.Assert assert*Null(String, Object)")};
    private static final MethodMatcher[] junitAssertWithMessageMatchers = new MethodMatcher[]{new MethodMatcher("org.junit.Assert assertEquals(String, ..)"), new MethodMatcher("org.junit.Assert assertArrayEquals(String, ..)")};
    private static final MethodMatcher jupiterAssertIterableEqualsMatcher = new MethodMatcher("org.junit.jupiter.api.Assertions assertIterableEquals(..)");
    private static final MethodMatcher jupiterAssertNullMatcher = new MethodMatcher("org.junit.jupiter.api.Assertions assert*Null(Object, String)");
    private static final MethodMatcher[] testNgMatcher = new MethodMatcher[]{new MethodMatcher("org.testng.Assert assertSame(..)"), new MethodMatcher("org.testng.Assert assertNotSame(..)"), new MethodMatcher("org.testng.Assert assertEquals(..)"), new MethodMatcher("org.testng.Assert assertNotEquals(..)")};
    private static final TreeVisitor<?, ExecutionContext> precondition;

    public String getDisplayName() {
        return "Assertion arguments should be passed in the correct order";
    }

    public String getDescription() {
        return "Assertions such as `org.junit.Assert.assertEquals` expect the first argument to be the expected value and the second argument to be the actual value; for `org.testng.Assert`, it\u2019s the other way around.  This recipe detects `J.Literal`, `J.NewArray`, and `java.util.Iterable` arguments swapping them if necessary so that the error messages won't be confusing.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S3415");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(precondition, (TreeVisitor)new AssertionsArgumentOrderVisitor());
    }

    static {
        ArrayList<MethodMatcher> matchers = new ArrayList<MethodMatcher>(Arrays.asList(jupiterAssertionMatchers));
        matchers.addAll(Arrays.asList(junitAssertMatchers));
        matchers.addAll(Arrays.asList(junitAssertWithMessageMatchers));
        matchers.add(jupiterAssertIterableEqualsMatcher);
        matchers.add(jupiterAssertNullMatcher);
        matchers.addAll(Arrays.asList(testNgMatcher));
        precondition = Preconditions.or((TreeVisitor[])((TreeVisitor[])matchers.stream().map(UsesMethod::new).toArray(TreeVisitor[]::new)));
    }

    private static class AssertionsArgumentOrderVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final MethodMatcher[] newListMatchers = new MethodMatcher[]{new MethodMatcher("java.util.List of(..)"), new MethodMatcher("java.util.Collections singleton(..)"), new MethodMatcher("java.util.Collections empty()"), new MethodMatcher("java.util.Arrays asList(..)")};

        private AssertionsArgumentOrderVisitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            Expression actual;
            Expression expected;
            J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
            if (this.isJunitAssertEqualsWithMessage(mi)) {
                expected = (Expression)mi.getArguments().get(1);
                actual = (Expression)mi.getArguments().get(2);
            } else if (this.isJunitAssertion(mi) || this.isJupiterAssertion(mi)) {
                expected = (Expression)mi.getArguments().get(0);
                actual = (Expression)mi.getArguments().get(1);
            } else if (this.isTestNgAssertion(mi)) {
                expected = (Expression)mi.getArguments().get(1);
                actual = (Expression)mi.getArguments().get(0);
            } else {
                return mi;
            }
            if (!this.isCorrectOrder(expected, actual, mi)) {
                mi = (J.MethodInvocation)this.maybeAutoFormat((J)mi, (J)mi.withArguments(ListUtils.map((List)mi.getArguments(), arg -> {
                    if (arg.equals(actual)) {
                        return expected;
                    }
                    if (arg.equals(expected)) {
                        return actual;
                    }
                    return arg;
                })), ctx, this.getCursor().getParentOrThrow());
            }
            return mi;
        }

        private boolean isCorrectOrder(Expression expected, Expression actual, J.MethodInvocation mi) {
            if (jupiterAssertNullMatcher.matches((MethodCall)mi)) {
                return this.isConstant(actual, mi) || !this.isConstant(expected, mi);
            }
            return this.isConstant(expected, mi) || !this.isConstant(actual, mi);
        }

        private boolean isConstant(Expression expression, J.MethodInvocation mi) {
            if (expression instanceof J.Literal) {
                return true;
            }
            if (expression instanceof J.NewArray) {
                return true;
            }
            JavaType.Variable var = null;
            if (expression instanceof J.Identifier) {
                var = ((J.Identifier)expression).getFieldType();
            } else if (expression instanceof J.FieldAccess) {
                var = ((J.FieldAccess)expression).getName().getFieldType();
            }
            if (var != null) {
                return var.hasFlags(new Flag[]{Flag.Static, Flag.Final});
            }
            if (jupiterAssertIterableEqualsMatcher.matches((MethodCall)mi)) {
                for (MethodMatcher iterableMatcher : this.newListMatchers) {
                    if (!iterableMatcher.matches(expression)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean isJupiterAssertion(J.MethodInvocation mi) {
            for (MethodMatcher assertionMethodMatcher : jupiterAssertionMatchers) {
                if (!assertionMethodMatcher.matches((MethodCall)mi)) continue;
                return true;
            }
            return jupiterAssertIterableEqualsMatcher.matches((MethodCall)mi) || jupiterAssertNullMatcher.matches((MethodCall)mi);
        }

        private boolean isTestNgAssertion(J.MethodInvocation mi) {
            for (MethodMatcher actExpMatcher : testNgMatcher) {
                if (!actExpMatcher.matches((MethodCall)mi)) continue;
                return true;
            }
            return false;
        }

        private boolean isJunitAssertion(J.MethodInvocation mi) {
            for (MethodMatcher assertionMethodMatcher : junitAssertMatchers) {
                if (!assertionMethodMatcher.matches((MethodCall)mi)) continue;
                return true;
            }
            return false;
        }

        private boolean isJunitAssertEqualsWithMessage(J.MethodInvocation mi) {
            for (MethodMatcher actExpMatcher : junitAssertWithMessageMatchers) {
                if (!actExpMatcher.matches((MethodCall)mi)) continue;
                return true;
            }
            return false;
        }
    }
}

