/*
 * Decompiled with CFR 0.152.
 */
package javafx.beans.binding;

import com.sun.javafx.binding.StringFormatter;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.MapBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.value.ObservableMapValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;

public abstract class MapExpression<K, V>
implements ObservableMapValue<K, V> {
    private static final ObservableMap EMPTY_MAP = new EmptyObservableMap();

    @Override
    public ObservableMap<K, V> getValue() {
        return (ObservableMap)this.get();
    }

    public static <K, V> MapExpression<K, V> mapExpression(final ObservableMapValue<K, V> value) {
        if (value == null) {
            throw new NullPointerException("Map must be specified.");
        }
        return value instanceof MapExpression ? (MapExpression<K, V>)value : new MapBinding<K, V>(){
            {
                super.bind(value);
            }

            @Override
            public void dispose() {
                super.unbind(value);
            }

            @Override
            protected ObservableMap<K, V> computeValue() {
                return (ObservableMap)value.get();
            }

            @Override
            public ObservableList<?> getDependencies() {
                return FXCollections.singletonObservableList(value);
            }
        };
    }

    public int getSize() {
        return this.size();
    }

    public abstract ReadOnlyIntegerProperty sizeProperty();

    public abstract ReadOnlyBooleanProperty emptyProperty();

    public ObjectBinding<V> valueAt(K key) {
        return Bindings.valueAt(this, key);
    }

    public ObjectBinding<V> valueAt(ObservableValue<K> key) {
        return Bindings.valueAt(this, key);
    }

    public BooleanBinding isEqualTo(ObservableMap<?, ?> other) {
        return Bindings.equal(this, other);
    }

    public BooleanBinding isNotEqualTo(ObservableMap<?, ?> other) {
        return Bindings.notEqual(this, other);
    }

    public BooleanBinding isNull() {
        return Bindings.isNull(this);
    }

    public BooleanBinding isNotNull() {
        return Bindings.isNotNull(this);
    }

    public StringBinding asString() {
        return (StringBinding)StringFormatter.convert(this);
    }

    @Override
    public int size() {
        ObservableMap map = (ObservableMap)this.get();
        return map == null ? EMPTY_MAP.size() : map.size();
    }

    @Override
    public boolean isEmpty() {
        ObservableMap map = (ObservableMap)this.get();
        return map == null ? EMPTY_MAP.isEmpty() : map.isEmpty();
    }

    @Override
    public boolean containsKey(Object obj) {
        ObservableMap map = (ObservableMap)this.get();
        return map == null ? EMPTY_MAP.containsKey(obj) : map.containsKey(obj);
    }

    @Override
    public boolean containsValue(Object obj) {
        ObservableMap map = (ObservableMap)this.get();
        return map == null ? EMPTY_MAP.containsValue(obj) : map.containsValue(obj);
    }

    @Override
    public V put(K key, V value) {
        ObservableMap map = (ObservableMap)this.get();
        return map == null ? EMPTY_MAP.put(key, value) : map.put(key, value);
    }

    @Override
    public V remove(Object obj) {
        ObservableMap map = (ObservableMap)this.get();
        return map == null ? EMPTY_MAP.remove(obj) : map.remove(obj);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> elements) {
        ObservableMap map = (ObservableMap)this.get();
        if (map == null) {
            EMPTY_MAP.putAll(elements);
        } else {
            map.putAll(elements);
        }
    }

    @Override
    public void clear() {
        ObservableMap map = (ObservableMap)this.get();
        if (map == null) {
            EMPTY_MAP.clear();
        } else {
            map.clear();
        }
    }

    @Override
    public Set<K> keySet() {
        ObservableMap map = (ObservableMap)this.get();
        return map == null ? EMPTY_MAP.keySet() : map.keySet();
    }

    @Override
    public Collection<V> values() {
        ObservableMap map = (ObservableMap)this.get();
        return map == null ? EMPTY_MAP.values() : map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        ObservableMap map = (ObservableMap)this.get();
        return map == null ? EMPTY_MAP.entrySet() : map.entrySet();
    }

    @Override
    public V get(Object key) {
        ObservableMap map = (ObservableMap)this.get();
        return map == null ? EMPTY_MAP.get(key) : map.get(key);
    }

    private static class EmptyObservableMap<K, V>
    extends AbstractMap<K, V>
    implements ObservableMap<K, V> {
        private EmptyObservableMap() {
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return Collections.emptySet();
        }

        @Override
        public void addListener(MapChangeListener<? super K, ? super V> mapChangeListener) {
        }

        @Override
        public void removeListener(MapChangeListener<? super K, ? super V> mapChangeListener) {
        }

        @Override
        public void addListener(InvalidationListener listener) {
        }

        @Override
        public void removeListener(InvalidationListener listener) {
        }
    }
}

