/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.reflect;

import java.lang.reflect.Proxy;

public final class ReflectUtil {
    public static final String PROXY_PACKAGE = "com.sun.proxy";

    private ReflectUtil() {
    }

    public static void checkPackageAccess(Class<?> clazz) {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            ReflectUtil.privateCheckPackageAccess(s, clazz);
        }
    }

    private static void privateCheckPackageAccess(SecurityManager s, Class<?> clazz) {
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        String pkg = clazz.getPackageName();
        if (pkg != null && !pkg.isEmpty()) {
            s.checkPackageAccess(pkg);
        }
        if (ReflectUtil.isNonPublicProxyClass(clazz)) {
            ReflectUtil.privateCheckProxyPackageAccess(s, clazz);
        }
    }

    public static void checkPackageAccess(String name) {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            int i;
            int b;
            String cname = name.replace('/', '.');
            if (cname.startsWith("[") && (b = cname.lastIndexOf(91) + 2) > 1 && b < cname.length()) {
                cname = cname.substring(b);
            }
            if ((i = cname.lastIndexOf(46)) != -1) {
                s.checkPackageAccess(cname.substring(0, i));
            }
        }
    }

    public static boolean isPackageAccessible(Class<?> clazz) {
        try {
            ReflectUtil.checkPackageAccess(clazz);
        }
        catch (SecurityException e) {
            return false;
        }
        return true;
    }

    private static void privateCheckProxyPackageAccess(SecurityManager s, Class<?> clazz) {
        if (Proxy.isProxyClass(clazz)) {
            for (Class<?> intf : clazz.getInterfaces()) {
                ReflectUtil.privateCheckPackageAccess(s, intf);
            }
        }
    }

    public static boolean isNonPublicProxyClass(Class<?> cls) {
        if (!Proxy.isProxyClass(cls)) {
            return false;
        }
        String pkg = cls.getPackageName();
        return pkg == null || !pkg.startsWith(PROXY_PACKAGE);
    }
}

