/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.validations.oas;

import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.validation.GenericValidator;
import org.openapitools.codegen.validation.ValidationRule;
import org.openapitools.codegen.validations.oas.ParameterWrapper;
import org.openapitools.codegen.validations.oas.RuleConfiguration;
import org.openapitools.codegen.validations.oas.ValidationConstants;

class OpenApiParameterValidations
extends GenericValidator<ParameterWrapper> {
    OpenApiParameterValidations(RuleConfiguration ruleConfiguration) {
        super(new ArrayList());
        if (ruleConfiguration.isEnableRecommendations() && ruleConfiguration.isEnableApacheNginxUnderscoreRecommendation()) {
            this.rules.add(ValidationRule.warn((String)ValidationConstants.ApacheNginxUnderscoreDescription, (String)ValidationConstants.ApacheNginxUnderscoreFailureMessage, OpenApiParameterValidations::apacheNginxHeaderCheck));
        }
    }

    private static ValidationRule.Result apacheNginxHeaderCheck(ParameterWrapper parameterWrapper) {
        Parameter parameter = parameterWrapper.getParameter();
        if (parameter == null || !"header".equals(parameter.getIn())) {
            return ValidationRule.Pass.empty();
        }
        ValidationRule.Result result = ValidationRule.Pass.empty();
        String headerName = parameter.getName();
        if (StringUtils.isNotEmpty((CharSequence)headerName) && StringUtils.contains((CharSequence)headerName, (int)95)) {
            result = new ValidationRule.Fail();
            result.setDetails(String.format(Locale.ROOT, "%s contains an underscore.", headerName));
        }
        return result;
    }
}

