/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneOfImplementorAdditionalData {
    private String implementorName;
    private List<String> additionalInterfaces = new ArrayList<String>();
    private List<CodegenProperty> additionalProps = new ArrayList<CodegenProperty>();
    private List<Map<String, String>> additionalImports = new ArrayList<Map<String, String>>();
    private final Logger LOGGER = LoggerFactory.getLogger(OneOfImplementorAdditionalData.class);

    public OneOfImplementorAdditionalData(String implementorName) {
        this.implementorName = implementorName;
    }

    public String getImplementorName() {
        return this.implementorName;
    }

    public void addFromInterfaceModel(CodegenModel cm, List<Map<String, String>> modelsImports) {
        this.additionalInterfaces.add(cm.classname);
        ArrayList<CodegenProperty> toAdd = new ArrayList<CodegenProperty>(cm.vars);
        HashSet<String> omitAdding = new HashSet<String>();
        if (cm.interfaceModels != null) {
            for (CodegenModel codegenModel : cm.interfaceModels) {
                for (CodegenProperty v : codegenModel.vars) {
                    omitAdding.add(v.baseName);
                }
                for (CodegenProperty v : codegenModel.allVars) {
                    omitAdding.add(v.baseName);
                }
            }
        }
        for (CodegenProperty codegenProperty : toAdd) {
            if (omitAdding.contains(codegenProperty.baseName)) continue;
            this.additionalProps.add(codegenProperty.clone());
        }
        for (Map map : modelsImports) {
            this.additionalImports.add(new HashMap(map));
        }
    }

    public void addToImplementor(CodegenConfig cc, CodegenModel implcm, List<Map<String, String>> implImports, boolean addInterfaceImports) {
        implcm.getVendorExtensions().putIfAbsent("x-implements", new ArrayList());
        for (String string : this.additionalInterfaces) {
            List impl = (List)implcm.getVendorExtensions().get("x-implements");
            impl.add(string);
            if (!addInterfaceImports) continue;
            implcm.imports.add(string);
            HashMap<String, String> importsItem = new HashMap<String, String>();
            importsItem.put("import", cc.toModelImport(string));
            implImports.add(importsItem);
        }
        implcm.vars.addAll(this.additionalProps);
        implcm.hasVars = !implcm.vars.isEmpty();
        for (Map map : this.additionalImports) {
            if (implImports.contains(map) || map.getOrDefault("import", "").startsWith(cc.modelPackage())) continue;
            implImports.add(map);
        }
    }

    public String toString() {
        return "OneOfImplementorAdditionalData{implementorName='" + this.implementorName + '\'' + ", additionalInterfaces=" + this.additionalInterfaces + ", additionalProps=" + this.additionalProps + ", additionalImports=" + this.additionalImports + '}';
    }
}

