/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractJavaJAXRSServerCodegen;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;

public class JavaMSF4JServerCodegen
extends AbstractJavaJAXRSServerCodegen {
    protected static final String LIBRARY_JERSEY1 = "jersey1";
    protected static final String LIBRARY_JERSEY2 = "jersey2";
    public static final String DEFAULT_MSF4J_LIBRARY = "jersey2";

    public JavaMSF4JServerCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}));
        this.outputFolder = "generated-code/JavaJaxRS-MSF4J";
        this.apiTemplateFiles.put("apiService.mustache", ".java");
        this.apiTemplateFiles.put("apiServiceImpl.mustache", ".java");
        this.apiTemplateFiles.put("apiServiceFactory.mustache", ".java");
        this.apiTestTemplateFiles.clear();
        this.modelDocTemplateFiles.remove("model_doc.mustache");
        this.apiDocTemplateFiles.remove("api_doc.mustache");
        this.templateDir = "java-msf4j-server";
        this.embeddedTemplateDir = "java-msf4j-server";
        CliOption library = new CliOption("library", "library template (sub-template)");
        this.supportedLibraries.put(LIBRARY_JERSEY1, "Jersey core 1.x");
        this.supportedLibraries.put("jersey2", "Jersey core 2.x");
        library.setEnum(this.supportedLibraries);
        library.setDefault("jersey2");
        this.cliOptions.add(library);
    }

    @Override
    public String getName() {
        return "java-msf4j";
    }

    @Override
    public String getHelp() {
        return "Generates a Java Micro Service based on WSO2 Microservices Framework for Java (MSF4J)";
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        if ("null".equals(property.example)) {
            property.example = null;
        }
        if (!BooleanUtils.toBoolean((Boolean)model.isEnum)) {
            model.imports.add("JsonProperty");
            if (BooleanUtils.toBoolean((Boolean)model.hasEnums)) {
                model.imports.add("JsonValue");
            }
        }
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (StringUtils.isEmpty((CharSequence)this.library)) {
            this.setLibrary("jersey2");
        }
        if (this.additionalProperties.containsKey("implFolder")) {
            this.implFolder = (String)this.additionalProperties.get("implFolder");
        }
        if ("joda".equals(this.dateLibrary)) {
            this.supportingFiles.add(new SupportingFile("JodaDateTimeProvider.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "JodaDateTimeProvider.java"));
            this.supportingFiles.add(new SupportingFile("JodaLocalDateProvider.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "JodaLocalDateProvider.java"));
        } else if (this.dateLibrary.startsWith("java8")) {
            this.supportingFiles.add(new SupportingFile("OffsetDateTimeProvider.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "OffsetDateTimeProvider.java"));
            this.supportingFiles.add(new SupportingFile("LocalDateProvider.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "LocalDateProvider.java"));
        }
        this.supportingFiles.add(new SupportingFile("pom.mustache", "", "pom.xml").doNotOverwrite());
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md").doNotOverwrite());
        this.supportingFiles.add(new SupportingFile("ApiException.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "ApiException.java"));
        this.supportingFiles.add(new SupportingFile("ApiOriginFilter.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "ApiOriginFilter.java"));
        this.supportingFiles.add(new SupportingFile("ApiResponseMessage.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "ApiResponseMessage.java"));
        this.supportingFiles.add(new SupportingFile("NotFoundException.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "NotFoundException.java"));
        this.supportingFiles.add(new SupportingFile("jacksonJsonProvider.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "JacksonJsonProvider.java"));
        this.supportingFiles.add(new SupportingFile("RFC3339DateFormat.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "RFC3339DateFormat.java"));
        this.supportingFiles.add(new SupportingFile("StringUtil.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "StringUtil.java"));
        this.supportingFiles.add(new SupportingFile("Application.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "Application.java"));
    }

    @Override
    public ModelsMap postProcessModelsEnum(ModelsMap objs) {
        objs = super.postProcessModelsEnum(objs);
        List<Map<String, String>> imports = objs.getImports();
        for (ModelMap mo : objs.getModels()) {
            CodegenModel cm = mo.getModel();
            if (!Boolean.TRUE.equals(cm.isEnum) || cm.allowableValues == null) continue;
            cm.imports.add((String)this.importMapping.get("JsonValue"));
            HashMap item = new HashMap();
            item.put("import", this.importMapping.get("JsonValue"));
            imports.add(item);
        }
        return objs;
    }
}

