/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjcClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjcClientCodegen.class);
    public static final String CLASS_PREFIX = "classPrefix";
    public static final String POD_NAME = "podName";
    public static final String AUTHOR_NAME = "authorName";
    public static final String AUTHOR_EMAIL = "authorEmail";
    public static final String LICENSE = "license";
    public static final String GIT_REPO_URL = "gitRepoURL";
    public static final String DEFAULT_LICENSE = "Proprietary";
    public static final String CORE_DATA = "coreData";
    protected Set<String> foundationClasses = new HashSet<String>();
    protected String podName = "OpenAPIClient";
    protected String podVersion = "1.0.0";
    protected String classPrefix = "OAI";
    protected String authorName = "OpenAPI";
    protected String authorEmail = "team@openapitools.org";
    protected String license = "Proprietary";
    protected String gitRepoURL = "https://github.com/openapitools/openapi-generator";
    protected String[] specialWords = new String[]{"new", "copy"};
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";
    protected String modelFilesPath = "Model/";
    protected String coreFilesPath = "Core/";
    protected String apiFilesPath = "Api/";
    protected boolean generateCoreData = false;
    protected Set<String> advancedMapingTypes = new HashSet<String>();

    public ObjcClientCodegen() {
        this.featureSet = this.getFeatureSet().modify().includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON)).securityFeatures(EnumSet.of(SecurityFeature.BasicAuth, SecurityFeature.ApiKey, SecurityFeature.OAuth2_Implicit)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).includeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).includeClientModificationFeatures(new ClientModificationFeature[]{ClientModificationFeature.BasePath, ClientModificationFeature.UserAgent}).build();
        this.supportsInheritance = true;
        this.outputFolder = "generated-code" + File.separator + "objc";
        this.modelTemplateFiles.put("model-header.mustache", ".h");
        this.modelTemplateFiles.put("model-body.mustache", ".m");
        this.apiTemplateFiles.put("api-header.mustache", ".h");
        this.apiTemplateFiles.put("api-body.mustache", ".m");
        this.templateDir = "objc";
        this.embeddedTemplateDir = "objc";
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.hideGenerationTimestamp = Boolean.TRUE;
        this.defaultIncludes.clear();
        this.defaultIncludes.add("bool");
        this.defaultIncludes.add("BOOL");
        this.defaultIncludes.add("int");
        this.defaultIncludes.add("NSURL");
        this.defaultIncludes.add("NSString");
        this.defaultIncludes.add("NSObject");
        this.defaultIncludes.add("NSArray");
        this.defaultIncludes.add("NSNumber");
        this.defaultIncludes.add("NSDate");
        this.defaultIncludes.add("NSDictionary");
        this.defaultIncludes.add("NSMutableArray");
        this.defaultIncludes.add("NSMutableDictionary");
        this.defaultIncludes.add("NSManagedObject");
        this.defaultIncludes.add("NSData");
        this.advancedMapingTypes.add("NSDictionary");
        this.advancedMapingTypes.add("NSArray");
        this.advancedMapingTypes.add("NSMutableArray");
        this.advancedMapingTypes.add("NSMutableDictionary");
        this.advancedMapingTypes.add("NSObject");
        this.advancedMapingTypes.add("NSNumber");
        this.advancedMapingTypes.add("NSURL");
        this.advancedMapingTypes.add("NSString");
        this.advancedMapingTypes.add("NSDate");
        this.languageSpecificPrimitives.clear();
        this.languageSpecificPrimitives.add("NSNumber");
        this.languageSpecificPrimitives.add("NSString");
        this.languageSpecificPrimitives.add("NSObject");
        this.languageSpecificPrimitives.add("NSDate");
        this.languageSpecificPrimitives.add("NSData");
        this.languageSpecificPrimitives.add("NSURL");
        this.languageSpecificPrimitives.add("bool");
        this.languageSpecificPrimitives.add("BOOL");
        this.typeMapping.clear();
        this.typeMapping.put("enum", "NSString");
        this.typeMapping.put("date", "NSDate");
        this.typeMapping.put("datetime", "NSDate");
        this.typeMapping.put("boolean", "NSNumber");
        this.typeMapping.put("string", "NSString");
        this.typeMapping.put("integer", "NSNumber");
        this.typeMapping.put("int", "NSNumber");
        this.typeMapping.put("float", "NSNumber");
        this.typeMapping.put("long", "NSNumber");
        this.typeMapping.put("double", "NSNumber");
        this.typeMapping.put("array", "NSArray");
        this.typeMapping.put("map", "NSDictionary");
        this.typeMapping.put("number", "NSNumber");
        this.typeMapping.put("bigdecimal", "NSNumber");
        this.typeMapping.put("List", "NSArray");
        this.typeMapping.put("object", "NSObject");
        this.typeMapping.put("file", "NSURL");
        this.typeMapping.put("binary", "NSURL");
        this.typeMapping.put("bytearray", "NSData");
        this.typeMapping.put("byte", "NSData");
        this.typeMapping.put("uuid", "NSString");
        this.typeMapping.put("uri", "NSString");
        this.typeMapping.put("password", "NSString");
        this.setReservedWordsLowerCase(Arrays.asList("resourcePath", "pathParams", "queryParams", "headerParams", "responseContentType", "requestContentType", "authSettings", "formParams", "localVarFiles", "bodyParam", "auto", "else", "long", "switch", "break", "enum", "register", "typedef", "case", "extern", "return", "union", "char", "float", "short", "unsigned", "const", "for", "signed", "void", "continue", "goto", "sizeof", "volatile", "default", "if", "id", "static", "while", "do", "int", "struct", "_Packed", "double", "protocol", "interface", "implementation", "NSObject", "NSInteger", "NSNumber", "CGFloat", "property", "nonatomic", "retain", "strong", "weak", "unsafe_unretained", "readwrite", "readonly", "description", "class"));
        this.importMapping = new HashMap();
        this.foundationClasses = new HashSet<String>(Arrays.asList("NSNumber", "NSObject", "NSString", "NSDate", "NSData", "NSURL", "NSDictionary"));
        this.instantiationTypes.put("array", "NSMutableArray");
        this.instantiationTypes.put("map", "NSMutableDictionary");
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption(CORE_DATA, "Should generate core data models").defaultValue("false"));
        this.cliOptions.add(new CliOption(CLASS_PREFIX, "prefix for generated classes (convention: Abbreviation of pod name e.g. `HN` for `HackerNews`).`").defaultValue("OAI"));
        this.cliOptions.add(new CliOption(POD_NAME, "cocoapods package name (convention: CameCase).").defaultValue("OpenAPIClient"));
        this.cliOptions.add(new CliOption("podVersion", "cocoapods package version.").defaultValue("1.0.0"));
        this.cliOptions.add(new CliOption(AUTHOR_NAME, "Name to use in the podspec file.").defaultValue("OpenAPI"));
        this.cliOptions.add(new CliOption(AUTHOR_EMAIL, "Email to use in the podspec file.").defaultValue("team@openapitools.org"));
        this.cliOptions.add(new CliOption(GIT_REPO_URL, "URL for the git repo where this podspec should point to.").defaultValue("https://github.com/openapitools/openapi-generator"));
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "Hides the generation timestamp when files are generated.").defaultValue(Boolean.TRUE.toString()));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "objc";
    }

    @Override
    public String getHelp() {
        return "Generates an Objective-C client library.";
    }

    @Override
    public void processOpts() {
        Object coreData;
        super.processOpts();
        if (this.additionalProperties.containsKey(POD_NAME)) {
            this.setPodName((String)this.additionalProperties.get(POD_NAME));
        }
        if (this.additionalProperties.containsKey("podVersion")) {
            this.setPodVersion((String)this.additionalProperties.get("podVersion"));
        }
        if (this.additionalProperties.containsKey(CORE_DATA) && ((String)(coreData = this.additionalProperties.get(CORE_DATA))).equalsIgnoreCase("true")) {
            this.generateCoreData = true;
        }
        if (this.additionalProperties.containsKey(CLASS_PREFIX)) {
            this.setClassPrefix((String)this.additionalProperties.get(CLASS_PREFIX));
        }
        if (this.additionalProperties.containsKey(AUTHOR_NAME)) {
            this.setAuthorName((String)this.additionalProperties.get(AUTHOR_NAME));
        }
        if (this.additionalProperties.containsKey(AUTHOR_EMAIL)) {
            this.setAuthorEmail((String)this.additionalProperties.get(AUTHOR_EMAIL));
        }
        if (this.additionalProperties.containsKey(GIT_REPO_URL)) {
            this.setGitRepoURL((String)this.additionalProperties.get(GIT_REPO_URL));
        }
        if (this.generateCoreData) {
            this.modelTemplateFiles.put("NSManagedObject-header.mustache", "ManagedObject.h");
            this.modelTemplateFiles.put("NSManagedObject-body.mustache", "ManagedObject.m");
            this.modelTemplateFiles.put("NSManagedObjectBuilder-header.mustache", "ManagedObjectBuilder.h");
            this.modelTemplateFiles.put("NSManagedObjectBuilder-body.mustache", "ManagedObjectBuilder.m");
        }
        this.additionalProperties.put(POD_NAME, this.podName);
        this.additionalProperties.put("podVersion", this.podVersion);
        this.additionalProperties.put(CLASS_PREFIX, this.classPrefix);
        this.additionalProperties.put(AUTHOR_NAME, this.authorName);
        this.additionalProperties.put(AUTHOR_EMAIL, this.authorEmail);
        this.additionalProperties.put(GIT_REPO_URL, this.gitRepoURL);
        this.additionalProperties.put(LICENSE, this.license);
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        this.additionalProperties.put("useCoreData", this.generateCoreData);
        this.modelPackage = this.podName;
        this.apiPackage = this.podName;
        this.supportingFiles.add(new SupportingFile("Object-header.mustache", this.coreFileFolder(), this.classPrefix + "Object.h"));
        this.supportingFiles.add(new SupportingFile("Object-body.mustache", this.coreFileFolder(), this.classPrefix + "Object.m"));
        this.supportingFiles.add(new SupportingFile("QueryParamCollection-header.mustache", this.coreFileFolder(), this.classPrefix + "QueryParamCollection.h"));
        this.supportingFiles.add(new SupportingFile("QueryParamCollection-body.mustache", this.coreFileFolder(), this.classPrefix + "QueryParamCollection.m"));
        this.supportingFiles.add(new SupportingFile("ApiClient-header.mustache", this.coreFileFolder(), this.classPrefix + "ApiClient.h"));
        this.supportingFiles.add(new SupportingFile("ApiClient-body.mustache", this.coreFileFolder(), this.classPrefix + "ApiClient.m"));
        this.supportingFiles.add(new SupportingFile("JSONRequestSerializer-body.mustache", this.coreFileFolder(), this.classPrefix + "JSONRequestSerializer.m"));
        this.supportingFiles.add(new SupportingFile("JSONRequestSerializer-header.mustache", this.coreFileFolder(), this.classPrefix + "JSONRequestSerializer.h"));
        this.supportingFiles.add(new SupportingFile("ResponseDeserializer-body.mustache", this.coreFileFolder(), this.classPrefix + "ResponseDeserializer.m"));
        this.supportingFiles.add(new SupportingFile("ResponseDeserializer-header.mustache", this.coreFileFolder(), this.classPrefix + "ResponseDeserializer.h"));
        this.supportingFiles.add(new SupportingFile("Sanitizer-body.mustache", this.coreFileFolder(), this.classPrefix + "Sanitizer.m"));
        this.supportingFiles.add(new SupportingFile("Sanitizer-header.mustache", this.coreFileFolder(), this.classPrefix + "Sanitizer.h"));
        this.supportingFiles.add(new SupportingFile("Logger-body.mustache", this.coreFileFolder(), this.classPrefix + "Logger.m"));
        this.supportingFiles.add(new SupportingFile("Logger-header.mustache", this.coreFileFolder(), this.classPrefix + "Logger.h"));
        this.supportingFiles.add(new SupportingFile("JSONValueTransformer+ISO8601-body.mustache", this.coreFileFolder(), "JSONValueTransformer+ISO8601.m"));
        this.supportingFiles.add(new SupportingFile("JSONValueTransformer+ISO8601-header.mustache", this.coreFileFolder(), "JSONValueTransformer+ISO8601.h"));
        this.supportingFiles.add(new SupportingFile("Configuration-protocol.mustache", this.coreFileFolder(), this.classPrefix + "Configuration.h"));
        this.supportingFiles.add(new SupportingFile("DefaultConfiguration-body.mustache", this.coreFileFolder(), this.classPrefix + "DefaultConfiguration.m"));
        this.supportingFiles.add(new SupportingFile("DefaultConfiguration-header.mustache", this.coreFileFolder(), this.classPrefix + "DefaultConfiguration.h"));
        this.supportingFiles.add(new SupportingFile("BasicAuthTokenProvider-header.mustache", this.coreFileFolder(), this.classPrefix + "BasicAuthTokenProvider.h"));
        this.supportingFiles.add(new SupportingFile("BasicAuthTokenProvider-body.mustache", this.coreFileFolder(), this.classPrefix + "BasicAuthTokenProvider.m"));
        this.supportingFiles.add(new SupportingFile("api-protocol.mustache", this.coreFileFolder(), this.classPrefix + "Api.h"));
        this.supportingFiles.add(new SupportingFile("podspec.mustache", "", this.podName + ".podspec"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        if (this.generateCoreData) {
            this.supportingFiles.add(new SupportingFile("xccurrentversion.mustache", (this.modelPackage() + "/" + this.modelFilesPath + "/").replace("/", File.separator) + this.classPrefix + "Model.xcdatamodeld", ".xccurrentversion"));
            this.supportingFiles.add(new SupportingFile("Model.xcdatamodel.mustache", (this.modelPackage() + "/" + this.modelFilesPath + "/").replace("/", File.separator) + this.classPrefix + "Model.xcdatamodeld" + File.separator + this.classPrefix + "Model.xcdatamodel", "contents"));
        }
    }

    @Override
    public String toInstantiationType(Schema p) {
        if (ModelUtils.isMapSchema(p)) {
            return (String)this.instantiationTypes.get("map");
        }
        if (ModelUtils.isArraySchema(p)) {
            return (String)this.instantiationTypes.get("array");
        }
        return null;
    }

    @Override
    public String getTypeDeclaration(String name) {
        if (this.languageSpecificPrimitives.contains(name) && !this.foundationClasses.contains(name)) {
            return name;
        }
        return name + "*";
    }

    @Override
    public String getSchemaType(Schema p) {
        String openAPIType = super.getSchemaType(p);
        String type = null;
        if (openAPIType == null) {
            openAPIType = "";
        }
        if (this.typeMapping.containsKey(openAPIType.toLowerCase(Locale.ROOT))) {
            type = (String)this.typeMapping.get(openAPIType.toLowerCase(Locale.ROOT));
            if (this.languageSpecificPrimitives.contains(type) && !this.foundationClasses.contains(type)) {
                return this.toModelNameWithoutReservedWordCheck(type);
            }
        } else {
            type = openAPIType;
        }
        return this.toModelNameWithoutReservedWordCheck(type);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            String innerTypeDeclaration = this.getTypeDeclaration(inner);
            if (innerTypeDeclaration.endsWith("*")) {
                innerTypeDeclaration = innerTypeDeclaration.substring(0, innerTypeDeclaration.length() - 1);
            }
            if (this.languageSpecificPrimitives.contains(innerTypeDeclaration)) {
                return this.getSchemaType(p) + "<" + innerTypeDeclaration + "*>*";
            }
            for (String sd : this.advancedMapingTypes) {
                if (!innerTypeDeclaration.startsWith(sd)) continue;
                return this.getSchemaType(p) + "<" + innerTypeDeclaration + "*>*";
            }
            return this.getSchemaType(p) + "<" + innerTypeDeclaration + ">*";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            String innerTypeDeclaration = this.getTypeDeclaration(inner);
            if (innerTypeDeclaration.endsWith("*")) {
                innerTypeDeclaration = innerTypeDeclaration.substring(0, innerTypeDeclaration.length() - 1);
            }
            if (this.languageSpecificPrimitives.contains(innerTypeDeclaration)) {
                return this.getSchemaType(p) + "<NSString*, " + innerTypeDeclaration + "*>*";
            }
            for (String s : this.advancedMapingTypes) {
                if (!innerTypeDeclaration.startsWith(s)) continue;
                return this.getSchemaType(p) + "<NSString*, " + innerTypeDeclaration + "*>*";
            }
            return this.getSchemaType(p) + "<" + innerTypeDeclaration + ">*";
        }
        String openAPIType = this.getSchemaType(p);
        if (this.languageSpecificPrimitives.contains(openAPIType) && this.foundationClasses.contains(openAPIType)) {
            return openAPIType + "*";
        }
        if (this.languageSpecificPrimitives.contains(openAPIType)) {
            return openAPIType;
        }
        return openAPIType + "*";
    }

    @Override
    public boolean isDataTypeBinary(String dataType) {
        return dataType.toLowerCase(Locale.ROOT).startsWith("nsdata");
    }

    @Override
    public String toModelName(String type) {
        if (this.reservedWords.contains(type)) {
            LOGGER.warn(type + " (reserved word) cannot be used as model name. Renamed to " + "model_" + type + " before further processing");
            type = "model_" + type;
        }
        return this.toModelNameWithoutReservedWordCheck(type);
    }

    public String toModelNameWithoutReservedWordCheck(String type) {
        type = type.replaceAll("[^0-9a-zA-Z_]", "_");
        if (this.typeMapping.keySet().contains(type) || this.foundationClasses.contains(type) || this.importMapping.values().contains(type) || this.defaultIncludes.contains(type) || this.languageSpecificPrimitives.contains(type)) {
            return StringUtils.camelize(type);
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            type = type + "_" + this.modelNameSuffix;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            type = this.modelNamePrefix + "_" + type;
        }
        return this.classPrefix + StringUtils.camelize(type);
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    protected void setNonArrayMapProperty(CodegenProperty schema, String type) {
        super.setNonArrayMapProperty(schema, type);
        schema.setter = "NSDictionary".equals(type) ? "initWithDictionary" : "initWithValues";
    }

    @Override
    public String toModelImport(String name) {
        return name;
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace("/", File.separator);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace("/", File.separator);
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String apiFileFolder() {
        return (this.outputFolder + "/" + this.apiPackage() + "/" + this.apiFilesPath).replace("/", File.separator);
    }

    @Override
    public String modelFileFolder() {
        return (this.outputFolder + "/" + this.modelPackage() + "/" + this.modelFilesPath).replace("/", File.separator);
    }

    public String coreFileFolder() {
        return (this.apiPackage() + "/" + this.coreFilesPath).replace("/", File.separator);
    }

    @Override
    public String toApiName(String name) {
        return this.classPrefix + StringUtils.camelize(name) + "Api";
    }

    @Override
    public String toApiFilename(String name) {
        return this.classPrefix + StringUtils.camelize(name) + "Api";
    }

    @Override
    public String toVarName(String name) {
        if ((name = this.sanitizeName(name)).matches("^[A-Z_]$")) {
            return name;
        }
        for (String specialWord : this.specialWords) {
            if (!name.matches("(?i:^" + specialWord + ".*)")) continue;
            name = this.escapeSpecialWord(name);
        }
        if (name.startsWith(this.classPrefix)) {
            name = name.replaceFirst(this.classPrefix, "");
        }
        if (this.isReservedWord(name = StringUtils.camelize(name, true)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    public String escapeSpecialWord(String name) {
        return "var_" + name;
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId)) {
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + StringUtils.camelize(this.sanitizeName("call_" + operationId), true));
            operationId = "call_" + operationId;
        }
        return StringUtils.camelize(this.sanitizeName(operationId), true);
    }

    public void setClassPrefix(String classPrefix) {
        this.classPrefix = classPrefix;
    }

    public void setPodName(String podName) {
        this.podName = podName;
    }

    public void setPodVersion(String podVersion) {
        this.podVersion = podVersion;
    }

    public void setAuthorEmail(String authorEmail) {
        this.authorEmail = authorEmail;
    }

    public void setAuthorName(String authorName) {
        this.authorName = authorName;
    }

    public void setGitRepoURL(String gitRepoURL) {
        this.gitRepoURL = gitRepoURL;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map operations = (Map)objs.get("operations");
        if (operations != null) {
            List ops = (List)operations.get("operation");
            for (CodegenOperation operation : ops) {
                if (operation.allParams.isEmpty()) continue;
                String firstParamName = operation.allParams.get((int)0).paramName;
                operation.vendorExtensions.put("firstParamAltName", StringUtils.camelize(firstParamName));
            }
        }
        return objs;
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty schema) {
        super.postProcessModelProperty(model, schema);
        schema.vendorExtensions.put("x-uppercaseName", StringUtils.camelize(schema.name));
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (!ModelUtils.isDateSchema(p) && !ModelUtils.isDateTimeSchema(p)) {
            if (ModelUtils.isNumberSchema(p)) {
                if (p.getDefault() != null) {
                    return "@" + p.getDefault().toString();
                }
            } else if (ModelUtils.isIntegerSchema(p)) {
                if (p.getDefault() != null) {
                    return "@" + p.getDefault().toString();
                }
            } else if (ModelUtils.isStringSchema(p)) {
                if (p.getDefault() != null) {
                    return "@\"" + (String)p.getDefault() + "\"";
                }
            } else if (ModelUtils.isBooleanSchema(p) && p.getDefault() != null) {
                if (p.getDefault().toString().equalsIgnoreCase("false")) {
                    return "@(NO)";
                }
                return "@(YES)";
            }
        }
        return null;
    }

    @Override
    public void setParameterExampleValue(CodegenParameter p) {
        if (p.defaultValue != null) {
            p.example = p.defaultValue;
            return;
        }
        String example = p.example;
        String type = p.baseType;
        if (type == null) {
            type = p.dataType;
        }
        if ("NSString*".equalsIgnoreCase(type) || "NSString".equalsIgnoreCase(type)) {
            if (example == null) {
                example = p.paramName + "_example";
            }
            example = "@\"" + this.escapeText(example) + "\"";
        } else if ("NSNumber*".equalsIgnoreCase(type) || "NSNumber".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "56";
            }
            example = "@" + example;
        } else if ("BOOLEAN".equalsIgnoreCase(type) || "bool".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "True";
            }
        } else if ("NSURL*".equalsIgnoreCase(type) || "NSURL".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "/path/to/file";
            }
            example = "[NSURL fileURLWithPath:@\"" + this.escapeText(example) + "\"]";
        } else if ("NSDate*".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "2013-10-20T19:20:30+01:00";
            }
            example = "@\"" + this.escapeText(example) + "\"";
        } else if ("NSData".equalsIgnoreCase(type)) {
            example = "1234";
        } else if (type != null && !this.languageSpecificPrimitives.contains(type)) {
            type = type.replace("*", "");
            example = "[[" + type + " alloc] init]";
        } else {
            LOGGER.warn("Example value for " + type + " not handled properly in setParameterExampleValue");
        }
        if (example == null) {
            example = "NULL";
        } else if (Boolean.TRUE.equals(p.isListContainer)) {
            example = "@[" + example + "]";
        } else if (Boolean.TRUE.equals(p.isMapContainer)) {
            example = "@{@\"key\" : " + example + "}";
        }
        p.example = example;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }
}

