/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.publication;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.ArgumentsParserException;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceFactory;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.search.Search;
import org.nuiton.wikitty.search.TreeNodeResult;
import org.nuiton.wikitty.services.WikittyEvent;
import org.nuiton.wikitty.services.WikittyListener;

public class WikittyPublicationFallbackService
implements WikittyService {
    public static String WIKITTY_FALLBACK_FILE_KEY = "wikitty.fallback.file";
    public static String WIKITTY_FALLBACK_OVERRIDE = "wikitty.fallback.override";
    private static Log log = LogFactory.getLog(WikittyPublicationFallbackService.class);
    protected WikittyService mainService;
    protected WikittyService fallbackService;

    public WikittyPublicationFallbackService(WikittyService serv, ApplicationConfig config) throws ArgumentsParserException {
        this.mainService = serv;
        if (config != null) {
            boolean isOverriding = config.getOptionAsBoolean(WIKITTY_FALLBACK_OVERRIDE);
            String fileName = config.getOption(WIKITTY_FALLBACK_FILE_KEY);
            if (fileName != null) {
                ApplicationConfig confFallBack = isOverriding ? new ApplicationConfig(null, null, config.getFlatOptions(), fileName) : new ApplicationConfig(fileName);
                confFallBack.parse(null);
                this.fallbackService = WikittyServiceFactory.buildWikittyService((ApplicationConfig)confFallBack);
            }
        }
    }

    public boolean isFallBack() {
        return this.fallbackService != null;
    }

    public void addWikittyServiceListener(WikittyListener listener, WikittyService.ServiceListenerType type) {
        this.mainService.addWikittyServiceListener(listener, type);
    }

    public void removeWikittyServiceListener(WikittyListener listener, WikittyService.ServiceListenerType type) {
        this.mainService.removeWikittyServiceListener(listener, type);
    }

    public String login(String login, String password) {
        return this.mainService.login(login, password);
    }

    public void logout(String securityToken) {
        this.mainService.logout(securityToken);
    }

    public WikittyEvent clear(String securityToken) {
        return this.mainService.clear(securityToken);
    }

    public boolean canWrite(String securityToken, Wikitty wikitty) {
        return this.mainService.canWrite(securityToken, wikitty);
    }

    public boolean canDelete(String securityToken, String wikittyId) {
        return this.mainService.canDelete(securityToken, wikittyId);
    }

    public boolean canRead(String securityToken, String wikittyId) {
        return this.mainService.canRead(securityToken, wikittyId);
    }

    public boolean exists(String securityToken, String wikittyId) {
        boolean result = this.mainService.exists(securityToken, wikittyId);
        if (this.isFallBack()) {
            result = result || this.fallbackService.exists(securityToken, wikittyId);
        }
        return result;
    }

    public boolean isDeleted(String securityToken, String wikittyId) {
        boolean result = this.mainService.isDeleted(securityToken, wikittyId);
        if (this.isFallBack()) {
            result = result || this.fallbackService.isDeleted(securityToken, wikittyId);
        }
        return result;
    }

    public WikittyEvent replay(String securityToken, List<WikittyEvent> events, boolean force) {
        return this.mainService.replay(securityToken, events, force);
    }

    public WikittyEvent store(String securityToken, Collection<Wikitty> wikitties, boolean force) {
        return this.mainService.store(securityToken, wikitties, force);
    }

    public List<String> getAllExtensionIds(String securityToken) {
        LinkedList<String> result = new LinkedList<String>();
        result.addAll(this.mainService.getAllExtensionIds(securityToken));
        if (this.isFallBack()) {
            List temp = this.fallbackService.getAllExtensionIds(securityToken);
            result.removeAll(temp);
            result.addAll(temp);
        }
        return result;
    }

    public List<String> getAllExtensionsRequires(String securityToken, String extensionName) {
        LinkedList<String> result = new LinkedList<String>();
        result.addAll(this.mainService.getAllExtensionsRequires(securityToken, extensionName));
        if (this.isFallBack()) {
            List temp = this.fallbackService.getAllExtensionsRequires(securityToken, extensionName);
            result.removeAll(temp);
            result.addAll(temp);
        }
        return result;
    }

    public WikittyEvent storeExtension(String securityToken, Collection<WikittyExtension> exts) {
        return this.mainService.storeExtension(securityToken, exts);
    }

    public WikittyEvent deleteExtension(String securityToken, Collection<String> extNames) {
        return this.mainService.deleteExtension(securityToken, extNames);
    }

    public WikittyExtension restoreExtension(String securityToken, String extensionId) {
        WikittyExtension result = this.mainService.restoreExtension(securityToken, extensionId);
        if (this.isFallBack() && result == null) {
            result = this.fallbackService.restoreExtension(securityToken, extensionId);
        }
        return result;
    }

    public WikittyExtension restoreExtensionLastVersion(String securityToken, String name) {
        WikittyExtension result = this.mainService.restoreExtensionLastVersion(securityToken, name);
        if (this.isFallBack() && result == null) {
            result = this.fallbackService.restoreExtensionLastVersion(securityToken, name);
        }
        return result;
    }

    public List<Wikitty> restore(String securityToken, List<String> id) {
        LinkedList<Wikitty> result = new LinkedList<Wikitty>();
        List tempListResult = this.mainService.restore(securityToken, id);
        for (Wikitty wikitty : tempListResult) {
            if (wikitty == null) continue;
            result.add(wikitty);
        }
        if (this.isFallBack()) {
            LinkedList<String> unusedId = new LinkedList<String>();
            unusedId.addAll(id);
            for (Wikitty wikitty : result) {
                if (wikitty == null) continue;
                unusedId.remove(wikitty.getId());
            }
            result.addAll(this.fallbackService.restore(securityToken, unusedId));
        }
        return result;
    }

    public WikittyEvent delete(String securityToken, Collection<String> ids) {
        return this.mainService.delete(securityToken, ids);
    }

    public List<PagedResult<String>> findAllByCriteria(String securityToken, List<Criteria> criteria) {
        List result = this.mainService.findAllByCriteria(securityToken, criteria);
        if (this.isFallBack()) {
            for (int i = 0; i < result.size(); ++i) {
                Criteria currentCrit = criteria.get(i);
                PagedResult currentResult = (PagedResult)result.get(i);
                int resultSizeExpected = currentCrit.getEndIndex() - currentCrit.getFirstIndex();
                log.debug((Object)("Size expected" + resultSizeExpected));
                if (resultSizeExpected != -1 && currentResult.size() >= resultSizeExpected) continue;
                Criteria critFallback = Search.query((Criteria)currentCrit).criteria();
                critFallback.setFirstIndex(0);
                critFallback.setEndIndex(currentCrit.getEndIndex() - currentCrit.getFirstIndex());
                if (result.size() == 0) {
                    ArrayList<Criteria> tempCritFallBack = new ArrayList<Criteria>();
                    tempCritFallBack.add(critFallback);
                    PagedResult tempPagedResult = (PagedResult)this.fallbackService.findAllByCriteria(securityToken, tempCritFallBack).get(0);
                    tempPagedResult = new PagedResult(currentCrit.getFirstIndex(), tempPagedResult.getNumFound(), currentCrit.toString(), tempPagedResult.getFacets(), tempPagedResult.getAll());
                    result.set(i, tempPagedResult);
                    continue;
                }
                LinkedList<String> fromMainWithoutNull = new LinkedList<String>();
                for (String st : currentResult.getAll()) {
                    if (st == null) continue;
                    fromMainWithoutNull.add(st);
                }
                Criteria excluding = this.idNotInCriteriaConstructor(critFallback, fromMainWithoutNull);
                excluding.setEndIndex(resultSizeExpected - result.size());
                ArrayList<Criteria> tempExcludingCriteriaList = new ArrayList<Criteria>();
                tempExcludingCriteriaList.add(excluding);
                PagedResult resultFallback = (PagedResult)this.fallbackService.findAllByCriteria(securityToken, tempExcludingCriteriaList).get(0);
                LinkedList<String> allresult = new LinkedList<String>();
                allresult.addAll(fromMainWithoutNull);
                allresult.addAll(resultFallback.getAll());
                int number = fromMainWithoutNull.size() + resultFallback.getNumFound();
                PagedResult tempPagedResult = new PagedResult(currentCrit.getFirstIndex(), number, currentCrit.toString(), currentResult.getFacets(), allresult);
                result.set(i, tempPagedResult);
            }
        }
        return result;
    }

    public List<String> findByCriteria(String securityToken, List<Criteria> criteria) {
        LinkedList<String> result = new LinkedList<String>();
        List tempFromMain = this.mainService.findByCriteria(securityToken, criteria);
        for (String st : tempFromMain) {
            if (st == null) continue;
            result.add(st);
        }
        if (this.isFallBack()) {
            if (result.size() == 0) {
                result.addAll(this.fallbackService.findByCriteria(securityToken, criteria));
            } else {
                LinkedList resultFallback = new LinkedList();
                resultFallback.addAll(this.fallbackService.findByCriteria(securityToken, criteria));
                resultFallback.removeAll(result);
                result.addAll(resultFallback);
            }
        }
        if (result.size() == 0) {
            result.add(null);
        }
        return result;
    }

    public WikittyEvent deleteTree(String securityToken, String treeNodeId) {
        return this.mainService.deleteTree(securityToken, treeNodeId);
    }

    public TreeNodeResult<String> findTreeNode(String securityToken, String wikittyId, int depth, boolean count, Criteria filter) {
        TreeNodeResult result = this.mainService.findTreeNode(securityToken, wikittyId, depth, count, filter);
        if (this.isFallBack() && result == null) {
            result = this.fallbackService.findTreeNode(securityToken, wikittyId, depth, count, filter);
        }
        return result;
    }

    public Wikitty restoreVersion(String securityToken, String wikittyId, String version) {
        Wikitty result = this.mainService.restoreVersion(securityToken, wikittyId, version);
        if (this.isFallBack() && result == null) {
            result = this.fallbackService.restoreVersion(securityToken, wikittyId, version);
        }
        return result;
    }

    public void syncSearchEngine(String securityToken) {
        this.mainService.syncSearchEngine(securityToken);
    }

    protected Criteria idNotInCriteriaConstructor(Criteria origin, List<String> toExclude) {
        Search search = Search.query((Criteria)origin);
        for (String id : toExclude) {
            search.idneq(id);
        }
        Criteria result = search.criteria();
        return result;
    }

    public WikittyService getMainService() {
        return this.mainService;
    }

    public void setMainService(WikittyService mainService) {
        this.mainService = mainService;
    }

    public WikittyService getFallbackService() {
        return this.fallbackService;
    }

    public void setFallbackService(WikittyService fallbackService) {
        this.fallbackService = fallbackService;
    }
}

