/* *##%
 * Copyright (C) 2010 Code Lutin, Chatellier Eric
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package org.wikitty.hessian;

import java.net.MalformedURLException;

import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyService;

import com.caucho.hessian.client.HessianProxyFactory;

/**
 * Wikitty hessian client factory.
 * 
 * @author chatellier
 * @version $Revision: 169 $
 * 
 * Last update : $Date: 2010-06-29 15:59:21 +0200 (mar., 29 juin 2010) $
 * By : $Author: echatellier $
 */
public class WikittyHessianFactory {

    /**
     * Get hessian wikitty service proxy on remove endpoint.
     * 
     * @param serviceEndpoint service endpoint (full url)
     * @return hessian proxy implementing {@code WikittyService}
     * @throws WikittyException if hessian proxy can't be created
     */
    public static WikittyService getWikittyService(String serviceEndpoint) throws WikittyException {
        return getService(WikittyService.class, serviceEndpoint);
    }

    /**
     * Get hessian service proxy on remove endpoint.
     * 
     * @param <S> service type
     * @param serviceInterface service interface
     * @param serviceEndpoint service endpoint (full url)
     * @return hessian proxy implementing {@code S}
     * @throws WikittyException if hessian proxy can't be created
     */
    public static <S> S getService(Class<S> serviceInterface, String serviceEndpoint) throws WikittyException {
        
        HessianProxyFactory factory = new HessianProxyFactory();
        // Fix : com.caucho.hessian.io.HessianProtocolException: '���' is an unknown code
        factory.setHessian2Request(true);
        // pour que les méthodes aux noms dupliquées fonctionnent (arguments different)
        factory.setOverloadEnabled(true);

        // service proxy
        S hessianProxy;
        try {
            hessianProxy = (S)factory.create(serviceInterface, serviceEndpoint);
        } catch (MalformedURLException eee) {
            throw new WikittyException("Can't create hessian proxy", eee);
        }

        return hessianProxy;
    }
}
