/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.generator;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;

public class WikittyTransformerUtil {
    protected static final String BUSINESS_ENTITY_CLASS_FQN = "org.nuiton.wikitty.BusinessEntity";
    protected static final String BUSINESS_ENTITY_WIKITTY_CLASS_FQN = "org.nuiton.wikitty.BusinessEntityWikitty";
    protected static final String WIKITTY_CLASS_FQN = "org.nuiton.wikitty.Wikitty";
    protected static final String WIKITTY_EXTENSION_CLASS_FQN = "org.nuiton.wikitty.WikittyExtension";
    protected static final String TAG_VERSION = "version";
    protected static final String TAG_ALTERNATIVE_NAME = "alternativeName";
    protected static final String TAG_TO_STRING = "toString";
    protected static final String TAG_DOCUMENTATION = "documentation";
    @Deprecated
    protected static final String BUSINESS_ENTITY_STEREOTYPE_OLD_NAME = "BusinessEntity";
    protected static final String BUSINESS_ENTITY_STEREOTYPE_NAME = "entity";
    protected static final String META_EXTENSION_STEREOTYPE_NAME = "meta";
    private static Set<String> commonNumerics = new HashSet<String>();
    private static Set<String> commonStrings;
    private static Set<String> commonTypes;

    private WikittyTransformerUtil() {
    }

    protected static String classToExtensionVariableName(ObjectModelClass clazz, boolean withClassNamePrefix) {
        String extensionVariableName = "";
        if (withClassNamePrefix) {
            extensionVariableName = extensionVariableName + clazz.getName() + ".";
        }
        extensionVariableName = extensionVariableName + "EXT_" + clazz.getName().toUpperCase();
        return extensionVariableName;
    }

    protected static String attributeToFielVariableName(ObjectModelAttribute attribute, boolean withClassNamePrefix) {
        String fieldVariableName = "";
        if (withClassNamePrefix) {
            fieldVariableName = fieldVariableName + attribute.getDeclaringElement().getName() + ".";
        }
        fieldVariableName = fieldVariableName + "FIELD_" + attribute.getDeclaringElement().getName().toUpperCase() + "_" + attribute.getName().toUpperCase();
        return fieldVariableName;
    }

    protected static String FQNtoSimpleName(String fqn) {
        int lastDotIndex = fqn.lastIndexOf(".");
        String simpleName = fqn;
        if (lastDotIndex != -1) {
            simpleName = fqn.substring(lastDotIndex + 1);
        }
        return simpleName;
    }

    protected static boolean isBusinessEntity(ObjectModelClass clazz) {
        boolean result = clazz.hasStereotype(BUSINESS_ENTITY_STEREOTYPE_NAME) || clazz.hasStereotype(BUSINESS_ENTITY_STEREOTYPE_OLD_NAME);
        return result;
    }

    public static boolean isMetaExtension(ObjectModelClass clazz) {
        boolean result = clazz.hasStereotype(META_EXTENSION_STEREOTYPE_NAME);
        return result;
    }

    protected static String generateGetFieldAsCall(ObjectModelAttribute attribute) {
        String simpleTypeName;
        String asWhat = null;
        asWhat = WikittyTransformerUtil.isAttributeCollection(attribute) ? WikittyTransformerUtil.getCollectionTypeName(attribute) : (commonTypes.contains(simpleTypeName = WikittyTransformerUtil.FQNtoSimpleName(attribute.getType())) ? StringUtils.capitalize((String)simpleTypeName) : "Wikitty");
        return "getFieldAs" + asWhat;
    }

    protected static String generateResultType(ObjectModelAttribute attribute, boolean considerMultiplicity) {
        String simpleTypeName = WikittyTransformerUtil.FQNtoSimpleName(attribute.getType());
        if (!commonTypes.contains(simpleTypeName)) {
            simpleTypeName = "String";
        }
        if (considerMultiplicity && WikittyTransformerUtil.isAttributeCollection(attribute)) {
            simpleTypeName = WikittyTransformerUtil.getCollectionTypeName(attribute) + "<" + simpleTypeName + ">";
        }
        return simpleTypeName;
    }

    protected static String getCollectionTypeName(ObjectModelAttribute attribute) {
        String result = null;
        result = attribute.isUnique() ? "Set" : "List";
        return result;
    }

    public static boolean isAttributeCollection(ObjectModelAttribute attribute) {
        return attribute.getMaxMultiplicity() == -1 || attribute.getMaxMultiplicity() > 1;
    }

    protected static String typeToWikittyColumn(String type) {
        String simpleType;
        String result = simpleType = WikittyTransformerUtil.FQNtoSimpleName(type);
        if (!commonTypes.contains(simpleType)) {
            result = "Wikitty";
        } else if (commonNumerics.contains(simpleType)) {
            result = "Numeric";
        } else if (commonStrings.contains(simpleType)) {
            result = "String";
        }
        return result;
    }

    public static String businessEntityToContractName(ObjectModelClass clazz) {
        return clazz.getName();
    }

    public static String businessEntityToAbstractName(ObjectModelClass clazz) {
        return clazz.getName() + "Abstract";
    }

    public static String businessEntityToImplementationName(ObjectModelClass clazz) {
        return clazz.getName() + "Impl";
    }

    public static String businessEntityToHelperName(ObjectModelClass clazz) {
        return clazz.getName() + "Helper";
    }

    static {
        commonNumerics.add("byte");
        commonNumerics.add("Byte");
        commonNumerics.add("short");
        commonNumerics.add("Short");
        commonNumerics.add("int");
        commonNumerics.add("Integer");
        commonNumerics.add("long");
        commonNumerics.add("Long");
        commonNumerics.add("float");
        commonNumerics.add("Float");
        commonNumerics.add("double");
        commonNumerics.add("Double");
        commonStrings = new HashSet<String>();
        commonStrings.add("char");
        commonStrings.add("Char");
        commonStrings.add("String");
        commonTypes = new HashSet<String>();
        commonTypes.addAll(commonNumerics);
        commonTypes.addAll(commonStrings);
        commonTypes.add("boolean");
        commonTypes.add("Boolean");
        commonTypes.add("Date");
    }
}

