/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.wikitty.generator.WikittyTransformerUtil;

public class WikittyHelperGenerator
extends ObjectModelTransformerToJava {
    protected static final String META_EXTENSION_SEPARATOR = ":";

    public void transformFromClass(ObjectModelClass clazz) {
        ObjectModelClass helper = this.createClass(WikittyTransformerUtil.businessEntityToHelperName(clazz), clazz.getPackageName());
        this.addImport((ObjectModelClassifier)helper, "org.nuiton.wikitty.BusinessEntity");
        this.addImport((ObjectModelClassifier)helper, "org.nuiton.wikitty.BusinessEntityWikitty");
        this.addImport((ObjectModelClassifier)helper, "org.nuiton.wikitty.Wikitty");
        this.addImport((ObjectModelClassifier)helper, "org.nuiton.wikitty.WikittyExtension");
        this.addImport((ObjectModelClassifier)helper, "org.nuiton.wikitty.WikittyUtil");
        this.addImport((ObjectModelClassifier)helper, "org.nuiton.wikitty.WikittyUser");
        this.addImport((ObjectModelClassifier)helper, "org.nuiton.wikitty.WikittyUserAbstract");
        this.addImport((ObjectModelClassifier)helper, "org.nuiton.wikitty.WikittyUserImpl");
        this.addImport((ObjectModelClassifier)helper, "org.nuiton.wikitty.TreeNode");
        this.addImport((ObjectModelClassifier)helper, "org.nuiton.wikitty.TreeNodeAbstract");
        this.addImport((ObjectModelClassifier)helper, "org.nuiton.wikitty.TreeNodeImpl");
        this.addImport((ObjectModelClassifier)helper, List.class);
        this.addImport((ObjectModelClassifier)helper, ArrayList.class);
        this.addImport((ObjectModelClassifier)helper, Collection.class);
        this.addImport((ObjectModelClassifier)helper, Collections.class);
        this.addImport((ObjectModelClassifier)helper, Set.class);
        this.addImport((ObjectModelClassifier)helper, Date.class);
        this.addImport((ObjectModelClassifier)helper, LinkedHashSet.class);
        ObjectModelOperation constructor = this.addConstructor(helper, ObjectModelModifier.PRIVATE);
        this.setDocumentation((ObjectModelElement)constructor, "utility class all provided methods are accessible the static way");
        this.setOperationBody(constructor, "// empty\n");
        if (WikittyTransformerUtil.isBusinessEntity(clazz)) {
            this.createOperationsForBusinessEntity(clazz, helper);
        }
        if (WikittyTransformerUtil.isMetaExtension(clazz)) {
            this.createOperationForMetaExtension(clazz, helper);
        }
    }

    protected void createOperationsForBusinessEntity(ObjectModelClass entity, ObjectModelClass helper) {
        String extensionVariableName = WikittyTransformerUtil.classToExtensionVariableName(entity, true);
        for (ObjectModelAttribute attribute : entity.getAttributes()) {
            if (!attribute.isNavigable()) continue;
            String fieldVariableName = WikittyTransformerUtil.attributeToFielVariableName(attribute, true);
            String attributeType = WikittyTransformerUtil.generateResultType(attribute, false);
            String attributeName = attribute.getName();
            if (attribute.hasTagValue("alternativeName")) {
                attributeName = attribute.getTagValue("alternativeName");
            }
            if (WikittyTransformerUtil.isAttributeCollection(attribute)) {
                String attributeTypeSimpleNameInSet = WikittyTransformerUtil.generateResultType(attribute, true);
                String getFieldMethodName = WikittyTransformerUtil.generateGetFieldAsCall(attribute);
                String getterName = "get" + StringUtils.capitalize((String)attributeName);
                ObjectModelOperation getter = this.addOperation((ObjectModelClassifier)helper, getterName, attributeTypeSimpleNameInSet, new ObjectModelModifier[]{ObjectModelModifier.STATIC});
                this.addParameter(getter, "Wikitty", "wikitty");
                String getterBody = "\n        " + attributeTypeSimpleNameInSet + " result = wikitty." + getFieldMethodName + "(" + extensionVariableName + ", " + fieldVariableName + ", " + attributeType + ".class);\n" + "        return result;\n" + "";
                this.setOperationBody(getter, getterBody);
                String addName = "add" + StringUtils.capitalize((String)attributeName);
                ObjectModelOperation adder = this.addOperation((ObjectModelClassifier)helper, addName, "void", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
                this.addParameter(adder, "Wikitty", "wikitty");
                this.addParameter(adder, attributeType, "element");
                String adderBody = "\n        wikitty.addToField(" + extensionVariableName + ", " + fieldVariableName + ", element);\n" + "";
                this.setOperationBody(adder, adderBody);
                String removeName = "remove" + StringUtils.capitalize((String)attributeName);
                ObjectModelOperation remover = this.addOperation((ObjectModelClassifier)helper, removeName, "void", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
                this.addParameter(remover, "Wikitty", "wikitty");
                this.addParameter(remover, attributeType, "element");
                String removerBody = "\n        wikitty.removeFromField(" + extensionVariableName + ", " + fieldVariableName + ", element);\n" + "";
                this.setOperationBody(remover, removerBody);
                String clearName = "clear" + StringUtils.capitalize((String)attributeName);
                ObjectModelOperation clear = this.addOperation((ObjectModelClassifier)helper, clearName, "void", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
                this.addParameter(clear, "Wikitty", "wikitty");
                String clearBody = "\n        wikitty.clearField(" + extensionVariableName + ", " + fieldVariableName + ");\n" + "";
                this.setOperationBody(clear, clearBody);
                continue;
            }
            String getFieldMethodName = WikittyTransformerUtil.generateGetFieldAsCall(attribute);
            String getterName = "get" + StringUtils.capitalize((String)attributeName);
            ObjectModelOperation getter = this.addOperation((ObjectModelClassifier)helper, getterName, attributeType, new ObjectModelModifier[]{ObjectModelModifier.STATIC});
            this.addParameter(getter, "Wikitty", "wikitty");
            this.setOperationBody(getter, "\n        " + attributeType + " value = wikitty." + getFieldMethodName + "(" + extensionVariableName + ", " + fieldVariableName + ");\n" + "        return value;\n" + "");
            String setterName = "set" + StringUtils.capitalize((String)attributeName);
            ObjectModelOperation setter = this.addOperation((ObjectModelClassifier)helper, setterName, attributeType, new ObjectModelModifier[]{ObjectModelModifier.STATIC});
            this.addParameter(setter, "Wikitty", "wikitty");
            this.addParameter(setter, attributeType, attributeName);
            this.setOperationBody(setter, "\n        " + attributeType + " oldValue = " + getter.getName() + "(wikitty);\n" + "        wikitty.setField(" + extensionVariableName + ", " + fieldVariableName + ", " + attributeName + ");\n" + "        return oldValue;\n" + "");
        }
        ObjectModelOperation equals = this.addOperation((ObjectModelClassifier)helper, "equals", "boolean", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
        this.addParameter(equals, "org.nuiton.wikitty.Wikitty", "w1");
        this.addParameter(equals, "org.nuiton.wikitty.Wikitty", "w2");
        String equalsBody = "\n    boolean result = true;\n";
        for (ObjectModelAttribute attribute : entity.getAttributes()) {
            if (!attribute.isNavigable()) continue;
            String fieldVariableName = WikittyTransformerUtil.attributeToFielVariableName(attribute, true);
            equalsBody = equalsBody + "\n        if (result) {\n            Object f1 = w1.getFieldAsObject(" + extensionVariableName + ", " + fieldVariableName + ");\n" + "            Object f2 = w2.getFieldAsObject(" + extensionVariableName + ", " + fieldVariableName + ");\n" + "            result = f1 == f2 || (f1 != null && f1.equals(f2));\n" + "        };\n" + "";
        }
        equalsBody = equalsBody + "\n    return result;\n";
        this.setOperationBody(equals, equalsBody);
        ObjectModelOperation isExtension = this.addOperation((ObjectModelClassifier)helper, "isExtension", "boolean", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
        this.addParameter(isExtension, "org.nuiton.wikitty.Wikitty", "wikitty");
        this.addAnnotation((ObjectModelClassifier)helper, (ObjectModelElement)isExtension, "Deprecated");
        this.setDocumentation((ObjectModelElement)isExtension, "@deprecated renamed to keep consistency, use hasExtension instead");
        this.setOperationBody(isExtension, "\n        return hasExtension(wikitty);\n");
        ObjectModelOperation hasExtension = this.addOperation((ObjectModelClassifier)helper, "hasExtension", "boolean", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
        this.addParameter(hasExtension, "org.nuiton.wikitty.Wikitty", "wikitty");
        this.setDocumentation((ObjectModelElement)hasExtension, "check if wikitty has current extension");
        this.setOperationBody(hasExtension, "\n        return wikitty.hasExtension(" + extensionVariableName + ");\n" + "");
        ObjectModelOperation addExtension = this.addOperation((ObjectModelClassifier)helper, "addExtension", "void", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
        this.addParameter(addExtension, "org.nuiton.wikitty.Wikitty", "wikitty");
        this.setDocumentation((ObjectModelElement)addExtension, "ajout les extensions static de cette classe au wikitty en argument");
        String contractName = WikittyTransformerUtil.businessEntityToAbstractName(entity);
        this.setOperationBody(addExtension, "\n        for (WikittyExtension ext : " + contractName + ".extensions) {\n" + "            wikitty.addExtension(ext);\n" + "        }\n" + "");
    }

    protected void createOperationForMetaExtension(ObjectModelClass metaExtension, ObjectModelClass helper) {
        String abstractName = WikittyTransformerUtil.businessEntityToAbstractName(metaExtension);
        String contractName = WikittyTransformerUtil.businessEntityToContractName(metaExtension);
        String extensionVariableName = WikittyTransformerUtil.classToExtensionVariableName(metaExtension, true);
        ObjectModelOperation addMetaExtension = this.addOperation((ObjectModelClassifier)helper, "addMetaExtension", "void", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
        this.addParameter(addMetaExtension, "org.nuiton.wikitty.WikittyExtension", "extension");
        this.addParameter(addMetaExtension, "org.nuiton.wikitty.Wikitty", "wikitty");
        this.setDocumentation((ObjectModelElement)addMetaExtension, String.format("add %s meta-extension on given extension to the given wikitty", metaExtension.getName()));
        this.setOperationBody(addMetaExtension, "\n        wikitty.addMetaExtension(" + abstractName + ".extension" + contractName + ", extension);\n" + "");
        ObjectModelOperation hasMetaExtension = this.addOperation((ObjectModelClassifier)helper, "hasMetaExtension", "boolean", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
        this.addParameter(hasMetaExtension, "org.nuiton.wikitty.WikittyExtension", "extension");
        this.addParameter(hasMetaExtension, "org.nuiton.wikitty.Wikitty", "wikitty");
        this.setDocumentation((ObjectModelElement)hasMetaExtension, String.format("true if given wikitty has %s meta-extension on given extension", metaExtension.getName()));
        this.setOperationBody(hasMetaExtension, "\n        return wikitty.hasMetaExtension(" + extensionVariableName + ", extension.getName());\n" + "");
        ObjectModelOperation getMetaFieldNameFromExtension = this.addOperation((ObjectModelClassifier)helper, "getMetaFieldName", "String", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
        this.addParameter(getMetaFieldNameFromExtension, "org.nuiton.wikitty.WikittyExtension", "extension");
        this.addParameter(getMetaFieldNameFromExtension, "String", "fieldName");
        this.setDocumentation((ObjectModelElement)getMetaFieldNameFromExtension, String.format("for extension 'Ext' and field 'f', return 'Ext:%s.f'", metaExtension.getName()));
        this.setOperationBody(getMetaFieldNameFromExtension, "\n        String metaFieldName = getMetaFieldName(extension.getName(), fieldName); \n        return metaFieldName;\n");
        ObjectModelOperation getMetaFieldNameFromExtensionName = this.addOperation((ObjectModelClassifier)helper, "getMetaFieldName", "String", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
        this.addParameter(getMetaFieldNameFromExtensionName, "String", "extensionName");
        this.addParameter(getMetaFieldNameFromExtensionName, "String", "fieldName");
        this.setDocumentation((ObjectModelElement)getMetaFieldNameFromExtensionName, String.format("for extension 'Ext' and field 'f', return 'Ext:%s.f'", metaExtension.getName()));
        this.setOperationBody(getMetaFieldNameFromExtensionName, "\n        String metaFieldName = WikittyUtil.getMetaFieldName(\"" + metaExtension.getName() + "\", extensionName, fieldName);\n" + "        return metaFieldName;\n" + "");
        for (ObjectModelAttribute attribute : metaExtension.getAttributes()) {
            if (!attribute.isNavigable()) continue;
            String fieldVariableName = WikittyTransformerUtil.attributeToFielVariableName(attribute, true);
            String attributeType = WikittyTransformerUtil.generateResultType(attribute, false);
            String attributeName = attribute.getName();
            if (attribute.hasTagValue("alternativeName")) {
                attributeName = attribute.getTagValue("alternativeName");
            }
            if (WikittyTransformerUtil.isAttributeCollection(attribute)) {
                String attributeTypeSimpleNameInSet = WikittyTransformerUtil.generateResultType(attribute, true);
                String getFieldMethodName = WikittyTransformerUtil.generateGetFieldAsCall(attribute);
                String getterName = "get" + StringUtils.capitalize((String)attributeName);
                ObjectModelOperation getter = this.addOperation((ObjectModelClassifier)helper, getterName, attributeTypeSimpleNameInSet, new ObjectModelModifier[]{ObjectModelModifier.STATIC});
                this.addParameter(getter, "String", "extensionName");
                this.addParameter(getter, "org.nuiton.wikitty.Wikitty", "wikitty");
                String getterBody = "\n        String fieldName = getMetaFieldName(extensionName, \"" + attributeName + "\");\n" + "        " + attributeTypeSimpleNameInSet + " result = (" + attributeTypeSimpleNameInSet + ") wikitty.getFqField(fieldName);        \n" + "        return result;\n" + "";
                this.setOperationBody(getter, getterBody);
                String addName = "add" + StringUtils.capitalize((String)attributeName);
                ObjectModelOperation adder = this.addOperation((ObjectModelClassifier)helper, addName, "void", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
                this.addParameter(adder, "String", "extensionName");
                this.addParameter(adder, "org.nuiton.wikitty.Wikitty", "wikitty");
                this.addParameter(adder, attributeType, "element");
                String adderBody = "        \n        String fieldName = getMetaFieldName(extensionName, \"" + attributeName + "\");\n" + "        wikitty.addToField(fieldName, element);\n" + "";
                this.setOperationBody(adder, adderBody);
                String removeName = "remove" + StringUtils.capitalize((String)attributeName);
                ObjectModelOperation remover = this.addOperation((ObjectModelClassifier)helper, removeName, "void", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
                this.addParameter(remover, "String", "extensionName");
                this.addParameter(remover, "org.nuiton.wikitty.Wikitty", "wikitty");
                this.addParameter(remover, attributeType, "element");
                String removerBody = "\n        String fieldName = getMetaFieldName(extensionName, \"" + attributeName + "\");\n" + "        wikitty.removeFromField(fieldName, element);\n" + "";
                this.setOperationBody(remover, removerBody);
                String clearName = "clear" + StringUtils.capitalize((String)attributeName);
                ObjectModelOperation clear = this.addOperation((ObjectModelClassifier)helper, clearName, "void", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
                this.addParameter(clear, "String", "extensionName");
                this.addParameter(clear, "org.nuiton.wikitty.Wikitty", "wikitty");
                String clearBody = "\n        String fieldName = getMetaFieldName(extensionName, \"" + attributeName + "\");\n" + "        wikitty.clearField(fieldName);\n" + "";
                this.setOperationBody(clear, clearBody);
                continue;
            }
            String getFieldMethodName = WikittyTransformerUtil.generateGetFieldAsCall(attribute);
            String getterName = "get" + StringUtils.capitalize((String)attributeName);
            ObjectModelOperation getter = this.addOperation((ObjectModelClassifier)helper, getterName, attributeType, new ObjectModelModifier[]{ObjectModelModifier.STATIC});
            this.addParameter(getter, "String", "extensionName");
            this.addParameter(getter, "org.nuiton.wikitty.Wikitty", "wikitty");
            this.setOperationBody(getter, "\n        String fieldName = getMetaFieldName(extensionName, \"" + attributeName + "\");\n" + "        " + attributeType + " value = (" + attributeType + ") wikitty.getFqField(fieldName);        \n" + "        return value;\n" + "");
            String setterName = "set" + StringUtils.capitalize((String)attributeName);
            ObjectModelOperation setter = this.addOperation((ObjectModelClassifier)helper, setterName, attributeType, new ObjectModelModifier[]{ObjectModelModifier.STATIC});
            this.addParameter(setter, "String", "extensionName");
            this.addParameter(setter, "org.nuiton.wikitty.Wikitty", "wikitty");
            this.addParameter(setter, attributeType, attributeName);
            this.setOperationBody(setter, "\n        " + attributeType + " oldValue = " + getter.getName() + "(extensionName, wikitty);\n" + "        String fieldName = getMetaFieldName(extensionName, \"" + attributeName + "\");\n" + "        wikitty.setFqField(fieldName, " + attributeName + ");\n" + "        return oldValue;\n" + "");
        }
    }
}

