/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.Transformer;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.wikitty.generator.WikittyPurifierTransformer;
import org.nuiton.wikitty.generator.WikittyTransformerUtil;

public class WikittyContractGenerator
extends ObjectModelTransformerToJava {
    private static final Log log = LogFactory.getLog(WikittyContractGenerator.class);
    protected Map<ObjectModelClass, ObjectModelInterface> processedClasses = new HashMap<ObjectModelClass, ObjectModelInterface>();
    protected Set<ObjectModelClass> processedEntities = new HashSet<ObjectModelClass>();

    protected Transformer<ObjectModel, ObjectModel> initPreviousTransformer() {
        return new WikittyPurifierTransformer();
    }

    public void transformFromModel(ObjectModel model) {
        log.info((Object)(model.getClasses().size() + " classes to process"));
        for (ObjectModelClass clazz : model.getClasses()) {
            if (!WikittyTransformerUtil.isBusinessEntity(clazz)) continue;
            this.processEntity(clazz);
        }
        for (ObjectModelClass clazz : model.getClasses()) {
            if (!WikittyTransformerUtil.isMetaExtension(clazz)) continue;
            this.processMetaExtension(clazz);
        }
        this.processedClasses.clear();
        this.processedEntities.clear();
    }

    protected ObjectModelInterface prepareOutputClass(ObjectModelClass businessEntity) {
        ObjectModelInterface contract = this.processedClasses.get(businessEntity);
        if (contract == null) {
            log.debug((Object)("preparing " + businessEntity.getPackageName() + "." + businessEntity.getName()));
            contract = this.createInterface(WikittyTransformerUtil.businessEntityToContractName(businessEntity), businessEntity.getPackageName());
            this.addInterface((ObjectModelClassifier)contract, "org.nuiton.wikitty.BusinessEntity");
            this.addImport((ObjectModelClassifier)contract, "org.nuiton.wikitty.BusinessEntity");
            this.addImport((ObjectModelClassifier)contract, "org.nuiton.wikitty.BusinessEntityWikitty");
            this.addImport((ObjectModelClassifier)contract, "org.nuiton.wikitty.Wikitty");
            this.addImport((ObjectModelClassifier)contract, "org.nuiton.wikitty.WikittyExtension");
            this.addImport((ObjectModelClassifier)contract, "org.nuiton.wikitty.WikittyUtil");
            this.addImport((ObjectModelClassifier)contract, "org.nuiton.wikitty.WikittyUser");
            this.addImport((ObjectModelClassifier)contract, "org.nuiton.wikitty.WikittyUserAbstract");
            this.addImport((ObjectModelClassifier)contract, "org.nuiton.wikitty.WikittyUserImpl");
            this.addImport((ObjectModelClassifier)contract, "org.nuiton.wikitty.TreeNode");
            this.addImport((ObjectModelClassifier)contract, "org.nuiton.wikitty.TreeNodeAbstract");
            this.addImport((ObjectModelClassifier)contract, "org.nuiton.wikitty.TreeNodeImpl");
            this.addImport((ObjectModelClassifier)contract, List.class);
            this.addImport((ObjectModelClassifier)contract, ArrayList.class);
            this.addImport((ObjectModelClassifier)contract, Collection.class);
            this.addImport((ObjectModelClassifier)contract, Collections.class);
            this.addImport((ObjectModelClassifier)contract, Set.class);
            this.addImport((ObjectModelClassifier)contract, Date.class);
            this.addImport((ObjectModelClassifier)contract, LinkedHashSet.class);
            String documentation = businessEntity.getDocumentation();
            if (businessEntity.hasTagValue("documentation")) {
                documentation = documentation + "\n\n";
                documentation = documentation + businessEntity.getTagValue("documentation");
            }
            this.setDocumentation((ObjectModelElement)contract, documentation);
            this.processedClasses.put(businessEntity, contract);
        } else {
            log.debug((Object)("already prepared : " + businessEntity.getPackageName() + "." + businessEntity.getName()));
        }
        return contract;
    }

    protected void processEntity(ObjectModelClass businessEntity) {
        String fieldVariableName;
        if (this.processedEntities.contains(businessEntity)) {
            log.debug((Object)("entity already processed : " + businessEntity.getPackageName() + "." + businessEntity.getName()));
            return;
        }
        log.debug((Object)("processing entity : " + businessEntity.getPackageName() + "." + businessEntity.getName()));
        ObjectModelInterface contract = this.prepareOutputClass(businessEntity);
        this.addConstant((ObjectModelClassifier)contract, "EXT_" + businessEntity.getName().toUpperCase(), "String", "\"" + businessEntity.getName() + "\"", ObjectModelModifier.PUBLIC);
        String extensionVariableName = WikittyTransformerUtil.classToExtensionVariableName(businessEntity, false);
        for (ObjectModelAttribute attribute : businessEntity.getAttributes()) {
            if (!attribute.isNavigable()) continue;
            fieldVariableName = WikittyTransformerUtil.attributeToFielVariableName(attribute, false);
            this.addConstant((ObjectModelClassifier)contract, fieldVariableName, "String", "\"" + attribute.getName() + "\"", ObjectModelModifier.PUBLIC);
            this.addConstant((ObjectModelClassifier)contract, "FQ_" + fieldVariableName, "String", extensionVariableName + " + \"." + attribute.getName() + "\"", ObjectModelModifier.PUBLIC);
        }
        for (ObjectModelAttribute attribute : businessEntity.getAttributes()) {
            ObjectModelOperation getter;
            if (!attribute.isNavigable()) continue;
            fieldVariableName = WikittyTransformerUtil.attributeToFielVariableName(attribute, true);
            String attributeType = WikittyTransformerUtil.generateResultType(attribute, false);
            String attributeName = attribute.getName();
            if (attribute.hasTagValue("alternativeName")) {
                attributeName = attribute.getTagValue("alternativeName");
            }
            if (attribute.getMaxMultiplicity() > 1 || attribute.getMaxMultiplicity() == -1) {
                String attributeTypeSimpleNameInSet = WikittyTransformerUtil.generateResultType(attribute, true);
                String getterName = "get" + StringUtils.capitalize((String)attributeName);
                getter = this.addOperation((ObjectModelClassifier)contract, getterName, attributeTypeSimpleNameInSet, new ObjectModelModifier[0]);
                String addName = "add" + StringUtils.capitalize((String)attributeName);
                ObjectModelOperation adder = this.addOperation((ObjectModelClassifier)contract, addName, "void", new ObjectModelModifier[0]);
                this.addParameter(adder, "String", "element");
                String removeName = "remove" + StringUtils.capitalize((String)attributeName);
                ObjectModelOperation remover = this.addOperation((ObjectModelClassifier)contract, removeName, "void", new ObjectModelModifier[0]);
                this.addParameter(remover, "String", "element");
                String clearName = "clear" + StringUtils.capitalize((String)attributeName);
                this.addOperation((ObjectModelClassifier)contract, clearName, "void", new ObjectModelModifier[0]);
            } else {
                String getterName = "get" + StringUtils.capitalize((String)attributeName);
                getter = this.addOperation((ObjectModelClassifier)contract, getterName, attributeType, new ObjectModelModifier[0]);
                String setterName = "set" + StringUtils.capitalize((String)attributeName);
                ObjectModelOperation setter = this.addOperation((ObjectModelClassifier)contract, setterName, "void", new ObjectModelModifier[0]);
                this.addParameter(setter, attributeType, attributeName);
            }
            this.setDocumentation((ObjectModelElement)getter, attribute.getDocumentation());
        }
        Collection superClasses = businessEntity.getSuperclasses();
        for (ObjectModelClass superClass : superClasses) {
            this.addInterface((ObjectModelClassifier)contract, superClass.getQualifiedName());
            if (!WikittyTransformerUtil.isBusinessEntity(superClass)) continue;
            if (!this.processedEntities.contains(superClass)) {
                log.debug((Object)(businessEntity.getName() + " require to process " + superClass.getName() + " first"));
                this.processEntity(superClass);
            }
            for (ObjectModelOperation operation : this.processedClasses.get(superClass).getOperations()) {
                this.cloneOperationSignature(operation, (ObjectModelClassifier)contract, true, new ObjectModelModifier[0]);
            }
        }
        this.processedEntities.add(businessEntity);
    }

    protected void processMetaExtension(ObjectModelClass metaExtension) {
        log.debug((Object)("processing meta-extension : " + metaExtension.getPackageName() + "." + metaExtension.getName()));
        ObjectModelInterface contract = this.prepareOutputClass(metaExtension);
        ObjectModelOperation addMetaExtension = this.addOperation((ObjectModelClassifier)contract, "addMetaExtension", "void", new ObjectModelModifier[0]);
        this.addParameter(addMetaExtension, "org.nuiton.wikitty.WikittyExtension", "extension");
        this.setDocumentation((ObjectModelElement)addMetaExtension, String.format("add %s meta-extension on given extension to this entity", metaExtension.getName()));
    }
}

