/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.nuiton.wikitty.generator.EugengoUtils;
import org.nuiton.wikitty.generator.WikengoCommonGenerator;

public class WikittyHelperGenerator
extends WikengoCommonGenerator {
    private static final Log log = LogFactory.getLog(WikittyHelperGenerator.class);
    protected static Pattern extractTypeOnCollection = Pattern.compile("\\w*<(\\w+)>");
    protected String EXT_NAME;
    private static Set<String> commonNumerics = new HashSet<String>();
    private static Set<String> commonStrings;
    private static Set<String> commonTypes;

    public String getFilenameForClass(ObjectModelClass clazz) {
        String fqn = clazz.getQualifiedName();
        log.info((Object)("Filename for " + clazz.getName() + " is " + fqn.replace('.', File.separatorChar) + ".java"));
        return fqn.replace('.', File.separatorChar) + "Helper.java";
    }

    public void generateFromClass(Writer output, ObjectModelClass clazz) throws IOException {
        if (!EugengoUtils.isBusinessEntity((ObjectModelClassifier)clazz)) {
            log.info((Object)(clazz.getName() + " is not a business entity"));
            return;
        }
        log.info((Object)("Generate Business entity abstract" + clazz.getName() + "... "));
        this.generateCopyright(output);
        this.EXT_NAME = "EXT_" + clazz.getName().toUpperCase();
        String packageName = clazz.getPackageName();
        String name = clazz.getName() + "Helper";
        String nameImpl = clazz.getName() + "Impl";
        output.write("package " + packageName + ";\n");
        output.write("\n");
        output.write("");
        ObjectModelClass superClass = this.findSuperClass(clazz);
        this.clearImports();
        this.addImport(clazz);
        this.addImport(superClass);
        this.addImport("org.nuiton.wikitty.WikittyUtil");
        this.addImport("org.nuiton.wikitty.Wikitty");
        this.addImport("org.nuiton.wikitty.BusinessEntityWikitty");
        this.addImport("org.nuiton.wikitty.WikittyExtension");
        this.addImport(Collection.class);
        this.addImport(Collections.class);
        this.addImport(List.class);
        this.addImport(ArrayList.class);
        this.lookForAttributeImports(clazz);
        this.generateImports(output, packageName);
        this.generateClazzDocumentation(output, (ObjectModelClassifier)clazz, new String[0]);
        output.write("public class " + name + " extends " + nameImpl + " {\n");
        output.write("\n");
        output.write("");
        String svUID = GeneratorUtil.computeSerialVersionUID((ObjectModelClass)clazz);
        output.write("    private static final long serialVersionUID = " + svUID + ";\n");
        output.write("\n");
        output.write("");
        output.write("\n");
        output.write("    /**\n");
        output.write("     * This class is not instanciable, it's just helper\n");
        output.write("     */\n");
        output.write("    private " + name + "() {\n");
        output.write("    }\n");
        output.write("\n");
        output.write("");
        this.generateAttributeAccessMethod(output, clazz);
        for (ObjectModelClass parent : clazz.getSuperclasses()) {
            if (!EugengoUtils.isBusinessEntity((ObjectModelClassifier)parent)) continue;
            this.generateParentMethod(output, parent);
        }
        output.write("\n");
        output.write("    /**\n");
        output.write("     * Check if wikitty has current extension\n");
        output.write("     */\n");
        output.write("    static public boolean isExtension(Wikitty w) {\n");
        output.write("        boolean result = w.hasExtension(" + this.EXT_NAME + ");\n");
        output.write("        return result;\n");
        output.write("    }\n");
        output.write("\n");
        output.write("    /**\n");
        output.write("     * ajout les extensions static de cette classe au wikitty en argument\n");
        output.write("     */\n");
        output.write("    static public void addExtension(Wikitty w) {\n");
        output.write("        for (WikittyExtension ext : extensions) {\n");
        output.write("            w.addExtension(ext);\n");
        output.write("        }\n");
        output.write("    }\n");
        output.write("\n");
        output.write("    /**\n");
        output.write("     * Check equality on all field of this extension, and only those.\n");
        output.write("     */\n");
        output.write("    static public boolean equals(Wikitty w1, Wikitty w2) {\n");
        output.write("        boolean result = true;\n");
        output.write("");
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!attr.isNavigable() || attr.isStatic() || attr.getStereotypes() != null && !attr.getStereotypes().isEmpty()) continue;
            output.write("        if (result) {\n");
            output.write("            Object f1 = w1.getFieldAsObject(" + this.EXT_NAME + ", FIELD_" + attr.getName().toUpperCase() + ");\n");
            output.write("            Object f2 = w2.getFieldAsObject(" + this.EXT_NAME + ", FIELD_" + attr.getName().toUpperCase() + ");\n");
            output.write("            result = f1 == f2 || (f1 != null && f1.equals(f2));\n");
            output.write("        }\n");
            output.write("");
        }
        output.write("\n");
        output.write("        return result;\n");
        output.write("    }\n");
        output.write("\n");
        output.write("} //" + name + "\n");
        output.write("");
    }

    public void generateAttributeAccessMethod(Writer output, ObjectModelClass clazz) throws IOException {
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!attr.isNavigable() || attr.isStatic() || attr.getStereotypes() != null && !attr.getStereotypes().isEmpty()) continue;
            if (attr.getMaxMultiplicity() != 0 && attr.getMaxMultiplicity() != 1) {
                this.generateCollectionAttributeAccessors(output, attr);
                continue;
            }
            this.generateWikittyAttributeAccessors(output, attr);
        }
    }

    private void generateParentMethod(Writer output, ObjectModelClass clazz) throws IOException {
        for (ObjectModelClass parent : clazz.getSuperclasses()) {
            if (!EugengoUtils.isBusinessEntity((ObjectModelClassifier)parent)) continue;
            this.generateParentMethod(output, parent);
        }
        this.generateAttributeAccessMethod(output, clazz);
    }

    protected void generateWikittyAttributeAccessors(Writer output, ObjectModelAttribute attr) throws IOException {
        this.EXT_NAME = "EXT_" + attr.getDeclaringElement().getName().toUpperCase();
        String attrType = this.computeType((ObjectModelParameter)attr);
        if (!EugengoUtils.notEmpty((String)attrType)) {
            return;
        }
        attrType = this.getType(attrType, true);
        String methodAccessName = this.getFieldAccessMethodName(attr);
        String attrName = attr.getName();
        String attrNameCapitalized = EugengoUtils.toUpperCaseFirstLetter((String)attrName);
        output.write("\n");
        output.write("    static public void set" + attrNameCapitalized + "(Wikitty w, " + attrType + " " + attrName + ") {\n");
        output.write("        w.setField(" + this.EXT_NAME + ", \"" + attrName + "\", " + attrName + ");\n");
        output.write("    }\n");
        output.write("\n");
        output.write("    static public " + attrType + " get" + attrNameCapitalized + "(Wikitty w) {\n");
        output.write("        " + attrType + " result = w.getFieldAs" + methodAccessName + "(" + this.EXT_NAME + ", \"" + attrName + "\");\n");
        output.write("        return result;\n");
        output.write("    }\n");
        output.write("\n");
        output.write("");
    }

    protected String getFieldAccessMethodName(ObjectModelAttribute attr) {
        boolean isCollection;
        String result = this.computeType((ObjectModelParameter)attr);
        result = this.getType(result, true);
        boolean bl = isCollection = attr.getMaxMultiplicity() != 0 && attr.getMaxMultiplicity() != 1;
        if (isCollection) {
            result = attr.isUnique() ? "Set" : "List";
        } else if ("java.util.Date".equals(result) || "Date".equals(result)) {
            result = "Date";
        } else if (((ObjectModel)this.getModel()).hasClass(result)) {
            ObjectModelClass fieldClass = ((ObjectModel)this.getModel()).getClass(result);
            if (EugengoUtils.isBusinessEntity((ObjectModelClassifier)fieldClass)) {
                result = "Wikitty";
            }
        } else if (null != ((ObjectModel)this.getModel()).getEnumeration(result)) {
            result = "String";
        }
        result = EugengoUtils.toUpperCaseFirstLetter((String)result);
        return result;
    }

    protected void generateCollectionAttributeAccessors(Writer output, ObjectModelAttribute attr) throws IOException {
        this.EXT_NAME = "EXT_" + attr.getDeclaringElement().getName().toUpperCase();
        String attrType = this.computeType((ObjectModelParameter)attr);
        if (!EugengoUtils.notEmpty((String)attrType)) {
            return;
        }
        attrType = this.getType(attrType, true);
        String elementType = this.getType(attr.getType(), true);
        String methodAccessName = this.getFieldAccessMethodName(attr);
        String attrName = attr.getName();
        String attrNameCapitalized = EugengoUtils.toUpperCaseFirstLetter((String)attrName);
        output.write("    static public " + attrType + " get" + attrNameCapitalized + "(Wikitty w) {\n");
        output.write("        " + attrType + " result = w.getFieldAs" + methodAccessName + "(" + this.EXT_NAME + ", \"" + attrName + "\", " + this.getClassAndGeneric(attrType)[1] + ".class);\n");
        output.write("        return result;\n");
        output.write("    }\n");
        output.write("\n");
        output.write("    static public void add" + attrNameCapitalized + "(Wikitty w, " + elementType + " element) {\n");
        output.write("        w.addToField(" + this.EXT_NAME + ", \"" + attrName + "\", element);\n");
        output.write("    }\n");
        output.write("    \n");
        output.write("    static public void remove" + attrNameCapitalized + "(Wikitty w, " + elementType + " element) {\n");
        output.write("        w.removeFromField(" + this.EXT_NAME + ", \"" + attrName + "\", element);\n");
        output.write("    }\n");
        output.write("    \n");
        output.write("    static public void clear" + attrNameCapitalized + "(Wikitty w) {\n");
        output.write("        w.clearField(" + this.EXT_NAME + ", \"" + attrName + "\");\n");
        output.write("    }\n");
        output.write("\n");
        output.write("");
    }

    static {
        commonNumerics.add("byte");
        commonNumerics.add("Byte");
        commonNumerics.add("short");
        commonNumerics.add("Short");
        commonNumerics.add("int");
        commonNumerics.add("Integer");
        commonNumerics.add("long");
        commonNumerics.add("Long");
        commonNumerics.add("float");
        commonNumerics.add("Float");
        commonNumerics.add("double");
        commonNumerics.add("Double");
        commonStrings = new HashSet<String>();
        commonStrings.add("char");
        commonStrings.add("Char");
        commonStrings.add("String");
        commonTypes = new HashSet<String>();
        commonTypes.addAll(commonNumerics);
        commonTypes.addAll(commonStrings);
        commonTypes.add("boolean");
        commonTypes.add("Boolean");
        commonTypes.add("Date");
    }
}

