package org.nuiton.wikitty.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Generated;
import org.nuiton.wikitty.WikittyUtil;

@Generated(value = "org.nuiton.wikitty.generator.WikittyHelperGenerator", date = "Sun Aug 09 10:50:34 CEST 2015")
public class WikittyTokenHelper {

    /**
     * utility class all provided methods are accessible the static way
     */
    private WikittyTokenHelper() {// empty
}

    public static String getUser(Wikitty wikitty) {
        String value = wikitty.getFieldAsWikitty(WikittyToken.EXT_WIKITTYTOKEN, WikittyToken.FIELD_WIKITTYTOKEN_USER);
        return value;
}

    public static String setUser(Wikitty wikitty, String user) {
        String oldValue = getUser(wikitty);
        wikitty.setField(WikittyToken.EXT_WIKITTYTOKEN, WikittyToken.FIELD_WIKITTYTOKEN_USER, user);
        return oldValue;
}

    public static WikittyUser getUser(Wikitty wikitty, boolean exceptionIfNotLoaded) {
        WikittyUser value = WikittyUtil.newInstance(WikittyUser.class, wikitty.getFieldAsWikitty(WikittyToken.EXT_WIKITTYTOKEN, WikittyToken.FIELD_WIKITTYTOKEN_USER, exceptionIfNotLoaded));
        return value;
}

    public static WikittyUser setUser(Wikitty wikitty, WikittyUser user) {
        WikittyUser oldValue = getUser(wikitty, false);
        wikitty.setField(WikittyToken.EXT_WIKITTYTOKEN, WikittyToken.FIELD_WIKITTYTOKEN_USER, user);
        return oldValue;
}

    public static Date getDate(Wikitty wikitty) {
        Date value = wikitty.getFieldAsDate(WikittyToken.EXT_WIKITTYTOKEN, WikittyToken.FIELD_WIKITTYTOKEN_DATE);
        return value;
}

    public static Date setDate(Wikitty wikitty, Date date) {
        Date oldValue = getDate(wikitty);
        wikitty.setField(WikittyToken.EXT_WIKITTYTOKEN, WikittyToken.FIELD_WIKITTYTOKEN_DATE, date);
        return oldValue;
}

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyToken.EXT_WIKITTYTOKEN, WikittyToken.FIELD_WIKITTYTOKEN_USER);
            Object f2 = w2.getFieldAsObject(WikittyToken.EXT_WIKITTYTOKEN, WikittyToken.FIELD_WIKITTYTOKEN_USER);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyToken.EXT_WIKITTYTOKEN, WikittyToken.FIELD_WIKITTYTOKEN_DATE);
            Object f2 = w2.getFieldAsObject(WikittyToken.EXT_WIKITTYTOKEN, WikittyToken.FIELD_WIKITTYTOKEN_DATE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return 
     */
    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * check if wikitty has current extension
     * @param wikitty 
     * @return 
     */
    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(WikittyToken.EXT_WIKITTYTOKEN);
}

    /**
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */
    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : WikittyTokenAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}

    /**
     * supprime les extensions de cette classe au wikitty en argument
     * @param wikitty 
     */
    public static void removeExtension(Wikitty wikitty) {
        for (WikittyExtension ext : WikittyTokenAbstract.extensions) {
            wikitty.removeExtension(ext.getName());
        }
}

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @param wikitty 
     * @return 
     */
    public static String toString(Wikitty wikitty) {

        return wikitty.toString(WikittyToken.EXT_WIKITTYTOKEN);
}

} //WikittyTokenHelper
