package org.nuiton.wikitty.search;

import java.io.Serializable;

/**
 * StartsWith operator is used to build restriction containing "element like
 * value*" where element could be a String, a multimedia, a text or an xhtml
 * <br>
 * <br>
 * For example, use: RestrictionHelper.start( myElement , "value" )
 */
public class StartsWith extends BinaryOperator implements Serializable {

    // serialVersionUID is used for serialization.
    private static final long serialVersionUID = 1L;

    /**
     * Default constructor
     */
    public StartsWith() {
        super();
    }

    /**
     * Equality test based attributes values
     * 
     * @param other Value to compare
     */
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StartsWith)) {
            return false;
        }

        final StartsWith startsWith = (StartsWith) other;

        return super.equals(startsWith);
    }

    public int hashCode() {
        int result = StartsWith.class.getName().hashCode();
        result = 29 * result + super.hashCode();
        return result;
    }

}