
package org.nuiton.web.tapestry5.services;

/**
 * This service is used to provide authentication managment for a final
 * application. The user type used in the application is needed. This service
 * need to be implemented and build in the AppModule of your application.
 * An abstract implementation is available {@link ServiceAuthenticationAbstract}
 * This service is used in {@link AbstractAuthenticationFilter} to verify
 * user rights for displaying pages using {@link #isAllowed(Class)} method.
 * See documentation site for more explanation of using this service and
 * authentication managment.
 * <br \>
 * <h2>AppModule contribution :</2>
 * Exemple with MyUser type for user and ServiceAuthenticationImpl for
 * implementation :
 * <pre>
 *  public ServiceAuthentication<MyUser> buildServiceAuthentication(
 *          ApplicationStateManager stateManager) {
 *      ServiceAuthentication<MyUser> instance =
 *              new ServiceAuthenticationImpl(stateManager);
 *      return instance;
 *  }
 * </pre>
 * Contribute to ApplicationStateManager to instantiate MyUser automatically :
 * <pre>
 * public void contributeApplicationStateManager(
 *           MappedConfiguration<Class<?>,
 *           ApplicationStateContribution> configuration,
 *           final ServiceAuthentication<MyUser> serviceAuthentication) {
 *
 *      ApplicationStateCreator<MyUser> creator =
 *              new ApplicationStateCreator<MyUser>() {
 *
 *                  @Override
 *                  public MyUser create() {
 *                      return serviceAuthentication.getNewUserInstance();
 *                  }
 *              };
 *
 *      configuration.add(MyUser.class,
 *              new ApplicationStateContribution("session", creator));
 *  }
 * </pre>
 *
 *
 * Created: 3 mai 2010
 *
 * @param <U> user type
 * @author fdesbois
 * $Id: ServiceAuthentication.java 4 2010-05-04 14:54:59Z fdesbois $
 */
public interface ServiceAuthentication<U> {

    /**
     * Detect if user is connected.
     *
     * @return true if the user is connected, false otherwise.
     */
    boolean isUserConnected();

    /**
     * Get the current user connected.
     *
     * @return the user connected
     */
    U getUserConnected();

    /**
     * Set the connected user to {@code user}.
     *
     * @param user that will be connected
     */
    void setUserConnected(U user);

    /**
     * Check if the current user is allowed to display this {@code page}.
     *
     * @param page to check
     * @return true if the connected user is allowed, false otherwise
     */
    boolean isAllowed(Class<?> page);

    /**
     * Create a new instance of user.
     *
     * @return a new user.
     */
    U getNewUserInstance();

}
