/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAssociationClass;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelGenerator;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.nuiton.topia.generator.TopiaGeneratorUtil;

public class ServiceAbstractGenerator
extends ObjectModelGenerator {
    private static final Log log = LogFactory.getLog(ServiceAbstractGenerator.class);

    public String getFilenameForInterface(ObjectModelInterface clazz) {
        return clazz.getQualifiedName().replace('.', File.separatorChar) + "Abstract.java";
    }

    public void generateFromInterface(Writer output, ObjectModelInterface interfacez) throws IOException {
        if (!interfacez.hasStereotype("service")) {
            return;
        }
        this.generateInterfaceHeader(output, (ObjectModelClassifier)interfacez);
        this.generateInterfaceOperations(output, (ObjectModelClassifier)interfacez);
        this.generateInheritedInterfaceOperations(output, (ObjectModelClassifier)interfacez);
        this.generateAssociatedClassOperations(output, (ObjectModelClassifier)interfacez);
        this.generateMethodsGetter(output, (ObjectModelClassifier)interfacez);
        output.write("\n");
        output.write("} //" + interfacez.getName() + "\n");
        output.write("");
    }

    private void generateInterfaceHeader(Writer output, ObjectModelClassifier classifier) throws IOException {
        String copyright = TopiaGeneratorUtil.getCopyright((Model)this.model);
        String classifierName = classifier.getName();
        if (TopiaGeneratorUtil.notEmpty((String)copyright)) {
            output.write("" + copyright + "\n");
            output.write("");
        }
        output.write("package " + classifier.getPackageName() + ";\n");
        output.write("\n");
        output.write("import java.util.Arrays;\n");
        output.write("import java.util.List;\n");
        output.write("import org.nuiton.topia.TopiaException;\n");
        output.write("import org.nuiton.topia.service.TopiaApplicationServiceAbstract;\n");
        output.write("import org.nuiton.topia.framework.TopiaContextImplementor;");
        classifier.getInterfaces();
        for (ObjectModelInterface parent : classifier.getInterfaces()) {
            if (!parent.hasStereotype("dao")) continue;
            String className = parent.getQualifiedName().replace("DAO", "");
            String interfaceName = parent.getQualifiedName() + "Abstract";
            output.write("\n");
            output.write("import " + interfaceName + ";\n");
            output.write("import " + className + ";");
        }
        if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)classifier)) {
            output.write("\n");
            output.write("/**\n");
            output.write(" *\n");
            output.write(" * " + classifier.getDocumentation() + "\n");
            output.write(" */\n");
            output.write("");
        }
        output.write("\n");
        output.write("\n");
        output.write("public abstract class " + classifierName + "Abstract extends TopiaApplicationServiceAbstract implements " + classifierName + " {\n");
        output.write("");
    }

    private void generateMethodsGetter(Writer output, ObjectModelClassifier classifier) throws IOException {
        output.write("\n");
        output.write("    public String[] getMethods(){\n");
        output.write("    \treturn methods;\n");
        output.write("    }\n");
        output.write("");
    }

    private void generateInterfaceOperations(Writer output, ObjectModelClassifier classifier) throws IOException {
        for (ObjectModelOperation op : classifier.getOperations()) {
            String opName = op.getName();
            String opVisibility = op.getVisibility();
            String opType = op.getReturnType();
            output.write("\n");
            output.write("    /**\n");
            output.write("     * Implementation a la charge du developpeur\n");
            output.write("");
            if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)op)) {
                String opDocumentation = op.getDocumentation();
                output.write("     * " + opName + " : " + opDocumentation + "\n");
                output.write("");
            }
            Collection params = op.getParameters();
            for (ObjectModelParameter param : params) {
                String paramName = param.getName();
                String paramDocumentation = param.getDocumentation();
                output.write("     * @param " + paramName + " " + paramDocumentation + "\n");
                output.write("");
            }
            output.write("     */\n");
            output.write("    " + opVisibility + " abstract " + opType + " " + opName + "(");
            String comma = "";
            for (ObjectModelParameter param : params) {
                String paramName = param.getName();
                String paramType = param.getType();
                output.write("" + comma + "" + paramType + " " + paramName + "");
                comma = ", ";
            }
            output.write(")");
            Set exceptions = op.getExceptions();
            comma = " throws ";
            for (String exception : exceptions) {
                output.write("" + comma + "" + exception + "");
                comma = ", ";
            }
            output.write(";\n");
            output.write("");
        }
    }

    private void generateInheritedInterfaceOperations(Writer output, ObjectModelClassifier classifier) throws IOException {
        for (ObjectModelInterface parent : classifier.getInterfaces()) {
            if (!parent.hasStereotype("dao")) continue;
            String entityClassName = parent.getQualifiedName().replace("DAO", "");
            if (!((ObjectModel)this.getModel()).hasClass(entityClassName)) continue;
            ObjectModelClass clazz = ((ObjectModel)this.getModel()).getClass(entityClassName);
            String clazzName = clazz.getName();
            String clazzFQN = clazz.getQualifiedName();
            if (!clazz.hasStereotype("entity")) {
                return;
            }
            output.write("\n");
            output.write("    /**\n");
            output.write("     * Supprime l'entite " + clazzName + " passee en parametre\n");
            output.write("     * @param entity l'entite a supprimer\n");
            output.write("     */\n");
            output.write("\tpublic void delete" + clazzName + "(" + clazzFQN + " entity) throws TopiaException{\n");
            output.write("\t\tTopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;\n");
            output.write("\t\t" + clazzName + "DAOAbstract dao = (" + clazzName + "DAOAbstract)usedContextImpl.getDAO(" + clazzName + ".class);\n");
            output.write("\t\tdao.delete(entity);\n");
            output.write("\t}\n");
            output.write("\n");
            output.write("\t/**\n");
            output.write("     * Creer l'entite " + clazzName + " avec les proprietes passees en parametre\n");
            output.write("     * @param properties les proprietes de l'entite a creer\n");
            output.write("     */\n");
            output.write("    public " + clazzFQN + " create" + clazzName + "(Object ... properties) throws TopiaException{\n");
            output.write("        TopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;\n");
            output.write("        " + clazzName + "DAOAbstract dao = (" + clazzName + "DAOAbstract)usedContextImpl.getDAO(" + clazzName + ".class);\n");
            output.write("        " + clazzName + " entity = (" + clazzName + ") dao.create(properties);\n");
            output.write("        return entity;\n");
            output.write("    }\n");
            output.write("    \n");
            output.write("    /**\n");
            output.write("     * Mise a jour de l'entite " + clazzName + " passee en parametre\n");
            output.write("     * @param entity l'entite a mettre a jour\n");
            output.write("     */\n");
            output.write("    public " + clazzFQN + " update" + clazzName + "(" + clazzFQN + " entity) throws TopiaException{\n");
            output.write("        TopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;\n");
            output.write("        " + clazzName + "DAOAbstract dao = (" + clazzName + "DAOAbstract)usedContextImpl.getDAO(" + clazzName + ".class);\n");
            output.write("        " + clazzName + " entit = (" + clazzName + ") dao.update(entity);\n");
            output.write("        return entit;\n");
            output.write("    }\n");
            output.write("    \n");
            output.write("\t/**\n");
            output.write("     * Retourne tous les " + clazzName + " \n");
            output.write("     * @return une liste\n");
            output.write("     */\n");
            output.write("    public List<" + clazzFQN + "> findAll" + clazzName + "() throws TopiaException {\n");
            output.write("\t\tTopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;\n");
            output.write("\t\t" + clazzName + "DAOAbstract dao = (" + clazzName + "DAOAbstract)usedContextImpl.getDAO(" + clazzName + ".class);\n");
            output.write("\t\tList<" + clazzName + "> result = dao.findAll(); \n");
            output.write("    \treturn result;\n");
            output.write("    }\n");
            output.write("    \n");
            output.write("    /**\n");
            output.write("     * Retourne le " + clazzName + " par son TopiaId \n");
            output.write("     * @return le " + clazzName + "\n");
            output.write("     */\n");
            output.write("    public " + clazzFQN + " find" + clazzName + "ByTopiaId(String v) throws TopiaException {\n");
            output.write("    \tTopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;\n");
            output.write("\t\t" + clazzName + "DAOAbstract dao = (" + clazzName + "DAOAbstract)usedContextImpl.getDAO(" + clazzName + ".class);\n");
            output.write("\t\t" + clazzName + " entity = (" + clazzName + ")dao.findByTopiaId(v); \n");
            output.write("    \treturn entity;\n");
            output.write("    }   \n");
            output.write("");
            for (ObjectModelAttribute attr : clazz.getAttributes()) {
                if (!attr.isNavigable()) continue;
                if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                    this.generateNoNMultiplicity(output, attr, clazz, false);
                    continue;
                }
                this.generateNMultiplicity(output, attr, clazz, false);
            }
            if (!(clazz instanceof ObjectModelAssociationClass)) continue;
            ObjectModelAssociationClass assocClass = (ObjectModelAssociationClass)clazz;
            for (ObjectModelAttribute attr : assocClass.getParticipantsAttributes()) {
                if (attr == null) continue;
                if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                    this.generateNoNMultiplicity(output, attr, clazz, true);
                    continue;
                }
                this.generateNMultiplicity(output, attr, clazz, true);
            }
        }
    }

    protected void generateNoNMultiplicity(Writer output, ObjectModelAttribute attr, ObjectModelClass clazz, boolean isAssoc) throws IOException {
        String propertyName = attr.getName();
        if (!isAssoc && attr.hasAssociationClass()) {
            propertyName = TopiaGeneratorUtil.toLowerCaseFirstLetter((String)attr.getAssociationClass().getName()) + "." + propertyName;
        }
        String clazzName = clazz.getName();
        String clazzFQN = clazz.getQualifiedName();
        output.write("\n");
        output.write("    /**\n");
        output.write("     * Retourne le premier element trouve ayant comme valeur pour l'attribut\n");
        output.write("     * " + attr.getName() + " le parametre\n");
        output.write("     * @param v la valeur que doit avoir " + attr.getName() + "\n");
        output.write("     * @return un element ou null\n");
        output.write("     */\n");
        output.write("    public " + clazzFQN + " find" + clazzName + "By" + StringUtils.capitalize((String)attr.getName()) + "(" + attr.getType() + " v) throws TopiaException{\n");
        output.write("\t\tTopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;\n");
        output.write("\t\t" + clazzName + "DAOAbstract dao = (" + clazzName + "DAOAbstract)usedContextImpl.getDAO(" + clazzName + ".class);\n");
        output.write("\t\t" + clazzName + " entity = dao.findBy" + StringUtils.capitalize((String)attr.getName()) + "(v);\n");
        output.write("    \treturn entity;\n");
        output.write("    };\n");
        output.write("    \n");
        output.write("    /**\n");
        output.write("     * Retourne les elements ayant comme valeur pour l'attribut\n");
        output.write("     * " + attr.getName() + " le parametre\n");
        output.write("     * @param v la valeur que doit avoir " + attr.getName() + "\n");
        output.write("     * @return une liste\n");
        output.write("     */\n");
        output.write("    public List<" + clazzFQN + "> findAll" + clazzName + "By" + StringUtils.capitalize((String)attr.getName()) + "(" + attr.getType() + " v) throws TopiaException{\n");
        output.write("\t\tTopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;\n");
        output.write("\t\t" + clazzName + "DAOAbstract dao = (" + clazzName + "DAOAbstract)usedContextImpl.getDAO(" + clazzName + ".class);\n");
        output.write("\t\tList<" + clazzName + "> entityList = dao.findAllBy" + StringUtils.capitalize((String)attr.getName()) + "(v);\n");
        output.write("    \treturn entityList; \n");
        output.write("    };\n");
        output.write("");
        if (attr.hasAssociationClass()) {
            output.write("\n");
            output.write("    /**\n");
            output.write("     * Retourne le premier element trouve ayant comme valeur pour l'attribut\n");
            output.write("     * " + TopiaGeneratorUtil.toLowerCaseFirstLetter((String)attr.getAssociationClass().getName()) + " le parametre\n");
            output.write("     * @param value la valeur que doit avoir " + TopiaGeneratorUtil.toLowerCaseFirstLetter((String)attr.getAssociationClass().getName()) + "\n");
            output.write("     * @return un element ou null\n");
            output.write("     */\n");
            output.write("    public " + clazzFQN + " find" + clazzName + "By" + StringUtils.capitalize((String)attr.getAssociationClass().getName()) + "(" + attr.getAssociationClass().getQualifiedName() + " value) throws TopiaException{\n");
            output.write("\t\tTopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;\n");
            output.write("\t\t" + clazzName + "DAOAbstract dao = (" + clazzName + "DAOAbstract)usedContextImpl.getDAO(" + clazzName + ".class);\n");
            output.write("\t\t" + clazzName + " entity = dao.findBy" + StringUtils.capitalize((String)attr.getName()) + "(v);\n");
            output.write("    \treturn entity; \n");
            output.write("    };\n");
            output.write("    \n");
            output.write("    /**\n");
            output.write("     * Retourne les elements ayant comme valeur pour l'attribut\n");
            output.write("     * " + TopiaGeneratorUtil.toLowerCaseFirstLetter((String)attr.getAssociationClass().getName()) + " le param\ufffdtre\n");
            output.write("     * @param value la valeur que doit avoir " + TopiaGeneratorUtil.toLowerCaseFirstLetter((String)attr.getAssociationClass().getName()) + "\n");
            output.write("     * @return une liste\n");
            output.write("     */\n");
            output.write("    public List<" + clazzFQN + "> findAll" + clazzName + "By" + StringUtils.capitalize((String)attr.getAssociationClass().getName()) + "(" + attr.getAssociationClass().getQualifiedName() + " value) throws TopiaException{\n");
            output.write("\t\tTopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;\n");
            output.write("\t\t" + clazzName + "DAOAbstract dao = (" + clazzName + "DAOAbstract)usedContextImpl.getDAO(" + clazzName + ".class);\n");
            output.write("\t\tList<" + clazzName + "> entityList = dao.findAllBy" + StringUtils.capitalize((String)attr.getName()) + "(v);\n");
            output.write("    \treturn entityList;\n");
            output.write("    };\n");
            output.write("");
        }
    }

    protected void generateNMultiplicity(Writer output, ObjectModelAttribute attr, ObjectModelClass clazz, boolean isAssoc) throws IOException {
        String clazzName = clazz.getName();
        String clazzFQN = clazz.getQualifiedName();
        output.write("    \n");
        output.write("    /**\n");
        output.write("     * Retourne le premier element trouve dont l'attribut\n");
        output.write("     * " + attr.getName() + " contient le parametre\n");
        output.write("     * @param v la valeur que doit contenir " + attr.getName() + "\n");
        output.write("     * @return un element ou null\n");
        output.write("     */\n");
        output.write("    public " + clazzFQN + " find" + clazzName + "Contains" + StringUtils.capitalize((String)attr.getName()) + "(" + attr.getType() + " ... v) throws TopiaException{\n");
        output.write("\t\tTopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;\n");
        output.write("\t\t" + clazzName + "DAOAbstract dao = (" + clazzName + "DAOAbstract)usedContextImpl.getDAO(" + clazzName + ".class);\n");
        output.write("\t\t" + clazzName + " entity = (" + clazzName + ") dao.findContainsProperties(\"" + TopiaGeneratorUtil.toLowerCaseFirstLetter((String)attr.getName()) + "\", Arrays.asList(v)); \n");
        output.write("    \treturn entity; \n");
        output.write("    };\n");
        output.write("    \n");
        output.write("    /**\n");
        output.write("     * Retourne les elements trouve dont l'attribut\n");
        output.write("     * " + attr.getName() + " contient le parametre\n");
        output.write("     * @param v la valeur que doit contenir " + attr.getName() + "\n");
        output.write("     * @return une liste\n");
        output.write("     */\n");
        output.write("    public List<" + clazzFQN + "> findAll" + clazzName + "Contains" + StringUtils.capitalize((String)attr.getName()) + "(" + attr.getType() + " ... v) throws TopiaException{\n");
        output.write("\t\tTopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;\n");
        output.write("\t\t" + clazzName + "DAOAbstract dao = (" + clazzName + "DAOAbstract)usedContextImpl.getDAO(" + clazzName + ".class);\n");
        output.write("\t\tList<" + clazzName + "> entityList = dao.findAllContainsProperties(\"" + TopiaGeneratorUtil.toLowerCaseFirstLetter((String)attr.getName()) + "\", Arrays.asList(v)); \n");
        output.write("    \treturn entityList;\n");
        output.write("    };\n");
        output.write("");
    }

    private void generateAssociatedClassOperations(Writer output, ObjectModelClassifier classifier) throws IOException {
        for (ObjectModelInterface parent : classifier.getInterfaces()) {
            if (!parent.hasStereotype("dao")) continue;
            String entityClassName = parent.getQualifiedName().replace("DAO", "");
            if (!((ObjectModel)this.getModel()).hasClass(entityClassName)) continue;
            ObjectModelClass clazz = ((ObjectModel)this.getModel()).getClass(entityClassName);
            this.generateFromDAOClass(output, clazz);
        }
    }

    private void generateFromDAOClass(Writer output, ObjectModelClass clazz) throws IOException {
        if (!clazz.hasStereotype("entity")) {
            return;
        }
        String clazzName = clazz.getName();
        String clazzFQN = clazz.getQualifiedName();
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            String assocAttrName;
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            String capitalizedAttrName = StringUtils.capitalize((String)attr.getName());
            if (!attr.isNavigable() && !TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType((ObjectModelAttribute)reverse, (ObjectModel)((ObjectModel)this.model))) continue;
            if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                if (!attr.hasAssociationClass()) {
                    output.write("    /**\n");
                    output.write("");
                    if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                        output.write("     * " + attr.getName() + " : " + attr.getDocumentation() + "\n");
                        output.write("");
                    }
                    output.write("     * @param " + GeneratorUtil.toLowerCaseFirstLetter((String)attr.getName()) + " La valeur de l'attribut " + attr.getName() + " a positionner.\n");
                    output.write("     */\n");
                    output.write("    public void set" + capitalizedAttrName + "Of" + clazzName + "(String topiaId, " + attr.getType() + " " + GeneratorUtil.toLowerCaseFirstLetter((String)attr.getName()) + ") throws TopiaException{\n");
                    output.write("        TopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;\n");
                    output.write("\t\t" + clazzName + "DAOAbstract dao = (" + clazzName + "DAOAbstract)usedContextImpl.getDAO(" + clazzName + ".class);\n");
                    output.write("\t\t" + clazzName + " entity = (" + clazzName + ")dao.findByTopiaId(topiaId); \n");
                    output.write("    \tentity.set" + StringUtils.capitalize((String)attr.getName()) + "(" + GeneratorUtil.toLowerCaseFirstLetter((String)attr.getName()) + ");\n");
                    output.write("    \tusedContextImpl.commitTransaction();\n");
                    output.write("    }\n");
                    output.write("\n");
                    output.write("");
                    output.write("    /**\n");
                    output.write("");
                    if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                        output.write("     * " + attr.getName() + " : " + attr.getDocumentation() + "\n");
                        output.write("");
                    }
                    output.write("     * @return La valeur de l'attribut " + attr.getName() + ".\n");
                    output.write("     */\n");
                    output.write("    public " + attr.getType() + " get" + StringUtils.capitalize((String)attr.getName()) + "Of" + clazzName + "(String topiaId) throws TopiaException{\n");
                    output.write("        TopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;\n");
                    output.write("\t\t" + clazzName + "DAOAbstract dao = (" + clazzName + "DAOAbstract)usedContextImpl.getDAO(" + clazzName + ".class);\n");
                    output.write("\t\t" + clazzName + " entity = (" + clazzName + ")dao.findByTopiaId(topiaId); \n");
                    output.write("    \treturn entity.get" + StringUtils.capitalize((String)attr.getName()) + "();\n");
                    output.write("    }\n");
                    output.write("\n");
                    output.write("");
                    continue;
                }
                assocAttrName = TopiaGeneratorUtil.getAssocAttrName((ObjectModelAttribute)attr);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("assocAttrName: " + assocAttrName));
                }
                output.write("    /**\n");
                output.write("     * @param " + GeneratorUtil.toLowerCaseFirstLetter((String)attr.getAssociationClass().getName()) + " La valeur de l'attribut " + attr.getAssociationClass().getName() + " \ufffd positionner.\n");
                output.write("     */\n");
                output.write("    public void set" + StringUtils.capitalize((String)assocAttrName) + "Of" + clazzName + "(String topiaId, " + attr.getAssociationClass().getQualifiedName() + " " + GeneratorUtil.toLowerCaseFirstLetter((String)attr.getAssociationClass().getName()) + ") throws TopiaException{\n");
                output.write("        TopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;\n");
                output.write("\t\t" + clazzName + "DAOAbstract dao = (" + clazzName + "DAOAbstract)usedContextImpl.getDAO(" + clazzName + ".class);\n");
                output.write("\t\t" + clazzName + " entity = (" + clazzName + ")dao.findByTopiaId(topiaId); \n");
                output.write("        entity.set" + StringUtils.capitalize((String)assocAttrName) + "(" + GeneratorUtil.toLowerCaseFirstLetter((String)attr.getAssociationClass().getName()) + ");\n");
                output.write("    }\n");
                output.write("\n");
                output.write("    /**\n");
                output.write("     * @return La valeur de l'attribut " + attr.getAssociationClass().getName() + ".\n");
                output.write("     */\n");
                output.write("    public " + attr.getAssociationClass().getQualifiedName() + " get" + StringUtils.capitalize((String)assocAttrName) + "Of" + clazzName + "(String topiaId) throws TopiaException{\n");
                output.write("        TopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;\n");
                output.write("\t\t" + clazzName + "DAOAbstract dao = (" + clazzName + "DAOAbstract)usedContextImpl.getDAO(" + clazzName + ".class);\n");
                output.write("\t\t" + clazzName + " entity = (" + clazzName + ")dao.findByTopiaId(topiaId); \n");
                output.write("    \treturn entity.get" + StringUtils.capitalize((String)assocAttrName) + "();\n");
                output.write("    }\n");
                output.write("\n");
                output.write("");
                continue;
            }
            if (!attr.hasAssociationClass()) {
                output.write("    /**\n");
                output.write("");
                if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                    output.write("     * " + attr.getName() + " : " + attr.getDocumentation() + "\n");
                    output.write("");
                }
                output.write("     * @param " + GeneratorUtil.toLowerCaseFirstLetter((String)attr.getName()) + " L'instance de " + attr.getName() + " \ufffd ajouter.\n");
                output.write("     */\n");
                output.write("    public void add" + StringUtils.capitalize((String)attr.getName()) + "Of" + clazzName + "(String topiaId, " + attr.getType() + " " + GeneratorUtil.toLowerCaseFirstLetter((String)attr.getName()) + ") throws TopiaException{\n");
                output.write("        TopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;\n");
                output.write("\t\t" + clazzName + "DAOAbstract dao = (" + clazzName + "DAOAbstract)usedContextImpl.getDAO(" + clazzName + ".class);\n");
                output.write("\t\t" + clazzName + " entity = (" + clazzName + ")dao.findByTopiaId(topiaId); \n");
                output.write("    \tentity.add" + StringUtils.capitalize((String)attr.getName()) + "(" + GeneratorUtil.toLowerCaseFirstLetter((String)attr.getName()) + ");\n");
                output.write("    }\n");
                output.write("\n");
                output.write("    /**\n");
                output.write("");
                if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                    output.write("     * " + attr.getName() + " : " + attr.getDocumentation() + "\n");
                    output.write("");
                }
                output.write("     * @param " + GeneratorUtil.toLowerCaseFirstLetter((String)attr.getName()) + " Les instances de " + attr.getName() + " \ufffd ajouter.\n");
                output.write("     */\n");
                output.write("    public void addAll" + StringUtils.capitalize((String)attr.getName()) + "Of" + clazzName + "(String topiaId, " + (attr.isOrdered() ? "java.util.List" : "java.util.Collection") + "<" + attr.getType() + "> " + GeneratorUtil.toLowerCaseFirstLetter((String)attr.getName()) + ") throws TopiaException{\n");
                output.write("    \tTopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;\n");
                output.write("\t\t" + clazzName + "DAOAbstract dao = (" + clazzName + "DAOAbstract)usedContextImpl.getDAO(" + clazzName + ".class);\n");
                output.write("\t\t" + clazzName + " entity = (" + clazzName + ")dao.findByTopiaId(topiaId);\n");
                output.write("    \tentity.addAll" + StringUtils.capitalize((String)attr.getName()) + "(" + GeneratorUtil.toLowerCaseFirstLetter((String)attr.getName()) + ");\n");
                output.write("    }\n");
                output.write("\n");
                output.write("    /**\n");
                output.write("");
                if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                    output.write("     * " + attr.getName() + " : " + attr.getDocumentation() + "\n");
                    output.write("");
                }
                output.write("     * @param " + GeneratorUtil.toLowerCaseFirstLetter((String)attr.getName()) + " La Collection de " + attr.getName() + " \ufffd positionner.\n");
                output.write("     */\n");
                output.write("    public void set" + StringUtils.capitalize((String)attr.getName()) + "Of" + clazzName + "(String topiaId, " + (attr.isOrdered() ? "java.util.List" : "java.util.Collection") + "<" + attr.getType() + "> " + GeneratorUtil.toLowerCaseFirstLetter((String)attr.getName()) + ") throws TopiaException{\n");
                output.write("    \tTopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;\n");
                output.write("\t\t" + clazzName + "DAOAbstract dao = (" + clazzName + "DAOAbstract)usedContextImpl.getDAO(" + clazzName + ".class);\n");
                output.write("\t\t" + clazzName + " entity = (" + clazzName + ")dao.findByTopiaId(topiaId);\n");
                output.write("    \tentity.set" + StringUtils.capitalize((String)attr.getName()) + "(" + GeneratorUtil.toLowerCaseFirstLetter((String)attr.getName()) + ");\n");
                output.write("    }\n");
                output.write("\n");
                output.write("    /**\n");
                output.write("");
                if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                    output.write("     * " + attr.getName() + " : " + attr.getDocumentation() + "\n");
                    output.write("");
                }
                output.write("     * @param " + GeneratorUtil.toLowerCaseFirstLetter((String)attr.getName()) + " L'instance de " + attr.getName() + " \ufffd retirer.\n");
                output.write("     */\n");
                output.write("    public void remove" + StringUtils.capitalize((String)attr.getName()) + "Of" + clazzName + "(String topiaId, " + attr.getType() + " " + GeneratorUtil.toLowerCaseFirstLetter((String)attr.getName()) + ") throws TopiaException{\n");
                output.write("    \tTopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;\n");
                output.write("\t\t" + clazzName + "DAOAbstract dao = (" + clazzName + "DAOAbstract)usedContextImpl.getDAO(" + clazzName + ".class);\n");
                output.write("\t\t" + clazzName + " entity = (" + clazzName + ")dao.findByTopiaId(topiaId);\n");
                output.write("    \tentity.remove" + StringUtils.capitalize((String)attr.getName()) + "(" + GeneratorUtil.toLowerCaseFirstLetter((String)attr.getName()) + ");\n");
                output.write("    }\n");
                output.write("\n");
                output.write("    /**\n");
                output.write("");
                if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                    output.write("     * " + attr.getName() + " : " + attr.getDocumentation() + "\n");
                    output.write("");
                }
                output.write("     * Vide la Collection de " + attr.getName() + ".\n");
                output.write("     */\n");
                output.write("    public void clear" + StringUtils.capitalize((String)attr.getName()) + "Of" + clazzName + "(String topiaId) throws TopiaException{\n");
                output.write("    \tTopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;\n");
                output.write("\t\t" + clazzName + "DAOAbstract dao = (" + clazzName + "DAOAbstract)usedContextImpl.getDAO(" + clazzName + ".class);\n");
                output.write("\t\t" + clazzName + " entity = (" + clazzName + ")dao.findByTopiaId(topiaId);\n");
                output.write("    \tentity.clear" + StringUtils.capitalize((String)attr.getName()) + "();\n");
                output.write("    }\n");
                output.write("\n");
                output.write("");
            } else {
                assocAttrName = TopiaGeneratorUtil.getAssocAttrName((ObjectModelAttribute)attr);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("assocAttrName: " + assocAttrName));
                }
                output.write("    /**\n");
                output.write("     * @param " + GeneratorUtil.toLowerCaseFirstLetter((String)attr.getAssociationClass().getName()) + " L'instance de " + attr.getAssociationClass().getName() + " \ufffd ajouter.\n");
                output.write("     */\n");
                output.write("    public void add" + StringUtils.capitalize((String)assocAttrName) + "Of" + clazzName + "(String topiaId, " + attr.getAssociationClass().getQualifiedName() + " " + GeneratorUtil.toLowerCaseFirstLetter((String)attr.getAssociationClass().getName()) + ") throws TopiaException{\n");
                output.write("    \tTopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;\n");
                output.write("\t\t" + clazzName + "DAOAbstract dao = (" + clazzName + "DAOAbstract)usedContextImpl.getDAO(" + clazzName + ".class);\n");
                output.write("\t\t" + clazzName + " entity = (" + clazzName + ")dao.findByTopiaId(topiaId);\n");
                output.write("    \tentity.add" + StringUtils.capitalize((String)assocAttrName) + "(" + GeneratorUtil.toLowerCaseFirstLetter((String)attr.getAssociationClass().getName()) + ");\n");
                output.write("    }\n");
                output.write("\n");
                output.write("    /**\n");
                output.write("     * @param " + GeneratorUtil.toLowerCaseFirstLetter((String)attr.getAssociationClass().getName()) + " Les instances de " + attr.getAssociationClass().getName() + " \ufffd ajouter.\n");
                output.write("     */\n");
                output.write("    public void addAll" + StringUtils.capitalize((String)assocAttrName) + "Of" + clazzName + "(String topiaId, " + (attr.isOrdered() ? "java.util.List" : "java.util.Collection") + "<" + attr.getAssociationClass().getQualifiedName() + "> " + GeneratorUtil.toLowerCaseFirstLetter((String)attr.getAssociationClass().getName()) + ") throws TopiaException{\n");
                output.write("    \tTopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;\n");
                output.write("\t\t" + clazzName + "DAOAbstract dao = (" + clazzName + "DAOAbstract)usedContextImpl.getDAO(" + clazzName + ".class);\n");
                output.write("\t\t" + clazzName + " entity = (" + clazzName + ")dao.findByTopiaId(topiaId);\n");
                output.write("    \tentity.addAll" + StringUtils.capitalize((String)assocAttrName) + "(" + GeneratorUtil.toLowerCaseFirstLetter((String)attr.getAssociationClass().getName()) + ");\n");
                output.write("    }\n");
                output.write("\n");
                output.write("    /**\n");
                output.write("     * @param " + GeneratorUtil.toLowerCaseFirstLetter((String)attr.getAssociationClass().getName()) + " La Collection de " + attr.getAssociationClass().getName() + " \ufffd positionner.\n");
                output.write("     */\n");
                output.write("    public void set" + StringUtils.capitalize((String)assocAttrName) + "Of" + clazzName + "(String topiaId, " + (attr.isOrdered() ? "java.util.List" : "java.util.Collection") + "<" + attr.getAssociationClass().getQualifiedName() + "> " + GeneratorUtil.toLowerCaseFirstLetter((String)attr.getAssociationClass().getName()) + ") throws TopiaException{\n");
                output.write("    \tTopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;\n");
                output.write("\t\t" + clazzName + "DAOAbstract dao = (" + clazzName + "DAOAbstract)usedContextImpl.getDAO(" + clazzName + ".class);\n");
                output.write("\t\t" + clazzName + " entity = (" + clazzName + ")dao.findByTopiaId(topiaId);\n");
                output.write("    \tentity.set" + StringUtils.capitalize((String)assocAttrName) + "(" + GeneratorUtil.toLowerCaseFirstLetter((String)attr.getAssociationClass().getName()) + ");\n");
                output.write("    }\n");
                output.write("\n");
                output.write("    /**\n");
                output.write("     * @param " + GeneratorUtil.toLowerCaseFirstLetter((String)attr.getAssociationClass().getName()) + " L'instance de " + attr.getAssociationClass().getName() + " \ufffd retirer.\n");
                output.write("     */\n");
                output.write("    public void remove" + StringUtils.capitalize((String)assocAttrName) + "Of" + clazzName + "(String topiaId, " + attr.getAssociationClass().getQualifiedName() + " " + GeneratorUtil.toLowerCaseFirstLetter((String)attr.getAssociationClass().getName()) + ") throws TopiaException{\n");
                output.write("    \tTopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;\n");
                output.write("\t\t" + clazzName + "DAOAbstract dao = (" + clazzName + "DAOAbstract)usedContextImpl.getDAO(" + clazzName + ".class);\n");
                output.write("\t\t" + clazzName + " entity = (" + clazzName + ")dao.findByTopiaId(topiaId);\n");
                output.write("    \tentity.remove" + StringUtils.capitalize((String)assocAttrName) + "(" + GeneratorUtil.toLowerCaseFirstLetter((String)attr.getAssociationClass().getName()) + ");\n");
                output.write("    }\n");
                output.write("\n");
                output.write("    /**\n");
                output.write("     * Vide la Collection de " + attr.getAssociationClass().getName() + ".\n");
                output.write("     */\n");
                output.write("    public void clear" + StringUtils.capitalize((String)assocAttrName) + "Of" + clazzName + "(String topiaId) throws TopiaException{\n");
                output.write("    \tTopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;\n");
                output.write("\t\t" + clazzName + "DAOAbstract dao = (" + clazzName + "DAOAbstract)usedContextImpl.getDAO(" + clazzName + ".class);\n");
                output.write("\t\t" + clazzName + " entity = (" + clazzName + ")dao.findByTopiaId(topiaId);\n");
                output.write("    \tentity.clear" + StringUtils.capitalize((String)assocAttrName) + "();\n");
                output.write("    }\n");
                output.write("\n");
                output.write("");
            }
            if (!attr.hasAssociationClass()) {
                output.write("    /**\n");
                output.write("");
                if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                    output.write("     * " + attr.getName() + " : " + attr.getDocumentation() + "\n");
                    output.write("");
                }
                output.write("     * @return La Liste de " + attr.getName() + ".\n");
                output.write("     */\n");
                output.write("    public " + (attr.isOrdered() ? "java.util.List" : "java.util.Collection") + "<" + attr.getType() + "> get" + StringUtils.capitalize((String)attr.getName()) + "Of" + clazzName + "(String topiaId) throws TopiaException{\n");
                output.write("    \tTopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;\n");
                output.write("\t\t" + clazzName + "DAOAbstract dao = (" + clazzName + "DAOAbstract)usedContextImpl.getDAO(" + clazzName + ".class);\n");
                output.write("\t\t" + clazzName + " entity = (" + clazzName + ")dao.findByTopiaId(topiaId);\n");
                output.write("    \treturn entity.get" + StringUtils.capitalize((String)attr.getName()) + "();\n");
                output.write("    }\n");
                output.write("\n");
                output.write("    /**\n");
                output.write("     * @return Le nombre d'\ufffdl\ufffdments de la collection " + attr.getName() + ".\n");
                output.write("     */\n");
                output.write("    public int size" + StringUtils.capitalize((String)attr.getName()) + "Of" + clazzName + "(String topiaId) throws TopiaException{\n");
                output.write("    \tTopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;\n");
                output.write("\t\t" + clazzName + "DAOAbstract dao = (" + clazzName + "DAOAbstract)usedContextImpl.getDAO(" + clazzName + ".class);\n");
                output.write("\t\t" + clazzName + " entity = (" + clazzName + ")dao.findByTopiaId(topiaId);\n");
                output.write("    \treturn entity.size" + StringUtils.capitalize((String)attr.getName()) + "();\n");
                output.write("    }\n");
                output.write("\n");
                output.write("");
                continue;
            }
            assocAttrName = TopiaGeneratorUtil.getAssocAttrName((ObjectModelAttribute)attr);
            if (log.isTraceEnabled()) {
                log.trace((Object)("assocAttrName: " + assocAttrName));
            }
            output.write("    /**\n");
            output.write("     * @return La liste des attributs " + attr.getAssociationClass().getName() + ".\n");
            output.write("     */\n");
            output.write("    public " + (attr.isOrdered() ? "java.util.List" : "java.util.Collection") + "<" + attr.getAssociationClass().getQualifiedName() + "> get" + StringUtils.capitalize((String)assocAttrName) + "Of" + clazzName + "(String topiaId) throws TopiaException{\n");
            output.write("    \tTopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;\n");
            output.write("\t\t" + clazzName + "DAOAbstract dao = (" + clazzName + "DAOAbstract)usedContextImpl.getDAO(" + clazzName + ".class);\n");
            output.write("\t\t" + clazzName + " entity = (" + clazzName + ")dao.findByTopiaId(topiaId);\n");
            output.write("    \treturn entity.get" + StringUtils.capitalize((String)assocAttrName) + "();\n");
            output.write("    }\n");
            output.write("\n");
            output.write("    /**\n");
            output.write("     * @return L'attribut " + attr.getAssociationClass().getName() + " associ\ufffd \ufffd la valeur <code>value</code> de l'attribut " + attr.getName() + ".\n");
            output.write("     */\n");
            output.write("    public " + attr.getAssociationClass().getQualifiedName() + " get" + StringUtils.capitalize((String)assocAttrName) + "Of" + clazzName + "(String topiaId, " + attr.getType() + " value) throws TopiaException{\n");
            output.write("    \tTopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;\n");
            output.write("\t\t" + clazzName + "DAOAbstract dao = (" + clazzName + "DAOAbstract)usedContextImpl.getDAO(" + clazzName + ".class);\n");
            output.write("\t\t" + clazzName + " entity = (" + clazzName + ")dao.findByTopiaId(topiaId);\n");
            output.write("    \treturn entity.get" + StringUtils.capitalize((String)assocAttrName) + "((" + attr.getType() + ") value);\n");
            output.write("    }\n");
            output.write("\n");
            output.write("    /**\n");
            output.write("     * @return Le nombre d'\ufffdl\ufffdments de la collection " + attr.getName() + ".\n");
            output.write("     */\n");
            output.write("    public int size" + StringUtils.capitalize((String)assocAttrName) + "Of" + clazzName + "(String topiaId) throws TopiaException{\n");
            output.write("    \tTopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;\n");
            output.write("\t\t" + clazzName + "DAOAbstract dao = (" + clazzName + "DAOAbstract)usedContextImpl.getDAO(" + clazzName + ".class);\n");
            output.write("\t\t" + clazzName + " entity = (" + clazzName + ")dao.findByTopiaId(topiaId);\n");
            output.write("    \treturn entity.size" + StringUtils.capitalize((String)assocAttrName) + "();\n");
            output.write("    }\n");
            output.write("\n");
            output.write("");
        }
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass)clazz;
            for (ObjectModelAttribute attr : assoc.getParticipantsAttributes()) {
                if (attr == null) continue;
                String type = attr.getType();
                String name = attr.getName();
                this.generateAssociationAccessors(output, clazz, name, type);
                if (attr.getReverseAttribute() != null) continue;
                type = ((ObjectModelClassifier)attr.getDeclaringElement()).getQualifiedName();
                name = attr.getDeclaringElement().getName();
                this.generateAssociationAccessors(output, clazz, name, type);
            }
        }
        this.generateInterfaceOperationsOfClass(output, (ObjectModelClassifier)clazz);
    }

    private void generateInterfaceOperationsOfClass(Writer output, ObjectModelClassifier classifier) throws IOException {
        String classifierName = classifier.getName();
        for (ObjectModelOperation op : classifier.getOperations()) {
            String opName = op.getName();
            String opVisibility = op.getVisibility();
            String opType = op.getReturnType();
            output.write("    /**\n");
            output.write("");
            if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)op)) {
                output.write("     * " + opName + " : " + op.getDocumentation() + "\n");
                output.write("");
            }
            Collection params = op.getParameters();
            for (ObjectModelParameter param : params) {
                String paramName = param.getName();
                String paramDocumentation = param.getDocumentation();
                output.write("     * @param " + paramName + " " + paramDocumentation + "\n");
                output.write(" ");
            }
            output.write("     */\n");
            output.write("    " + opVisibility + " " + opType + " " + opName + "Of" + classifierName + "(String topiaId");
            String comma = ",";
            for (ObjectModelParameter param : params) {
                String paramName = param.getName();
                String paramType = param.getType();
                output.write("" + comma + "" + paramType + " " + paramName + "");
            }
            output.write(")");
            Set exceptions = op.getExceptions();
            if (exceptions.isEmpty()) {
                output.write("throws TopiaException");
            }
            comma = " throws ";
            for (String exception : exceptions) {
                output.write("" + comma + "" + exception + "");
                comma = ", ";
            }
            output.write("{\n");
            output.write("\t\tTopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;\n");
            output.write("\t\t" + classifierName + "DAOAbstract dao = (" + classifierName + "DAOAbstract)usedContextImpl.getDAO(" + classifierName + ".class);\n");
            output.write("\t\t" + classifierName + " entity = (" + classifierName + ")dao.findByTopiaId(topiaId);\n");
            output.write("");
            if (!op.getReturnType().toString().equalsIgnoreCase("void")) {
                output.write("        return ");
            }
            output.write(" entity." + opName + "(");
            comma = "";
            for (ObjectModelParameter param : params) {
                String paramName = param.getName();
                output.write("" + comma + "" + paramName + "");
                comma = ", ";
            }
            output.write(");\n");
            output.write("    }\n");
            output.write("");
            output.write("\n");
            output.write("\n");
            output.write("");
        }
    }

    private void generateAssociationAccessors(Writer output, ObjectModelClass clazz, String name, String type) throws IOException {
        String clazzName = clazz.getName();
        output.write("    /**\n");
        output.write("     * @param value La valeur de l'attribut " + name + " \u00e0 positionner.\n");
        output.write("     */\n");
        output.write("    public void set" + StringUtils.capitalize((String)name) + "Of" + clazzName + "(String topiaId, " + type + " value) throws TopiaException{\n");
        output.write("    \tTopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;\n");
        output.write("\t\t" + clazzName + "DAOAbstract dao = (" + clazzName + "DAOAbstract)usedContextImpl.getDAO(" + clazzName + ".class);\n");
        output.write("\t\t" + clazzName + " entity = (" + clazzName + ")dao.findByTopiaId(topiaId);\n");
        output.write("    \tentity.set" + StringUtils.capitalize((String)name) + "( value);\n");
        output.write("    }\n");
        output.write("\n");
        output.write("    /**\n");
        output.write("     * @return La valeur de l'attribut " + name + ".\n");
        output.write("     */\n");
        output.write("    public " + type + " get" + StringUtils.capitalize((String)name) + "Of" + clazzName + "(String topiaId) throws TopiaException{\n");
        output.write("    \tTopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;\n");
        output.write("\t\t" + clazzName + "DAOAbstract dao = (" + clazzName + "DAOAbstract)usedContextImpl.getDAO(" + clazzName + ".class);\n");
        output.write("\t\t" + clazzName + " entity = (" + clazzName + ")dao.findByTopiaId(topiaId);\n");
        output.write("    \treturn entity.get" + StringUtils.capitalize((String)name) + "();\n");
        output.write("    }\n");
        output.write("\n");
        output.write("");
    }
}

