package org.nuiton.topia.security.entities.user;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.security.listener.NoSecurityLoad;

/**
 * Implantation POJO pour l'entité {@link TopiaUser}.
 */
public abstract class TopiaUserAbstract extends TopiaEntityAbstract implements TopiaUser {

    public String login;

    public String email;

    public String password;

    public String note;

    public String linkApplication;

    public Collection<TopiaGroup> topiaGroup;

    /**
     * Constructeur de TopiaUserAbstract par défaut.
     */
    public TopiaUserAbstract() {
    }

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(TopiaUser.class).update(this);
    }

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(TopiaUser.class).delete(this);
    }

    /**
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
     * avec leur nom, type et valeur.
     *
     * @param visitor le visiteur de l'entite.
     *
     * @throws TopiaException if any pb while visit 
     */
    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "login", String.class, login);
        visitor.visit(this, "email", String.class, email);
        visitor.visit(this, "password", String.class, password);
        visitor.visit(this, "note", String.class, note);
        visitor.visit(this, "linkApplication", String.class, linkApplication);
        visitor.visit(this, "topiaGroup", Collection.class, TopiaGroup.class, topiaGroup);
        visitor.end(this);
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) { 
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        
        return result;
    }

    /* (non-Javadoc)
     * @see TopiaUser#setLogin(String)
     */
    @Override
    public void setLogin(String value) {
        String _oldValue = this.login;
        fireOnPreWrite("login", _oldValue, value);
        this.login = value;
        fireOnPostWrite("login", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see TopiaUser#getLogin()
     */
    @Override
    public String getLogin() {
        fireOnPreRead("login", login);
        String result = this.login;
        fireOnPostRead("login", login);
        return result;
    }

    /* (non-Javadoc)
     * @see TopiaUser#setEmail(String)
     */
    @Override
    public void setEmail(String value) {
        String _oldValue = this.email;
        fireOnPreWrite("email", _oldValue, value);
        this.email = value;
        fireOnPostWrite("email", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see TopiaUser#getEmail()
     */
    @Override
    public String getEmail() {
        fireOnPreRead("email", email);
        String result = this.email;
        fireOnPostRead("email", email);
        return result;
    }

    /* (non-Javadoc)
     * @see TopiaUser#setPassword(String)
     */
    @Override
    public void setPassword(String value) {
        String _oldValue = this.password;
        fireOnPreWrite("password", _oldValue, value);
        this.password = value;
        fireOnPostWrite("password", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see TopiaUser#getPassword()
     */
    @Override
    public String getPassword() {
        fireOnPreRead("password", password);
        String result = this.password;
        fireOnPostRead("password", password);
        return result;
    }

    /* (non-Javadoc)
     * @see TopiaUser#setNote(String)
     */
    @Override
    public void setNote(String value) {
        String _oldValue = this.note;
        fireOnPreWrite("note", _oldValue, value);
        this.note = value;
        fireOnPostWrite("note", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see TopiaUser#getNote()
     */
    @Override
    public String getNote() {
        fireOnPreRead("note", note);
        String result = this.note;
        fireOnPostRead("note", note);
        return result;
    }

    /* (non-Javadoc)
     * @see TopiaUser#setLinkApplication(String)
     */
    @Override
    public void setLinkApplication(String value) {
        String _oldValue = this.linkApplication;
        fireOnPreWrite("linkApplication", _oldValue, value);
        this.linkApplication = value;
        fireOnPostWrite("linkApplication", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see TopiaUser#getLinkApplication()
     */
    @Override
    public String getLinkApplication() {
        fireOnPreRead("linkApplication", linkApplication);
        String result = this.linkApplication;
        fireOnPostRead("linkApplication", linkApplication);
        return result;
    }

    /* (non-Javadoc)
     * @see TopiaUser#addTopiaGroup(TopiaGroup)
     */
    @Override
    public void addTopiaGroup(TopiaGroup topiaGroup) {
        fireOnPreWrite("topiaGroup", null, topiaGroup);
        if (this.topiaGroup == null) {
            this.topiaGroup = new ArrayList<TopiaGroup>();
        }
        if (topiaGroup.getTopiaUser() == null) {
            topiaGroup.setTopiaUser(new ArrayList<TopiaUser>());
        }
        topiaGroup.getTopiaUser().add(this);
        this.topiaGroup.add(topiaGroup);
        fireOnPostWrite("topiaGroup", this.topiaGroup.size(), null, topiaGroup);
    }

    /* (non-Javadoc)
     * @see TopiaUser#addAllTopiaGroup(Collection<TopiaGroup>)
     */
    @Override
    public void addAllTopiaGroup(Collection<TopiaGroup> values) {
        if (values == null) {
            return;
        }
        for (TopiaGroup item : values) {
            addTopiaGroup(item);
        }
    }

    /* (non-Javadoc)
     * @see TopiaUser#getTopiaGroupByTopiaId(String)
     */
    @Override
    public TopiaGroup getTopiaGroupByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(topiaGroup, topiaId);
    }
 
    /* (non-Javadoc)
     * @see TopiaUser#setTopiaGroup(Collection<TopiaGroup>)
     */
    @Override
    public void setTopiaGroup(Collection<TopiaGroup> values) {
        Collection<TopiaGroup> _oldValue = topiaGroup;
        fireOnPreWrite("topiaGroup", _oldValue, values);
        topiaGroup = values;
        fireOnPostWrite("topiaGroup", _oldValue, values);
    }

    /* (non-Javadoc)
     * @see TopiaUser#removeTopiaGroup(TopiaGroup)
     */
    @Override
    public void removeTopiaGroup(TopiaGroup value) {
        fireOnPreWrite("topiaGroup", value, null);
        if ((this.topiaGroup == null) || (!this.topiaGroup.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.getTopiaUser().remove(this);
        fireOnPostWrite("topiaGroup", this.topiaGroup.size()+1, value, null);
    }

    /* (non-Javadoc)
     * @see TopiaUser#clearTopiaGroup()
     */
    @Override
    public void clearTopiaGroup() {
        if (this.topiaGroup == null) {
            return;
        }
        for (TopiaGroup item : this.topiaGroup) {
            item.getTopiaUser().remove(this);
        }
        Collection<TopiaGroup> _oldValue = new ArrayList<TopiaGroup>(this.topiaGroup);
        fireOnPreWrite("topiaGroup", _oldValue, this.topiaGroup);
        this.topiaGroup.clear();
        fireOnPostWrite("topiaGroup", _oldValue, this.topiaGroup);
    }

    /* (non-Javadoc)
     * @see TopiaUser#getTopiaGroup()
     */
    @Override
    public Collection<TopiaGroup> getTopiaGroup() {
        return topiaGroup;
    }

    /* (non-Javadoc)
     * @see TopiaUser#sizeTopiaGroup()
     */
    @Override
    public int sizeTopiaGroup() {
        if (topiaGroup == null) {
            return 0;
        }
        return topiaGroup.size();
    }

    /* (non-Javadoc)
     * @see TopiaUser#isTopiaGroupEmpty()
     */
    @Override
    public boolean isTopiaGroupEmpty() {
        int size = sizeTopiaGroup();
        return size == 0;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("login", this.login).
            append("email", this.email).
            append("password", this.password).
            append("note", this.note).
            append("linkApplication", this.linkApplication).
         toString();
        return result;
    }
        
} //TopiaUserAbstract
