/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.liquibase;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import liquibase.Contexts;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.CompositeResourceAccessor;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.liquibase.TopiaLiquibaseService;
import org.nuiton.topia.persistence.TopiaApplicationContext;
import org.nuiton.topia.persistence.TopiaException;

public class TopiaLiquibaseServiceImpl
implements TopiaLiquibaseService {
    private static final Log log = LogFactory.getLog(TopiaLiquibaseServiceImpl.class);
    protected Contexts contexts = new Contexts("");
    protected String changeLogPath = "db/changelog-master.xml";

    public void setConfiguration(Map<String, String> serviceConfiguration) {
        if (!serviceConfiguration.isEmpty()) {
            throw new UnsupportedOperationException("no configuratione expected but " + serviceConfiguration + " given");
        }
    }

    public Class<?>[] getPersistenceClasses() {
        return new Class[0];
    }

    public void preInit(TopiaApplicationContext topiaApplicationContext) {
        Database database = null;
        try {
            ResourceAccessor resourceAccessor = this.getResourceAccessor();
            database = this.openDatabase(topiaApplicationContext, resourceAccessor);
            Liquibase liquibase = this.getLiquibase(database, resourceAccessor);
            if (this.isSchemaEmpty(liquibase, topiaApplicationContext)) {
                this.createSchema(liquibase, topiaApplicationContext);
            } else {
                this.migrateSchema(liquibase, topiaApplicationContext);
            }
        }
        catch (LiquibaseException e) {
            throw new TopiaException("unable to init liquibase", (Throwable)e);
        }
        finally {
            if (database != null) {
                try {
                    database.close();
                }
                catch (DatabaseException e) {
                    throw new TopiaException("unable to close database after migration", (Throwable)e);
                }
            }
        }
    }

    protected boolean isSchemaEmpty(Liquibase liquibase, TopiaApplicationContext topiaApplicationContext) {
        boolean schemaEmpty = topiaApplicationContext.isSchemaEmpty();
        return schemaEmpty;
    }

    protected void createSchema(Liquibase liquibase, TopiaApplicationContext topiaApplicationContext) throws LiquibaseException {
        if (log.isInfoEnabled()) {
            log.info((Object)"schema is empty, ignore migrations and let topia create schema");
        }
        topiaApplicationContext.createSchema();
        if (log.isInfoEnabled()) {
            log.info((Object)"sync changelog");
        }
        liquibase.changeLogSync(this.contexts);
    }

    protected void migrateSchema(Liquibase liquibase, TopiaApplicationContext topiaApplicationContext) throws LiquibaseException {
        liquibase.update(this.contexts);
    }

    protected Liquibase getLiquibase(Database database, ResourceAccessor resourceAccessor) throws LiquibaseException {
        Liquibase liquibase = new Liquibase(this.changeLogPath, resourceAccessor, database);
        return liquibase;
    }

    protected ResourceAccessor getResourceAccessor() {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        ClassLoaderResourceAccessor threadClFO = new ClassLoaderResourceAccessor(contextClassLoader);
        ClassLoaderResourceAccessor clFO = new ClassLoaderResourceAccessor();
        FileSystemResourceAccessor fsFO = new FileSystemResourceAccessor();
        return new CompositeResourceAccessor(new ResourceAccessor[]{clFO, fsFO, threadClFO});
    }

    protected Database openDatabase(TopiaApplicationContext topiaApplicationContext, ResourceAccessor resourceAccessor) {
        ImmutableMap configuration = topiaApplicationContext.getConfiguration();
        String url = (String)configuration.get("hibernate.connection.url");
        String user = (String)configuration.get("hibernate.connection.username");
        String password = (String)configuration.get("hibernate.connection.password");
        try {
            Database database = DatabaseFactory.getInstance().openDatabase(url, user, password, resourceAccessor);
            return database;
        }
        catch (DatabaseException e) {
            throw new TopiaException("cannot get database for migration connection", (Throwable)e);
        }
    }

    public void postInit(TopiaApplicationContext context) {
    }
}

