package org.nuiton.topia.history.entities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;


public abstract class HistoryDAOAbstract<E extends History> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)History.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

    /**
     * findByActionDate :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut actionDate le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByActionDate(Date v) throws TopiaException {
        E result = findByProperty(History.ACTION_DATE, v);
        return result;
    }

    /**
     * findAllByActionDate :
     * Retourne les éléments ayant comme valeur pour l'attribut actionDate le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByActionDate(Date v) throws TopiaException {
        List<E> result = findAllByProperty(History.ACTION_DATE, v);
        return result;
    }

    /**
     * findByUserId :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut userId le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByUserId(String v) throws TopiaException {
        E result = findByProperty(History.USER_ID, v);
        return result;
    }

    /**
     * findAllByUserId :
     * Retourne les éléments ayant comme valeur pour l'attribut userId le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByUserId(String v) throws TopiaException {
        List<E> result = findAllByProperty(History.USER_ID, v);
        return result;
    }

    /**
     * findByAction :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut action le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByAction(int v) throws TopiaException {
        E result = findByProperty(History.ACTION, v);
        return result;
    }

    /**
     * findAllByAction :
     * Retourne les éléments ayant comme valeur pour l'attribut action le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByAction(int v) throws TopiaException {
        List<E> result = findAllByProperty(History.ACTION, v);
        return result;
    }

    /**
     * findByType :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut type le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByType(String v) throws TopiaException {
        E result = findByProperty(History.TYPE, v);
        return result;
    }

    /**
     * findAllByType :
     * Retourne les éléments ayant comme valeur pour l'attribut type le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByType(String v) throws TopiaException {
        List<E> result = findAllByProperty(History.TYPE, v);
        return result;
    }

    /**
     * findByTarget :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut target le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByTarget(String v) throws TopiaException {
        E result = findByProperty(History.TARGET, v);
        return result;
    }

    /**
     * findAllByTarget :
     * Retourne les éléments ayant comme valeur pour l'attribut target le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByTarget(String v) throws TopiaException {
        List<E> result = findAllByProperty(History.TARGET, v);
        return result;
    }

    /**
     * findUsages :
     * @param type 
     * @param entity 
     * @return <U extends TopiaEntity> List<U> 
     * @throws TopiaException
     */

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        return new ArrayList<U>();
    }

    /**
     * findAllUsages :
     * @param entity 
     * @return Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> 
     * @throws TopiaException
     */

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }


} //HistoryDAOAbstract<E extends History>
