/* *##% ToPIA - History service
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*/

/* *
 * HistoryListener.java
 *
 * Created: 13 oct. 06 21:31:23
 *
 * @author poussin
 * @version $Revision: 1459 $
 *
 * Last update: $Date: 2009-05-16 09:56:47 +0200 (Sat, 16 May 2009) $
 * by : $Author: tchemit $
 */

package org.nuiton.topia.history;

import java.util.Date;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaHistoryDAOHelper;
import org.nuiton.topia.event.TopiaEntityEvent;
import org.nuiton.topia.event.TopiaEntityListener;
import org.nuiton.topia.history.entities.History;
import org.nuiton.topia.history.entities.HistoryDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.security.util.TopiaSecurityUtil;


/**
 * 
 * @author poussin
 */
public class TopiaHistoryListener implements TopiaEntityListener {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(TopiaHistoryListener.class);

    protected boolean historyCreate;
    protected boolean historyDelete;
    protected boolean historyUpdate;
    protected boolean historyLoad;
    protected TopiaContext context;

    public TopiaHistoryListener(TopiaContext context, boolean historyCreate,
            boolean historyDelete, boolean historyUpdate, boolean historyLoad) {
        this.context = context;
        this.historyCreate = historyCreate;
        this.historyDelete = historyDelete;
        this.historyUpdate = historyUpdate;
        this.historyLoad = historyLoad;
    }
    
    /* (non-Javadoc)
     * @see org.nuiton.topia.event.TopiaEntityListener#entityCreated(org.nuiton.topia.event.TopiaEntityEvent)
     */
    @Override
    public void create(TopiaEntityEvent e) {
        if (historyCreate) {
            TopiaEntity entity = e.getEntity();
            addToHistory(entity, TopiaSecurityUtil.CREATE);
        }
    }
    
    /* (non-Javadoc)
     * @see org.nuiton.topia.event.TopiaEntityListener#entityDeleted(org.nuiton.topia.event.TopiaEntityEvent)
     */
    @Override
    public void delete(TopiaEntityEvent e) {
        if (historyDelete) {
            TopiaEntity entity = e.getEntity();
            addToHistory(entity, TopiaSecurityUtil.DELETE);
        }
    }

    /* (non-Javadoc)
     * @see org.nuiton.topia.event.TopiaEntityListener#entityUpdated(org.nuiton.topia.event.TopiaEntityEvent)
     */
    @Override
    public void update(TopiaEntityEvent e) {
        if (historyUpdate) {
            TopiaEntity entity = e.getEntity();
            addToHistory(entity, TopiaSecurityUtil.UPDATE);
        }
    }

    /* (non-Javadoc)
     * @see org.nuiton.topia.event.TopiaEntityLoadListener#entityLoaded(org.nuiton.topia.event.TopiaEntityLoadEvent)
     */
    @Override
    public void load(TopiaEntityEvent e) {
        if (historyLoad) {
            TopiaEntity entity = e.getEntity();
            addToHistory(entity, TopiaSecurityUtil.LOAD);
        }
    }

    protected void addToHistory(TopiaEntity entity, int action) {
        if (!(entity instanceof NoHistory)) {
            String user = TopiaSecurityUtil.getUserPrincipal();
            Date date = new Date();
            try {
                TopiaContext tx = context.beginTransaction();
                HistoryDAO dao = TopiaHistoryDAOHelper.getHistoryDAO(tx);
                
                History history = dao.create();
                history.setActionDate(date);
                history.setUserId(user);
                history.setAction(action);
                history.setTypeAndTarget(entity.getTopiaId());

                tx.commitTransaction();
                tx.closeContext();
            } catch (TopiaException eee) {
                if (log.isWarnEnabled()) {
                    log.warn("Can't add create action in history", eee);
                }
            }
        }
    }

}
