/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.event;

public class EntityState
implements Comparable<EntityState> {
    static final int NULL = 0;
    static final int LOADED = 1;
    static final int READ = 2;
    static final int CREATED = 4;
    static final int WRITTEN = 8;
    static final int UPDATED = 16;
    static final int DELETED = 32;
    protected int state = 0;

    public void addLoaded() {
        this.state |= 1;
    }

    public void addRead() {
        this.state |= 2;
    }

    public void addCreated() {
        this.state |= 4;
    }

    public void addUpdated() {
        this.state |= 0x10;
    }

    public void addWritten() {
        this.state |= 8;
    }

    public void addDeleted() {
        this.state |= 0x20;
    }

    public boolean isLoaded() {
        return (this.state & 1) == 1;
    }

    public boolean isRead() {
        return (this.state & 2) == 2;
    }

    public boolean isCreated() {
        return (this.state & 4) == 4;
    }

    public boolean isWritten() {
        return (this.state & 8) == 8;
    }

    public boolean isUpdated() {
        return (this.state & 0x10) == 16;
    }

    public boolean isDeleted() {
        return (this.state & 0x20) == 32;
    }

    @Override
    public int compareTo(EntityState o) {
        return this.state - o.state;
    }
}

