/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence;

import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaIdFactory;

public class LegacyTopiaIdFactory
implements TopiaIdFactory {
    @Override
    public <E extends TopiaEntity> String newTopiaId(Class<E> entityClass, TopiaEntity topiaEntity) {
        if (!entityClass.isInterface()) {
            throw new IllegalArgumentException("Only interface is permit to create id: " + entityClass);
        }
        double random = Math.random();
        while (Double.toString(random).contains("E-")) {
            random = Math.random();
        }
        return entityClass.getName() + '#' + System.currentTimeMillis() + '#' + random;
    }

    @Override
    public <E extends TopiaEntity> Class<E> getClassName(String topiaId) {
        String className = "";
        int i = topiaId.indexOf(35);
        if (i > 0) {
            className = topiaId.substring(0, i);
        }
        try {
            Class<?> result = Class.forName(className);
            return result;
        }
        catch (ClassNotFoundException eee) {
            throw new TopiaNotFoundException("Can't find class for " + topiaId, eee);
        }
    }
}

