/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.util.UUID;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaIdFactory;

public class DefaultTopiaIdFactory
implements TopiaIdFactory {
    @Override
    public <E extends TopiaEntity> String newTopiaId(Class<E> entityClass, TopiaEntity topiaEntity) {
        if (!entityClass.isInterface()) {
            throw new IllegalArgumentException("Only interface is permit to create id: " + entityClass);
        }
        String result = entityClass.getName() + '_' + UUID.randomUUID().toString();
        return result;
    }

    @Override
    public <E extends TopiaEntity> Class<E> getClassName(String topiaId) {
        String className = (String)Iterables.get((Iterable)Splitter.on((char)'_').split((CharSequence)topiaId), (int)0);
        try {
            Class<?> entityClass = Class.forName(className);
            return entityClass;
        }
        catch (ClassNotFoundException e) {
            throw new TopiaException("can't find class for topiaId = '" + topiaId + "'", e);
        }
    }
}

