/*
 * #%L
 * ToPIA :: Persistence
 * $Id: TopiaEntity.java 3046 2014-04-03 17:43:45Z athimel $
 * $HeadURL: https://svn.nuiton.org/topia/tags/topia-2.9/topia-persistence/src/main/java/org/nuiton/topia/persistence/TopiaEntity.java $
 * %%
 * Copyright (C) 2004 - 2014 CodeLutin, Chemit Tony
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

/* *
 * TopiaEntity.java
 *
 * Created: 28 déc. 2005 22:48:10
 *
 * @author poussin <poussin@codelutin.com>
 * @version $Revision: 3046 $
 *
 * Last update: $Date: 2014-04-03 19:43:45 +0200 (Thu, 03 Apr 2014) $
 * by : $Author: athimel $
 */

package org.nuiton.topia.persistence;

import org.nuiton.topia.TopiaException;
import org.nuiton.topia.generator.EntityHibernateMappingGenerator;
import org.nuiton.topia.generator.EntityTransformer;
import org.nuiton.topia.generator.TopiaMetaTransformer;

import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * The TopiaEntity is the main interface for each entities generated with {@link
 * TopiaMetaTransformer}. An entity is simply a persistent bean mapped with
 * hibernate. The manipulation on entities (create, update, delete, find) is
 * made by the dao associated. The corresponding dao interface is {@link
 * TopiaDAO}.
 * <p/>
 * Setter methods have to be used only in internal. They are in the interface to
 * make easier their usages in internal.
 *
 * @author poussin <poussin@codelutin.com>
 * @author fdesbois <fdesbois@codelutin.com>
 * @version $Id: TopiaEntity.java 3046 2014-04-03 17:43:45Z athimel $
 * @see EntityHibernateMappingGenerator
 * @see EntityTransformer
 */
@SearchFields
public interface TopiaEntity extends Serializable {

    String TOPIA_ID = "topiaId";

    String TOPIA_CREATE_DATE = "topiaCreateDate";

    String TOPIA_VERSION = "topiaVersion";

    String COMPOSITE = "composite";
    
    String AGGREGATE = "aggregate";

    /**
     * Unique technical Id of the entity. This id contains the full qualified
     * name of the entity interface. This id has also an index and his used to
     * identify uniquely the entity in the database.
     *
     * @return the technical Id of the entity
     */
    String getTopiaId();

    /**
     * Set the technical {@code id} of the entity. Careful, use this method only
     * for copy. The technical id is generated by ToPIA when entity is created
     * using {@link TopiaDAO#create(Object...)}.
     *
     * @param id technical id to set
     */
    void setTopiaId(String id);

    /**
     * Technical property to keep versionning of the entity. The version is
     * incremented on each change of the entity.
     *
     * @return the current version of the entity
     */
    long getTopiaVersion();

    /**
     * Set the technical {@code version} of the entity. Careful, use this method
     * only for copy. The version is automatically incremented on entity
     * changes.
     *
     * @param version technical version to set
     */
    void setTopiaVersion(long version);

    /**
     * Technical date creation of the entity. This date doesn't change through
     * time and was initialized on entity creation when using {@link
     * TopiaDAO#create(Object...)}.
     *
     * @return the creation date of the entity
     */
    Date getTopiaCreateDate();

    /**
     * Set the technical creation {@code date} of the entity. Careful, use this
     * method only for copy. This date is immutable and was created on entity
     * creation.
     *
     * @param date technical create date to set
     */
    void setTopiaCreateDate(Date date);

    /**
     * @return all object that must be deleted if this object is deleted
     * @throws TopiaException if any pb
     */
    List<TopiaEntity> getComposite() throws TopiaException;

    /**
     * @return all object that are aggregate with this instance, aggreate object
     *         are not removed automaticaly
     * @throws TopiaException if any pb
     */
    List<TopiaEntity> getAggregate() throws TopiaException;

    /**
     * Add listener for property writing.
     *
     * @param propertyName name of property to listen
     * @param listener     the listener to register
     */
    void addPropertyChangeListener(String propertyName,
                                   PropertyChangeListener listener);

    /**
     * Add listener for property writing.
     *
     * @param listener the listener to register
     */
    void addPropertyChangeListener(PropertyChangeListener listener);

    void addVetoableChangeListener(String propertyName,
                                   VetoableChangeListener vetoable);

    void addVetoableChangeListener(VetoableChangeListener vetoable);

    void removePropertyChangeListener(String propertyName,
                                      PropertyChangeListener listener);

    void removePropertyChangeListener(PropertyChangeListener listener);

    void removeVetoableChangeListener(String propertyName,
                                      VetoableChangeListener vetoable);

    void removeVetoableChangeListener(VetoableChangeListener vetoable);

    /**
     * Add listener for property reading.
     *
     * @param propertyName the property name to listen
     * @param listener     the listener to register
     */
    void addPropertyListener(String propertyName,
                             PropertyChangeListener listener);

    /**
     * Add listener for property reading.
     *
     * @param listener the listener to register
     */
    void addPropertyListener(PropertyChangeListener listener);

    void addVetoableListener(String propertyName,
                             VetoableChangeListener vetoable);

    void addVetoableListener(VetoableChangeListener vetoable);

    void removePropertyListener(String propertyName,
                                PropertyChangeListener listener);

    void removePropertyListener(PropertyChangeListener listener);

    void removeVetoableListener(String propertyName,
                                VetoableChangeListener vetoable);

    void removeVetoableListener(VetoableChangeListener vetoable);

    /**
     * Route the entity using a {@code visitor}.
     *
     * @param visitor to used
     * @throws TopiaException for all type of error
     */
    void accept(EntityVisitor visitor) throws TopiaException;

} //TopiaEntity
