/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelJavaModifier;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.topia.generator.TopiaGeneratorUtil;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.util.beans.BinderFactory;
import org.nuiton.util.beans.BinderModelBuilder;

public class BinderHelperTransformer
extends ObjectModelTransformerToJava {
    private static final Log log = LogFactory.getLog(BinderHelperTransformer.class);

    public void transformFromModel(ObjectModel model) {
        List<ObjectModelClass> classes = TopiaGeneratorUtil.getEntityClasses(model, true);
        if (CollectionUtils.isEmpty(classes)) {
            log.warn((Object)("No entity to generate, " + ((Object)((Object)this)).getClass().getName() + " is skipped"));
            return;
        }
        String packageName = this.getDefaultPackageName();
        String modelName = model.getName();
        String binderHelperClazzName = modelName + "BinderHelper";
        String daoHelperClazzName = modelName + "DAOHelper";
        ObjectModelClass resultClass = this.createClass(binderHelperClazzName, packageName);
        this.setSuperClass(resultClass, BinderFactory.class);
        this.addImport((ObjectModelClassifier)resultClass, TopiaEntityBinder.class);
        this.addImport((ObjectModelClassifier)resultClass, TopiaEntityHelper.class);
        this.addImport((ObjectModelClassifier)resultClass, TopiaEntity.class);
        this.addImport((ObjectModelClassifier)resultClass, BinderModelBuilder.class);
        ObjectModelOperation op = this.addOperation((ObjectModelClassifier)resultClass, "getTopiaBinder", "<E extends TopiaEntity> TopiaEntityBinder<E>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC});
        this.addParameter(op, "Class<E>", "entityClass");
        this.addParameter(op, "String", "contextName");
        this.setOperationBody(op, "\n        return (TopiaEntityBinder<E>) newBinder(entityClass, entityClass, contextName, TopiaEntityBinder.class);\n    ");
        op = this.addOperation((ObjectModelClassifier)resultClass, "getSimpleTopiaBinder", "<E extends TopiaEntity> TopiaEntityBinder<E>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC});
        this.addParameter(op, "Class<E>", "entityClass");
        this.setOperationBody(op, "\n        return getTopiaBinder(entityClass, \"" + modelName + "\");\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)resultClass, "registerTopiaBinder", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC});
        this.addParameter(op, "BinderModelBuilder", "builder");
        this.addParameter(op, "String", "contextName");
        this.setOperationBody(op, "\n       registerBinderModel(builder, contextName);\n    ");
        op = this.addOperation((ObjectModelClassifier)resultClass, "registerTopiaBinder", "<E extends TopiaEntity> TopiaEntityBinder<E>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC});
        this.addParameter(op, "Class<E>", "entityClass");
        this.addParameter(op, "BinderModelBuilder", "builder");
        this.addParameter(op, "String", "contextName");
        this.setOperationBody(op, "\n       registerBinderModel(builder, contextName);\n       return getTopiaBinder(entityClass, contextName);\n    ");
        op = this.addOperation((ObjectModelClassifier)resultClass, "copy", "<E extends TopiaEntity> void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC});
        this.addParameter(op, "String", "contextName");
        this.addParameter(op, "E", "source");
        this.addParameter(op, "E", "target");
        this.addParameter(op, "boolean", "tech");
        this.setOperationBody(op, "\n        Class<E> entityClass = (Class<E>) TopiaEntityHelper.getContractClass(" + daoHelperClazzName + ".getContracts(), target.getClass());\n" + "        TopiaEntityBinder<E> binder = getTopiaBinder(entityClass, contextName);\n" + "        if (binder == null) {\n" + "            throw new NullPointerException(\"could not find a simple topia binder of type : \" + target.getClass());\n" + "        }\n" + "        binder.load(source, target, tech);\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)resultClass, "simpleCopy", "<E extends TopiaEntity> void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC});
        this.addParameter(op, "E", "source");
        this.addParameter(op, "E", "target");
        this.addParameter(op, "boolean", "tech");
        this.setOperationBody(op, "\n        Class<E> entityClass = (Class<E>) TopiaEntityHelper.getContractClass(" + daoHelperClazzName + ".getContracts(), target.getClass());\n" + "        TopiaEntityBinder<E> binder = getSimpleTopiaBinder(entityClass);\n" + "        if (binder == null) {\n" + "            throw new NullPointerException(\"could not find a simple topia binder of type : \" + target.getClass());\n" + "        }\n" + "        binder.load(source, target, tech);\n" + "    ");
        StringBuilder initCode = new StringBuilder();
        for (ObjectModelClass clazz : classes) {
            String prefix = this.getConstantPrefix((ObjectModelClassifier)clazz);
            if (StringUtils.isEmpty((CharSequence)prefix) && log.isWarnEnabled()) {
                log.warn((Object)("[" + clazz.getName() + "] Will generate constants with NO prefix, not a good idea..."));
            }
            this.setConstantPrefix(prefix);
            this.generateBinder(modelName, clazz, resultClass, initCode);
        }
        op = this.addOperation((ObjectModelClassifier)resultClass, "initBinders", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PROTECTED, ObjectModelJavaModifier.STATIC});
        this.setOperationBody(op, initCode.toString());
        op = this.addOperation((ObjectModelClassifier)resultClass, null, null, new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC});
        this.setOperationBody(op, "\n    initBinders();\n");
    }

    protected void generateBinder(String modelName, ObjectModelClass clazz, ObjectModelClass resultClass, StringBuilder initCode) {
        ArrayList<ObjectModelAttribute> list = new ArrayList<ObjectModelAttribute>();
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!attr.isNavigable() || GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) continue;
            list.add(attr);
        }
        String clazzName = clazz.getName();
        if (list.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("no attribute to add in a binder for " + clazzName + ", will not generate it."));
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("generate simple binder for " + clazzName));
        }
        this.addImport((ObjectModelClassifier)resultClass, clazz);
        initCode.append("\n        BinderModelBuilder<" + clazzName + ", " + clazzName + "> builder" + clazzName + " =\n" + "            BinderModelBuilder.newEmptyBuilder(" + clazzName + ".class);\n" + "        builder" + clazzName + ".addSimpleProperties(\n" + "");
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            ObjectModelAttribute attr = (ObjectModelAttribute)itr.next();
            String attrName = attr.getName();
            boolean hasNext = itr.hasNext();
            initCode.append("            " + clazzName + "." + this.getConstantName(attrName) + "" + (hasNext ? ",\n" : "") + "");
        }
        initCode.append("\n        );\n        registerTopiaBinder(builder" + clazzName + ", \"" + modelName + "\");\n" + "    ");
    }
}

