/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.util.Date;
import java.util.List;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class TopiaEntityAbstract
implements TopiaEntity {
    private static final long serialVersionUID = -7458577454878852241L;
    protected String topiaId;
    protected long topiaVersion;
    protected Date topiaCreateDate = new Date();
    protected transient TopiaContext topiaContext;
    protected transient VetoableChangeSupport readVetoables;
    protected transient PropertyChangeSupport readListeners;
    protected transient VetoableChangeSupport writeVetoables;
    protected transient PropertyChangeSupport writeListeners;

    protected VetoableChangeSupport getReadVetoableChangeSupport() {
        if (this.readVetoables == null) {
            this.readVetoables = new VetoableChangeSupport(this);
        }
        return this.readVetoables;
    }

    protected PropertyChangeSupport getReadPropertyChangeSupport() {
        if (this.readListeners == null) {
            this.readListeners = new PropertyChangeSupport(this);
        }
        return this.readListeners;
    }

    protected VetoableChangeSupport getWriteVetoableChangeSupport() {
        if (this.writeVetoables == null) {
            this.writeVetoables = new VetoableChangeSupport(this);
        }
        return this.writeVetoables;
    }

    protected PropertyChangeSupport getWritePropertyChangeSupport() {
        if (this.writeListeners == null) {
            this.writeListeners = new PropertyChangeSupport(this);
        }
        return this.writeListeners;
    }

    @Override
    public String getTopiaId() {
        return this.topiaId;
    }

    @Override
    public void setTopiaId(String v) {
        this.topiaId = v;
    }

    @Override
    public long getTopiaVersion() {
        return this.topiaVersion;
    }

    @Override
    public void setTopiaVersion(long v) {
        this.topiaVersion = v;
    }

    @Override
    public Date getTopiaCreateDate() {
        return this.topiaCreateDate;
    }

    @Override
    public void setTopiaCreateDate(Date topiaCreateDate) {
        this.topiaCreateDate = topiaCreateDate;
    }

    public TopiaContext getTopiaContext() {
        return this.topiaContext;
    }

    public void setTopiaContext(TopiaContext context) throws TopiaException {
        if (this.topiaContext != null) {
            throw new TopiaException("Remplacement du contexte interdit");
        }
        this.topiaContext = context;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        Date date = this.getTopiaCreateDate();
        int result = date == null ? 0 : date.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TopiaEntity)) {
            return false;
        }
        TopiaEntity other = (TopiaEntity)obj;
        if (this.getTopiaId() == null || other.getTopiaId() == null) {
            return false;
        }
        boolean result = this.getTopiaId().equals(other.getTopiaId());
        return result;
    }

    protected void fireOnPreRead(String propertyName, Object value) {
        TopiaContextImplementor contextImplementor = (TopiaContextImplementor)this.getTopiaContext();
        if (contextImplementor != null) {
            contextImplementor.getFiresSupport().fireOnPreRead(this.getReadVetoableChangeSupport(), this, propertyName, value);
        }
    }

    protected void fireOnPostRead(String propertyName, Object value) {
        TopiaContextImplementor contextImplementor = (TopiaContextImplementor)this.getTopiaContext();
        if (contextImplementor != null) {
            contextImplementor.getFiresSupport().fireOnPostRead(this.getReadPropertyChangeSupport(), this, propertyName, value);
        }
    }

    protected void fireOnPostRead(String propertyName, int index, Object value) {
        TopiaContextImplementor contextImplementor = (TopiaContextImplementor)this.getTopiaContext();
        if (contextImplementor != null) {
            contextImplementor.getFiresSupport().fireOnPostRead(this.getReadPropertyChangeSupport(), this, propertyName, index, value);
        }
    }

    protected void fireOnPreWrite(String propertyName, Object oldValue, Object newValue) {
        TopiaContextImplementor contextImplementor = (TopiaContextImplementor)this.getTopiaContext();
        if (contextImplementor != null) {
            contextImplementor.getFiresSupport().fireOnPreWrite(this.getWriteVetoableChangeSupport(), this, propertyName, oldValue, newValue);
        }
    }

    protected void fireOnPostWrite(String propertyName, Object oldValue, Object newValue) {
        TopiaContextImplementor contextImplementor = (TopiaContextImplementor)this.getTopiaContext();
        if (contextImplementor != null) {
            contextImplementor.getFiresSupport().fireOnPostWrite(this.getWritePropertyChangeSupport(), this, propertyName, oldValue, newValue);
        }
    }

    protected void fireOnPostWrite(String propertyName, int index, Object oldValue, Object newValue) {
        TopiaContextImplementor contextImplementor = (TopiaContextImplementor)this.getTopiaContext();
        if (contextImplementor != null) {
            contextImplementor.getFiresSupport().fireOnPostWrite(this.getWritePropertyChangeSupport(), this, propertyName, index, oldValue, newValue);
        }
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getWritePropertyChangeSupport().addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getWritePropertyChangeSupport().addPropertyChangeListener(listener);
    }

    @Override
    public void addVetoableChangeListener(String propertyName, VetoableChangeListener vetoable) {
        this.getWriteVetoableChangeSupport().addVetoableChangeListener(propertyName, vetoable);
    }

    @Override
    public void addVetoableChangeListener(VetoableChangeListener vetoable) {
        this.getWriteVetoableChangeSupport().addVetoableChangeListener(vetoable);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getWritePropertyChangeSupport().removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getWritePropertyChangeSupport().removePropertyChangeListener(listener);
    }

    @Override
    public void removeVetoableChangeListener(String propertyName, VetoableChangeListener vetoable) {
        this.getWriteVetoableChangeSupport().removeVetoableChangeListener(propertyName, vetoable);
    }

    @Override
    public void removeVetoableChangeListener(VetoableChangeListener vetoable) {
        this.getWriteVetoableChangeSupport().removeVetoableChangeListener(vetoable);
    }

    @Override
    public void addPropertyListener(String propertyName, PropertyChangeListener listener) {
        this.getReadPropertyChangeSupport().addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void addPropertyListener(PropertyChangeListener listener) {
        this.getReadPropertyChangeSupport().addPropertyChangeListener(listener);
    }

    @Override
    public void addVetoableListener(String propertyName, VetoableChangeListener vetoable) {
        this.getReadVetoableChangeSupport().addVetoableChangeListener(propertyName, vetoable);
    }

    @Override
    public void addVetoableListener(VetoableChangeListener vetoable) {
        this.getReadVetoableChangeSupport().addVetoableChangeListener(vetoable);
    }

    @Override
    public void removePropertyListener(String propertyName, PropertyChangeListener listener) {
        this.getReadPropertyChangeSupport().removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyListener(PropertyChangeListener listener) {
        this.getReadPropertyChangeSupport().removePropertyChangeListener(listener);
    }

    @Override
    public void removeVetoableListener(String propertyName, VetoableChangeListener vetoable) {
        this.getReadVetoableChangeSupport().removeVetoableChangeListener(propertyName, vetoable);
    }

    @Override
    public void removeVetoableListener(VetoableChangeListener vetoable) {
        this.getReadVetoableChangeSupport().removeVetoableChangeListener(vetoable);
    }
}

