/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence;

import java.util.List;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaDatabase;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaTestDAOHelper;
import org.nuiton.topiatest.Address;
import org.nuiton.topiatest.AddressDAO;
import org.nuiton.topiatest.Gender;
import org.nuiton.topiatest.Personne;
import org.nuiton.topiatest.PersonneDAO;

public class TopiaContextFindTest {
    @Rule
    public final TopiaDatabase db = new TopiaDatabase();
    protected TopiaContext context;
    protected AddressDAO addressDAO;
    protected PersonneDAO personneDAO;
    protected Address address;

    @Before
    public void createCompanies() throws TopiaException {
        this.context = this.db.beginTransaction();
        this.personneDAO = TopiaTestDAOHelper.getPersonneDAO(this.context);
        this.addressDAO = TopiaTestDAOHelper.getAddressDAO(this.context);
        this.address = (Address)this.addressDAO.create(new Object[]{"adress", "17 rue de la Pote Gell\u00e9e, 44200 NANTES"});
        this.personneDAO.create(new Object[]{"name", "Arnaud", "gender", Gender.MALE});
        this.personneDAO.create(new Object[]{"name", "Charlotte", "gender", Gender.FEMALE});
        this.personneDAO.create(new Object[]{"name", "Hortense", "gender", Gender.FEMALE});
        this.context.commitTransaction();
    }

    @Test
    public void testFindDAO() throws TopiaException {
        Assert.assertEquals((long)3L, (long)this.personneDAO.count());
        Assert.assertEquals((int)2, (int)this.personneDAO.findAllByGender(Gender.FEMALE).size());
        Assert.assertNotNull(this.personneDAO.findByGender(Gender.FEMALE));
        Assert.assertNotNull(this.personneDAO.findByGender(Gender.MALE));
        Assert.assertNull(this.personneDAO.findByGender(null));
        Assert.assertEquals((int)0, (int)this.personneDAO.findAllByName("nobody").size());
    }

    @Test
    public void testFindAll() throws TopiaException {
        Assert.assertEquals((long)3L, (long)this.personneDAO.count());
        String query = "from " + Personne.class.getName() + " where " + "gender" + "=:g";
        List females = this.context.findAll(query, new Object[]{"g", Gender.FEMALE});
        Assert.assertEquals((int)2, (int)females.size());
        List males = this.context.findAll(query, new Object[]{"g", Gender.MALE});
        Assert.assertEquals((int)1, (int)males.size());
        List all = this.context.findAll("from " + Personne.class.getName(), new Object[0]);
        Assert.assertEquals((int)3, (int)all.size());
        List none = this.context.findAll("from " + Personne.class.getName() + " where " + "name" + "=:pax", new Object[]{"pax", "nobody"});
        Assert.assertEquals((int)0, (int)none.size());
    }

    @Test
    public void testFind() throws TopiaException {
        Assert.assertEquals((long)3L, (long)this.personneDAO.count());
        String query = "from " + Personne.class.getName() + " where " + "gender" + "=:g";
        List females = this.context.find(query, 0, 100, new Object[]{"g", Gender.FEMALE});
        Assert.assertEquals((int)2, (int)females.size());
        females = this.context.find(query, 0, 0, new Object[]{"g", Gender.FEMALE});
        Assert.assertEquals((int)1, (int)females.size());
        Personne charlotte = (Personne)females.get(0);
        females = this.context.find(query, 1, 1, new Object[]{"g", Gender.FEMALE});
        Assert.assertEquals((int)1, (int)females.size());
        Personne hortense = (Personne)females.get(0);
        Assert.assertFalse((boolean)hortense.equals(charlotte));
    }

    @Test
    public void testFindUnique() throws TopiaException {
        Assert.assertEquals((long)3L, (long)this.personneDAO.count());
        String query = "from " + Personne.class.getName() + " where " + "gender" + "=:g";
        Object male = this.context.findUnique(query, new Object[]{"g", Gender.MALE});
        Assert.assertNotNull((Object)male);
        Object none = this.context.findUnique("from " + Personne.class.getName() + " where " + "name" + "=:pax", new Object[]{"pax", "nobody"});
        Assert.assertNull((Object)none);
    }

    @Test(expected=TopiaException.class)
    public void testFindUniqueOutOfBounds() throws TopiaException {
        Assert.assertEquals((long)3L, (long)this.personneDAO.count());
        String query = "from " + Personne.class.getName() + " where " + "gender" + "=:g";
        Object female = this.context.findUnique(query, new Object[]{"g", Gender.FEMALE});
        Assert.assertNotNull((Object)female);
    }
}

