package org.nuiton.topiatest.deletetest;

import java.util.Collection;
import org.nuiton.topia.persistence.TopiaEntity;


public interface Party2 extends TopiaEntity {     String PROPERTY_CONTACTS = "contacts";
    /**
     * addContacts :
     * @param contacts L'instance de org.nuiton.topiatest.deletetest.Contact2 à ajouter
     */

     void addContacts(Contact2 contacts);

    /**
     * addAllContacts :
     * @param contacts Les instances de org.nuiton.topiatest.deletetest.Contact2 à ajouter
     */

     void addAllContacts(Collection<Contact2> contacts);

    /**
     * setContacts :
     * @param contacts La valeur de l'attribut à positionner.
     */

     void setContacts(Collection<Contact2> contacts);

    /**
     * removeContacts :
     * @param contacts L'instance de org.nuiton.topiatest.deletetest.Contact2 à retirer
     */

     void removeContacts(Contact2 contacts);

    /**
     * clearContacts :
     */

     void clearContacts();

    /**
     * getContacts :
     * Retourne la collection.
     * @return Collection<Contact2> 
     */

     Collection<Contact2> getContacts();

    /**
     * getContactsByTopiaId :
     * Recupère l'attribut contacts à partir de son topiaId
     * @param topiaId le topia id de l'entité recherchée
     * @return Contact2 
     */

     Contact2 getContactsByTopiaId(String topiaId);

    /**
     * sizeContacts :
     * Retourne le nombre d'éléments de la collection contacts
     * @return int 
     */

     int sizeContacts();

    /**
     * isContactsEmpty :
     * Retourne {@code true} si la collection contacts est vide.
     * @return boolean 
     */

     boolean isContactsEmpty();


} //Party2
