/*
 * #%L
 * ToPIA :: Persistence
 * 
 * $Id: DAOHelperTransformer.java 1936 2010-05-07 16:34:39Z fdesbois $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.4/topia-persistence/src/main/java/org/nuiton/topia/generator/DAOHelperTransformer.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.topia.generator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.models.object.ObjectModelType;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.*;
import org.nuiton.eugene.models.object.xml.ObjectModelAttributeImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelEnumerationImpl;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.util.EntityOperator;
import org.nuiton.topia.persistence.util.EntityOperatorStore;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;






/**
 * Created: 13 nov. 2009 09:05:17
 *
 * @author tchemit <chemit@codelutin.com>
 * @version $Id: DAOHelperTransformer.java 1936 2010-05-07 16:34:39Z fdesbois $
 * @since 2.3.0
 * @plexus.component role="org.nuiton.eugene.Template" role-hint="org.nuiton.topia.generator.DAOHelperTransformer"
 */
public class DAOHelperTransformer extends ObjectModelTransformerToJava {

    private static final Log log = LogFactory.getLog(DAOHelperTransformer.class);

    @Override
    public void transformFromModel(ObjectModel model) {
        ObjectModelClass resultClass;
        String packageName = getOutputProperties().getProperty(PROP_DEFAULT_PACKAGE);
        String modelName = model.getName();
        String daoHelperClazzName = modelName + "DAOHelper";
        String modelVersion = model.getVersion();

        resultClass = createClass(daoHelperClazzName, packageName);

        List<ObjectModelClass> classes = TopiaGeneratorUtil.getEntityClasses(model, true);
        boolean generateOperator = TopiaGeneratorUtil.shouldgenerateOperatorForDAOHelper(null, model);

        addImport(resultClass, TopiaContextImplementor.class);
        addImport(resultClass, TopiaDAO.class);
        addImport(resultClass, TopiaEntity.class);
        addImport(resultClass, TopiaContext.class);
        addImport(resultClass, Array.class);
        addImport(resultClass, Arrays.class);

        if (generateOperator) {
            addImport(resultClass,EntityOperator.class);
            addImport(resultClass, EntityOperatorStore.class);
        }

        String entityEnumName = modelName+"EntityEnum";

        // add non public constructor
        ObjectModelOperation constructor = addConstructor(resultClass, ObjectModelModifier.PROTECTED);
        setOperationBody(constructor," ");

        ObjectModelOperation op;
        ObjectModelAttributeImpl attr;


        // getModelVersion method
        op = addOperation(resultClass, "getModelVersion", "String", ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC);
        setOperationBody(op, ""
    +"\n"
+"        return \""+modelVersion+"\";\n"
+"    "
            );

        // getModelName method
        op = addOperation(resultClass, "getModelName", "String", ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC);
        setOperationBody(op, ""
    +"\n"
+"        return \""+modelName+"\";\n"
+"    "
            );


        for (ObjectModelClass clazz : classes) {
            String clazzName = clazz.getName();
            String daoClazzName = clazzName + "DAO";

            // specialized getXXXDao method
            op = addOperation(resultClass, "get" + daoClazzName, clazz.getPackageName() + '.' + daoClazzName, ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC);
            addParameter(op, TopiaContext.class, "context");
            addImport(resultClass, clazz);
            addException(op, TopiaException.class);
            setOperationBody(op, ""
    +"\n"
+"        TopiaContextImplementor ci = (TopiaContextImplementor) context;\n"
+"        "+daoClazzName+" result = ("+daoClazzName+") ci.getDAO("+clazzName+".class);\n"
+"        return result;\n"
+"    "
            );

        }

        // generic getDao method
        op = addOperation(resultClass, "getDAO", "<T extends TopiaEntity, D extends TopiaDAO<? super T>> D", ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC);
        addParameter(op, TopiaContext.class, "context");
        addParameter(op, "Class<T>", "klass");
        addException(op, TopiaException.class);
        setOperationBody(op, ""
    +"\n"
+"        TopiaContextImplementor ci = (TopiaContextImplementor) context;\n"
+"        "+entityEnumName+" constant = "+entityEnumName+".valueOf(klass);\n"
+"        D dao = (D) ci.getDAO(constant.getContract());\n"
+"        return dao;\n"
+"    "
            );

        op = addOperation(resultClass, "getDAO", "<T extends TopiaEntity, D extends TopiaDAO<? super T>> D", ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC);
        addParameter(op, TopiaContext.class, "context");
        addParameter(op, "T", "entity");
        addException(op, TopiaException.class);
        setOperationBody(op, ""
    +"\n"
+"        TopiaContextImplementor ci = (TopiaContextImplementor) context;\n"
+"        "+entityEnumName+" constant = "+entityEnumName+".valueOf(entity);\n"
+"        D dao = (D) ci.getDAO(constant.getContract());\n"
+"        return dao;\n"
+"    "
            );

        // getContractClass method
        op = addOperation(resultClass, "getContractClass", "<T extends TopiaEntity> Class<T>", ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC);
        addParameter(op, "Class<T>", "klass");
        setOperationBody(op, ""
    +"\n"
+"        "+entityEnumName+" constant = "+entityEnumName+".valueOf(klass);\n"
+"        return (Class<T>) constant.getContract();\n"
+"    "
            );

        // getImplementationClass method
        op = addOperation(resultClass, "getImplementationClass", "<T extends TopiaEntity> Class<T>", ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC);
        addParameter(op, "Class<T>", "klass");
        setOperationBody(op, ""
    +"\n"
+"        "+entityEnumName+" constant = "+entityEnumName+".valueOf(klass);\n"
+"        return (Class<T>) constant.getImplementation();\n"
+"    "
            );

        // getContractClasses method
        op = addOperation(resultClass, "getContractClasses", "Class<? extends TopiaEntity>[]", ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC);
        setOperationBody(op, ""
    +"\n"
+"        "+entityEnumName+"[] values = "+entityEnumName+".values();\n"
+"        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);\n"
+"        for (int i = 0; i < values.length; i++) {\n"
+"            result[i] = values[i].getContract();\n"
+"        }\n"
+"        return result;\n"
+"    "
            );

        // getImplementationClasses method
        op = addOperation(resultClass, "getImplementationClasses", "Class<? extends TopiaEntity>[]", ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC);
        setOperationBody(op, ""
    +"\n"
+"        "+entityEnumName+"[] values = "+entityEnumName+".values();\n"
+"        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);\n"
+"        for (int i = 0; i < values.length; i++) {\n"
+"            result[i] = values[i].getImplementation();\n"
+"        }\n"
+"        return result;\n"
+"    "
            );

        // getImplementationClassesAsString method
        op = addOperation(resultClass, "getImplementationClassesAsString", "String", ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC);
        setOperationBody(op, ""
    +"\n"
+"        StringBuilder buffer = new StringBuilder();\n"
+"        for (Class<? extends TopiaEntity> aClass : getImplementationClasses()) {\n"
+"            buffer.append(',').append(aClass.getName());\n"
+"        }\n"
+"        return buffer.substring(1);\n"
+"    "
            );

        // getContracts method
        op = addOperation(resultClass, "getContracts", entityEnumName+"[]", ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC);
        setOperationBody(op, ""
    +"\n"
+"        return "+entityEnumName+".values();\n"
+"    "
            );

        if (generateOperator) {
            // getOperator method
            op = addOperation(resultClass, "getOperator", "<T extends TopiaEntity> EntityOperator<T>", ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC);
            addParameter(op,"Class<T>","klass");
            setOperationBody(op, ""
    +"\n"
+"        "+entityEnumName+" constant = "+entityEnumName+".valueOf(klass);\n"
+"        return (EntityOperator<T>) EntityOperatorStore.getOperator(constant);\n"
+"    "
            );
        }

        // add enum

        ObjectModelEnumerationImpl entityEnum = (ObjectModelEnumerationImpl) addInnerClassifier(resultClass, ObjectModelType.OBJECT_MODEL_ENUMERATION, entityEnumName);
        addImport(resultClass,TopiaEntityEnum.class);
        addInterface(entityEnum, TopiaEntityEnum.class);

        for (ObjectModelClass clazz : classes) {
            String clazzName = clazz.getName();
            addLiteral(entityEnum, clazzName + '(' + clazzName + ".class)");
        }
        attr = (ObjectModelAttributeImpl) addAttribute(entityEnum, "contract", "Class<? extends TopiaEntity>");
        attr.setDocumentation("the contract of the entity");

        attr = (ObjectModelAttributeImpl) addAttribute(entityEnum, "implementationFQN", "String");
        attr.setDocumentation("the fully qualified name of the implementation of the entity");

        attr = (ObjectModelAttributeImpl) addAttribute(entityEnum, "implementation", "Class<? extends TopiaEntity>");
        attr.setDocumentation("the implementation class of the entity (will be lazy computed at runtime)");

        // constructor
        op = addConstructor(entityEnum, ObjectModelModifier.PACKAGE);
        addParameter(op,"Class<? extends TopiaEntity >","contract");
        setOperationBody(op, ""
    +"\n"
+"        this.contract = contract;\n"
+"        this.implementationFQN = contract.getName()+\"Impl\";\n"
+"    "
        );

        // getContract method
        op = addOperation(entityEnum, "getContract","Class<? extends TopiaEntity>",ObjectModelModifier.PUBLIC);
        setOperationBody(op, ""
    +"\n"
+"        return contract;\n"
+"    "
        );

        // getImplementationFQN method
        op = addOperation(entityEnum, "getImplementationFQN","String",ObjectModelModifier.PUBLIC);
        setOperationBody(op, ""
    +"\n"
+"        return implementationFQN;\n"
+"    "
        );

        // setImplementationFQN method
        op = addOperation(entityEnum, "setImplementationFQN","void",ObjectModelModifier.PUBLIC);
        addParameter(op,"String","implementationFQN");
        if (generateOperator) {
               setOperationBody(op, ""
    +"\n"
+"        this.implementationFQN = implementationFQN;\n"
+"        this.implementation = null;\n"
+"        // on reinitialise le magasin d'operators\n"
+"       EntityOperatorStore.clear();\n"
+"    "
            );
        } else {
            setOperationBody(op, ""
    +"\n"
+"        this.implementationFQN = implementationFQN;\n"
+"        this.implementation = null;\n"
+"    "
            );
        }

        // accept method
        op = addOperation(entityEnum, "accept","boolean",ObjectModelModifier.PUBLIC);
        addParameter(op,"Class<? extends TopiaEntity>","klass");
        setOperationBody(op, ""
     +"\n"
+"         return "+daoHelperClazzName+".getContractClass(klass) == contract;\n"
+"     "
        );

        // getImplementation method
        op = addOperation(entityEnum, "getImplementation","Class<? extends TopiaEntity>",ObjectModelModifier.PUBLIC);
        setOperationBody(op, ""
     +"\n"
+"         if (implementation == null) {\n"
+"            try {\n"
+"                    implementation = (Class<? extends TopiaEntity>) Class.forName(implementationFQN);\n"
+"                } catch (ClassNotFoundException e) {\n"
+"                    throw new RuntimeException(\"could not find class \" + implementationFQN);\n"
+"                }\n"
+"         }\n"
+"         return implementation;\n"
+"     "
        );

        // valueOf method
        op = addOperation(entityEnum, "valueOf", entityEnumName, ObjectModelModifier.PUBLIC,ObjectModelModifier.STATIC);
        addParameter(op,"TopiaEntity","entity");
        setOperationBody(op, ""
     +"\n"
+"         return valueOf(entity.getClass());\n"
+"     "
        );

        // valueOf method
        op = addOperation(entityEnum, "valueOf", entityEnumName, ObjectModelModifier.PUBLIC,ObjectModelModifier.STATIC);
        addParameter(op,"Class<?>","klass");
        setOperationBody(op, ""
     +"\n"
+"         if (klass.isInterface()) {\n"
+"            return "+entityEnumName+".valueOf(klass.getSimpleName());\n"
+"         }\n"
+"         for ("+entityEnumName+" entityEnum : "+entityEnumName+".values()) {\n"
+"             if (entityEnum.getContract().isAssignableFrom(klass)) {\n"
+"                 //todo check it works for inheritance\n"
+"                 return entityEnum;\n"
+"             }\n"
+"         }\n"
+"         throw new IllegalArgumentException(\"no entity defined for the class \" + klass + \" in : \" + Arrays.toString("+entityEnumName+".values()));\n"
+"     "
        );
    }
}
