/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.framework.TopiaContextImpl;
import org.nuiton.topia.framework.TopiaUtil;

public class TopiaContextFactory {
    private static final Log log = LogFactory.getLog(TopiaContextFactory.class);
    private static final String DEFAULT_CONFIG_PROPERTIES = "TopiaContextImpl.properties";
    protected static Map<Properties, TopiaContextImpl> contextCache = new ReferenceMap(0, 1);

    public static List<String> getContextOpened() {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<Properties, TopiaContextImpl> e : contextCache.entrySet()) {
            result.add(e.getKey().getProperty("hibernate.connection.url"));
        }
        return result;
    }

    public static void removeContext(TopiaContext context) {
        Iterator<TopiaContextImpl> it = contextCache.values().iterator();
        boolean removed = false;
        while (it.hasNext() && !removed) {
            TopiaContextImpl curr = it.next();
            if (curr != context) continue;
            it.remove();
            removed = true;
        }
    }

    public static TopiaContext getContext() throws TopiaNotFoundException {
        Properties config = TopiaUtil.getProperties(DEFAULT_CONFIG_PROPERTIES);
        TopiaContext result = TopiaContextFactory.getContext(config);
        return result;
    }

    public static TopiaContext getContext(Properties config) throws TopiaNotFoundException {
        for (String key : config.stringPropertyNames()) {
            config.setProperty(key, config.getProperty(key));
        }
        TopiaContextImpl result = contextCache.get(config);
        if (result == null) {
            result = new TopiaContextImpl(config);
            if (log.isDebugEnabled()) {
                log.debug((Object)("instantiate new topiaContext : " + result));
            }
            contextCache.put((Properties)config.clone(), result);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("topiaContext found : " + result));
        }
        return result;
    }
}

