/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.test.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.topia.test.entities.Person;
import org.nuiton.topia.test.entities.Pet;

public abstract class PersonAbstract
extends TopiaEntityAbstract
implements Person {
    protected String name;
    protected String firstname;
    protected Collection<Pet> pet;

    @Override
    public String getName() {
        this.fireOnPreRead("name", this.name);
        String result = this.name;
        this.fireOnPostRead("name", this.name);
        return result;
    }

    @Override
    public String getFirstname() {
        this.fireOnPreRead("firstname", this.firstname);
        String result = this.firstname;
        this.fireOnPostRead("firstname", this.firstname);
        return result;
    }

    @Deprecated
    public void update() throws TopiaException {
        ((TopiaContextImplementor)this.getTopiaContext()).getDAO(Person.class).update((TopiaEntity)this);
    }

    @Deprecated
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)this.getTopiaContext()).getDAO(Person.class).delete((TopiaEntity)this);
    }

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start((TopiaEntity)this);
        visitor.visit((TopiaEntity)this, "name", String.class, (Object)this.name);
        visitor.visit((TopiaEntity)this, "firstname", String.class, (Object)this.firstname);
        visitor.visit((TopiaEntity)this, "pet", Collection.class, Pet.class, this.pet);
        visitor.end((TopiaEntity)this);
    }

    public List<TopiaEntity> getAggregate() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    public List<TopiaEntity> getComposite() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity == null) continue;
            result.add(entity);
            result.addAll(entity.getComposite());
        }
        return result;
    }

    @Override
    public void setName(String value) {
        String _oldValue = this.name;
        this.fireOnPreWrite("name", _oldValue, value);
        this.name = value;
        this.fireOnPostWrite("name", _oldValue, value);
    }

    @Override
    public void setFirstname(String value) {
        String _oldValue = this.firstname;
        this.fireOnPreWrite("firstname", _oldValue, value);
        this.firstname = value;
        this.fireOnPostWrite("firstname", _oldValue, value);
    }

    @Override
    public void addPet(Pet pet) {
        this.fireOnPreWrite("pet", null, pet);
        if (this.pet == null) {
            this.pet = new ArrayList<Pet>();
        }
        pet.setPerson(this);
        this.pet.add(pet);
        this.fireOnPostWrite("pet", this.pet.size(), null, pet);
    }

    @Override
    public void addAllPet(Collection<Pet> values) {
        if (values == null) {
            return;
        }
        for (Pet item : values) {
            this.addPet(item);
        }
    }

    @Override
    public Pet getPetByTopiaId(String topiaId) {
        return (Pet)TopiaEntityHelper.getEntityByTopiaId(this.pet, (String)topiaId);
    }

    @Override
    public void setPet(Collection<Pet> values) {
        Collection<Pet> _oldValue = this.pet;
        this.fireOnPreWrite("pet", _oldValue, values);
        this.pet = values;
        this.fireOnPostWrite("pet", _oldValue, values);
    }

    @Override
    public void removePet(Pet value) {
        this.fireOnPreWrite("pet", value, null);
        if (this.pet == null || !this.pet.remove(value)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setPerson(null);
        this.fireOnPostWrite("pet", this.pet.size() + 1, value, null);
    }

    @Override
    public void clearPet() {
        if (this.pet == null) {
            return;
        }
        for (Pet item : this.pet) {
            item.setPerson(null);
        }
        ArrayList<Pet> _oldValue = new ArrayList<Pet>(this.pet);
        this.fireOnPreWrite("pet", _oldValue, this.pet);
        this.pet.clear();
        this.fireOnPostWrite("pet", _oldValue, this.pet);
    }

    @Override
    public Collection<Pet> getPet() {
        return this.pet;
    }

    @Override
    public int sizePet() {
        if (this.pet == null) {
            return 0;
        }
        return this.pet.size();
    }

    @Override
    public boolean isPetEmpty() {
        int size = this.sizePet();
        return size == 0;
    }

    public String toString() {
        String result = new ToStringBuilder((Object)this).append("name", (Object)this.name).append("firstname", (Object)this.firstname).toString();
        return result;
    }

    static {
        I18n.n_((String)"topia.test.common.person");
        I18n.n_((String)"topia.test.common.name");
        I18n.n_((String)"topia.test.common.firstname");
        I18n.n_((String)"topia.test.common.pet");
    }
}

