package org.nuiton.topiatest;

import java.util.Collection;
import org.nuiton.topia.persistence.TopiaEntity;


public interface Company extends TopiaEntity {     String NAME = "name";
     String SIRET = "siret";
     String EMPLOYE = "employe";
     String STORE_BILL = "storeBill";
     String DEPARTMENT = "department";
    /**
     * setName :
     * @param name La valeur de l'attribut name à positionner.
     */

     void setName(String name);

    /**
     * getName :
     * @return String 
     */

     String getName();

    /**
     * setSiret :
     * @param siret La valeur de l'attribut siret à positionner.
     */

     void setSiret(int siret);

    /**
     * getSiret :
     * @return int 
     */

     int getSiret();

    /**
     * addEmploye :
     * @param employe L'instance de employe à ajouter
     */

     void addEmploye(Employe employe);

    /**
     * addAllEmploye :
     * @param employe Les instances de employe à ajouter
     */

     void addAllEmploye(Collection<Employe> employe);

    /**
     * setEmploye :
     * @param employe La Collection de employe à ajouter
     */

     void setEmploye(Collection<Employe> employe);

    /**
     * removeEmploye :
     * @param employe Vide la Collection de employe
     */

     void removeEmploye(Employe employe);

    /**
     * clearEmploye :
     */

     void clearEmploye();

    /**
     * getEmploye :
     * @return Collection<Employe> 
     */

     Collection<Employe> getEmploye();

    /**
     * getEmployeByTopiaId :
     * Recupère l'attribut employe à partir de son topiaId
     * @param topiaId le topia id de l'entité recherchée
     * @return Employe 
     */

     Employe getEmployeByTopiaId(String topiaId);

    /**
     * sizeEmploye :
     * Retourne le nombre d'éléments de la collection employe
     * @return int 
     */

     int sizeEmploye();

    /**
     * isEmployeEmpty :
     * Retourne {@code true} si la collection employe est vide.
     * @return boolean 
     */

     boolean isEmployeEmpty();

    /**
     * addStoreBill :
     * @param bill L'instance de Bill à ajouter
     */

     void addStoreBill(Bill bill);

    /**
     * addAllStoreBill :
     * @param bill Les instances de Bill à ajouter
     */

     void addAllStoreBill(Collection<Bill> bill);

    /**
     * setStoreBill :
     * @param bill La Collection de Bill à ajouter
     */

     void setStoreBill(Collection<Bill> bill);

    /**
     * removeStoreBill :
     * @param bill L'instance de Bill à retirer
     */

     void removeStoreBill(Bill bill);

    /**
     * clearStoreBill :
     * Vide la Collection de Bill .
     */

     void clearStoreBill();

    /**
     * getStoreBill :
     * @return Collection<Bill> 
     */

     Collection<Bill> getStoreBill();

    /**
     * getStoreBillByTopiaId :
     * Recupère l'attribut store à partir de son topiaId
     * @param topiaId le topia id de l'entité recherchée
     * @return Bill 
     */

     Bill getStoreBillByTopiaId(String topiaId);

    /**
     * getStoreBill :
     * @param value 
     * @return Bill 
     */

     Bill getStoreBill(Store value);

    /**
     * sizeStoreBill :
     * @return int 
     */

     int sizeStoreBill();

    /**
     * isStoreBillEmpty :
     * @return boolean 
     */

     boolean isStoreBillEmpty();

    /**
     * addDepartment :
     * @param department L'instance de department à ajouter
     */

     void addDepartment(Department department);

    /**
     * addAllDepartment :
     * @param department Les instances de department à ajouter
     */

     void addAllDepartment(Collection<Department> department);

    /**
     * setDepartment :
     * @param department La Collection de department à ajouter
     */

     void setDepartment(Collection<Department> department);

    /**
     * removeDepartment :
     * @param department Vide la Collection de department
     */

     void removeDepartment(Department department);

    /**
     * clearDepartment :
     */

     void clearDepartment();

    /**
     * getDepartment :
     * @return Collection<Department> 
     */

     Collection<Department> getDepartment();

    /**
     * getDepartmentByTopiaId :
     * Recupère l'attribut department à partir de son topiaId
     * @param topiaId le topia id de l'entité recherchée
     * @return Department 
     */

     Department getDepartmentByTopiaId(String topiaId);

    /**
     * sizeDepartment :
     * Retourne le nombre d'éléments de la collection department
     * @return int 
     */

     int sizeDepartment();

    /**
     * isDepartmentEmpty :
     * Retourne {@code true} si la collection department est vide.
     * @return boolean 
     */

     boolean isDepartmentEmpty();


} //Company
