/*
 * #%L
 * ToPIA :: Persistence
 * 
 * $Id: DTOTransformer.java 1936 2010-05-07 16:34:39Z fdesbois $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.3.4/topia-persistence/src/main/java/org/nuiton/topia/generator/DTOTransformer.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.topia.generator;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.*;
import static org.nuiton.topia.generator.TopiaGeneratorUtil.TAG_ANNOTATION;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;






/**
 * Created: 20 déc. 2009
 *
 * @author Tony Chemit <chemit@codelutin.com> Copyright Code Lutin
 * @version $Id: DTOTransformer.java 1936 2010-05-07 16:34:39Z fdesbois $
 * @since 2.3.0
 * @plexus.component role="org.nuiton.eugene.Template" role-hint="org.nuiton.topia.generator.DTOTransformer"
 */
public class DTOTransformer extends ObjectModelTransformerToJava {

    /**
     * Logger
     */
    private static final Log log = LogFactory.getLog(DTOTransformer.class);

    @Override
    public void transformFromClass(ObjectModelClass clazz) {
        if (!clazz.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_DTO)) {
            return;
        }
        String clazzName = clazz.getName();
        ObjectModelClass result;
        result = createClass(clazzName + "DTO", clazz.getPackageName());
        addImport(result, ToStringBuilder.class);
        addImport(result, PropertyChangeListener.class);

        setDocumentation(result, "Implantation DTO pour l'entité " + StringUtils.capitalize(clazzName) + ".");
        String extendClass = "";
        for (ObjectModelClass parent : clazz.getSuperclasses()) {
            extendClass = parent.getQualifiedName() + "DTO";
            // no multi-inheritance in java
            break;
        }
        if (extendClass.length() > 0) {
            setSuperClass(result, extendClass);
        }

        addInterface(result, Serializable.class);
        for (ObjectModelInterface parentInterface : clazz.getInterfaces()) {
            if (parentInterface.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_DTO)) {
                addInterface(result, parentInterface.getName() + "DTO");
            } else {
                addInterface(result, parentInterface.getName());
            }
        }

        addAttributes(result, clazz);

        addOperations(result, clazz);
    }

    protected void addAttributes(ObjectModelClass result, ObjectModelClass clazz) {

        String svUID = TopiaGeneratorUtil.findTagValue("dto-serialVersionUID", clazz, model);
        if (StringUtils.isNotEmpty(svUID)) {
            addAttribute(result, "serialVersionUID", long.class, svUID, ObjectModelModifier.FINAL, ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC);
        }

        addAttribute(result, "p", PropertyChangeSupport.class, null, ObjectModelModifier.PROTECTED);

/*
* Définition des attributs
*/
        ObjectModelAttribute attr2;
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            ObjectModelAttribute reverse = attr.getReverseAttribute();

            String attributeName;
            String attributeType;
            if (!(attr.isNavigable()
                    || attr.hasAssociationClass())) {
                continue;
            }

            String attrName = attr.getName();
            String attrVisibility = attr.getVisibility();
            String attrType = attr.getType();
            if (!GeneratorUtil.isNMultiplicity(attr)) {
                if (!attr.hasAssociationClass()) {
                    if (isDTO(attrType)) {
                        attrType += "DTO";
                    }
                    attributeType = attrType;
                    attributeName = attrName;
                } else {
                    String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                    attributeType = attr.getAssociationClass().getQualifiedName();
                    attributeName = GeneratorUtil.toLowerCaseFirstLetter(assocAttrName);
                }
            } else {
                if (!attr.hasAssociationClass()) {
                    String nMultType;
                    if (attr.isOrdered()) {
                        nMultType = List.class.getName() + "<";
                    } else {
                        nMultType = Collection.class.getName() + "<";
                    }
                    nMultType += attrType;
                    if (isDTO(attrType)) {
                        nMultType += "DTO";
                    }
                    nMultType += ">";

                    attributeType = nMultType;
                    attributeName = attrName;
                } else {
                    String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                    String assocClassFQN = attr.getAssociationClass().getQualifiedName();
                    String nMultType;
                    if (attr.isOrdered()) {
                        nMultType = List.class.getName() + "<";
                    } else {
                        nMultType = Collection.class.getName() + "<";
                    }
                    nMultType += assocClassFQN;
                    if (isDTO(attrType)) {
                        nMultType += "DTO";
                    }
                    nMultType += ">";
                    attributeType = nMultType;
                    attributeName = GeneratorUtil.toLowerCaseFirstLetter(assocAttrName);
                }
            }

            attr2 = addAttribute(result, attributeName, attributeType, null, ObjectModelModifier.PROTECTED);

            if (attr2 != null) {
                if (TopiaGeneratorUtil.hasDocumentation(attr)) {
                    setDocumentation(attr2, attr.getDocumentation());
                }
                String annotation = attr.getTagValue(TAG_ANNOTATION);
                if (StringUtils.isNotEmpty(annotation)) {
                    addAnnotation(result, attr2, annotation);
                }
            }
        } /* end for*/

        //Déclaration des attributs d'une classe d'associations
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass) clazz;
            for (ObjectModelAttribute attr : assoc.getParticipantsAttributes()) {
                if (attr != null) {
                    String attrName = attr.getName();
                    String attrVisibility = attr.getVisibility();
                    String attrType = attr.getType();
                    if (isDTO(attrType)) {
                        attrType += "DTO";
                    }
                    addAttribute(result, GeneratorUtil.toLowerCaseFirstLetter(attrName), attrType);
                }
            }
        }

    }

    protected void addOperations(ObjectModelClass result, ObjectModelClass clazz) {
        ObjectModelOperation op;
        op = addOperation(result, "addPropertyChangeListener", "void", ObjectModelModifier.PUBLIC);
        addParameter(op, PropertyChangeListener.class, "listener");
        setOperationBody(op, ""
+"\n"
+"        p.addPropertyChangeListener(listener);\n"
+"    "
        );

        op = addOperation(result, "addPropertyChangeListener", "void", ObjectModelModifier.PUBLIC);
        addParameter(op, String.class, "propertyName");
        addParameter(op, PropertyChangeListener.class, "listener");
        setOperationBody(op, ""
+"\n"
+"        p.addPropertyChangeListener(propertyName, listener);\n"
+"    "
        );

        op = addOperation(result, "removePropertyChangeListener", "void", ObjectModelModifier.PUBLIC);
        addParameter(op, PropertyChangeListener.class, "listener");
        setOperationBody(op, ""
+"\n"
+"        p.removePropertyChangeListener(listener);\n"
+"    "
        );

        op = addOperation(result, "removePropertyChangeListener", "void", ObjectModelModifier.PUBLIC);
        addParameter(op, String.class, "propertyName");
        addParameter(op, PropertyChangeListener.class, "listener");
        setOperationBody(op, ""
+"\n"
+"        p.removePropertyChangeListener(propertyName, listener);\n"
+"    "
        );
        /*
         * Définition des getteurs et setteurs
         */
        for (ObjectModelAttribute attr : clazz.getAttributes()) {

            ObjectModelAttribute reverse = attr.getReverseAttribute();

//            if (!(attr.isNavigable() || hasUnidirectionalRelationOnAbstractType(reverse, model))) {
            if (!attr.isNavigable()) {
                continue;
            }

            String attrName = attr.getName();
            String attrType = attr.getType();
            String attrTypeDTO = attr.getType();
            if (isDTO(attrType)) {
                attrTypeDTO += "DTO";
            }

            if (!GeneratorUtil.isNMultiplicity(attr)) {
                if (!attr.hasAssociationClass()) {
                    op = addOperation(result, "set" + StringUtils.capitalize(attrName), "void", ObjectModelModifier.PUBLIC);
                    addParameter(op, attrTypeDTO, "value");
                    setOperationBody(op, ""
+"\n"
+"        "+attrTypeDTO+" oldValue = this."+attrName+";\n"
+"        this."+attrName+" = value;\n"
+"        p.firePropertyChange(\""+attrName+"\", oldValue, value);\n"
+"    "
                    );

                    op = addOperation(result, "get" + StringUtils.capitalize(attrName), attrTypeDTO, ObjectModelModifier.PUBLIC);
                    setOperationBody(op, ""
+"\n"
+"        return "+attrName+";\n"
+"    "
                    );

                } else {
                    String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                    String assocClassFQN = attr.getAssociationClass().getQualifiedName();
                    if (log.isTraceEnabled()) {
                        log.trace("assocAttrName: " + assocAttrName);
                    }
                    op = addOperation(result, "set" + StringUtils.capitalize(assocAttrName), "void", ObjectModelModifier.PUBLIC);
                    addParameter(op, assocClassFQN + "DTO", "association");
                    setOperationBody(op, ""
+"\n"
+"        "+assocClassFQN+"DTO oldAssocation = this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+";\n"
+"        this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+" = association;\n"
+"        p.firePropertyChange(\""+attrName+"\", oldAssocation, assocation);\n"
+"    "
                    );

                    op = addOperation(result, "get" + StringUtils.capitalize(assocAttrName), assocClassFQN + "DTO", ObjectModelModifier.PUBLIC);
                    setOperationBody(op, ""
+"\n"
+"        return "+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+";\n"
+"    "
                    );
                }
            } else { //NMultiplicity
                if (!attr.hasAssociationClass()) { //Méthodes remplacées par des accesseurs sur les classes d'assoc

                    String nMultType;
                    if (attr.isOrdered()) {
                        nMultType = List.class.getName() + "<" + attrTypeDTO + ">";
                    } else {
                        nMultType = Collection.class.getName() + "<" + attrTypeDTO + ">";
                    }
                    op = addOperation(result, "set" + StringUtils.capitalize(attrName), "void", ObjectModelModifier.PUBLIC);
                    addParameter(op, nMultType, "values");
                    setOperationBody(op, ""
+"\n"
+"        "+nMultType+" oldValues = this."+attrName+";\n"
+"        this."+attrName+" = values;\n"
+"        p.firePropertyChange(\""+attrName+"\", oldValues, values);\n"
+"    "
                    );

                    op = addOperation(result, "addChild" + StringUtils.capitalize(attrName), attrTypeDTO, ObjectModelModifier.PUBLIC);
                    addParameter(op, attrTypeDTO, attrName);
                    StringBuilder buffercode = new StringBuilder();

                    buffercode.append(""
+"\n"
+"        this."+attrName+".add("+attrName+");\n"
+"    "
                    );

                    if (reverse != null && reverse.isNavigable()) {
                        String reverseAttrName = reverse.getName();
                        buffercode.append(""
+"        "+attrName+".set"+StringUtils.capitalize(reverseAttrName)+"(this);\n"
+"    "
                        );
                    }
                    buffercode.append(""
+"        return "+attrName+";\n"
+"    "
                    );
                    setOperationBody(op, buffercode.toString());

                    op = addOperation(result, "removeChild", "void");
                    addParameter(op, attrTypeDTO, attrName);

                    buffercode = new StringBuilder();
                    buffercode.append(""
+"\n"
+"        this."+attrName+".remove("+attrName+");\n"
+"    "
                    );

                    if (reverse != null && reverse.isNavigable()) {
                        String reverseAttrName = reverse.getName();
                        buffercode.append(""
+" 	"+attrName+".set"+StringUtils.capitalize(reverseAttrName)+"(null);\n"
+"    "
                        );
                    }
                    setOperationBody(op, buffercode.toString());

                } else {
                    String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                    String assocClassFQN = attr.getAssociationClass().getQualifiedName();
                    String nMultType;
                    if (attr.isOrdered()) {
                        nMultType = List.class.getName() + "<" + assocClassFQN + "DTO>";
                    } else {
                        nMultType = Collection.class.getName() + "<" + assocClassFQN + "DTO>";
                    }
                    if (log.isTraceEnabled()) {
                        log.trace("assocAttrName: " + assocAttrName);
                    }
                    op = addOperation(result, "set" + StringUtils.capitalize(assocAttrName), "void");
                    addParameter(op, nMultType, "values");
                    setOperationBody(op, ""
+"\n"
+"        "+nMultType+" oldValues = this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+";\n"
+"        this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+" = values;\n"
+"        p.firePropertyChange(\""+attrName+"\", oldValues, values);\n"
+"    "
                    );
                }
                if (!attr.hasAssociationClass()) {
                    String nMultType;
                    if (attr.isOrdered()) {
                        nMultType = List.class.getName() + "<" + attrTypeDTO + ">";
                    } else {
                        nMultType = Collection.class.getName() + "<" + attrTypeDTO + ">";
                    }
                    op = addOperation(result, "get" + StringUtils.capitalize(attrName), nMultType);
                    setOperationBody(op, ""
+"\n"
+"        return this."+attrName+";\n"
+"    "
                    );
                } else {
                    String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                    String assocClassFQN = attr.getAssociationClass().getQualifiedName();
                    String nMultType;
                    if (attr.isOrdered()) {
                        nMultType = List.class.getName() + "<" + assocClassFQN + "DTO>";
                    } else {
                        nMultType = Collection.class.getName() + "<" + assocClassFQN + "DTO>";
                    }
                    if (log.isTraceEnabled()) {
                        log.trace("assocAttrName: " + assocAttrName);
                    }
                    op = addOperation(result, "get" + StringUtils.capitalize(assocAttrName), nMultType);
                    setOperationBody(op, ""
+"\n"
+"        return this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+";\n"
+"    "
                    );
                }
            }
        }

        op = addOperation(result, "toString", String.class, ObjectModelModifier.PUBLIC);
        StringBuilder buffer = new StringBuilder();

        buffer.append(""
+"\n"
+"        String result = new ToStringBuilder(this).\n"
+""
        );

        for (Object o : clazz.getAttributes()) {
            ObjectModelAttribute attr = (ObjectModelAttribute) o;
            if (!(attr.isNavigable()
                    || attr.hasAssociationClass())) {
                continue;
            }
            //FIXME possibilité de boucles (non directes)
            ObjectModelClass attrEntity = null;
            if (model.hasClass(attr.getType())) {
                attrEntity = model.getClass(attr.getType());
            }
            boolean isDTO = attrEntity != null &&
                            attrEntity.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_ENTITY); //THIMEL : STEREOTYPE ENTITY ???
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if (isDTO && (reverse == null || !reverse.isNavigable()) && !attr.hasAssociationClass() || (!isDTO)) {
                String attrName = attr.getName();
                buffer.append(""
+"            append(\""+attrName+"\", this."+attrName+").\n"
+""
                );
            }
        }
        buffer.append(""
+"         toString();\n"
+"        return result;\n"
+"    "
        );
        setOperationBody(op, buffer.toString());
    }

    public boolean isDTO(String type) {
        ObjectModelClassifier clazz = model.getClassifier(type);
        return clazz != null && clazz.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_DTO);
    }


}

