/*
 * #%L
 * ToPIA :: Persistence
 * 
 * $Id: DAOHelperGenerator.java 1894 2010-04-15 15:44:51Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.3.3/topia-persistence/src/main/java/org/nuiton/topia/generator/DAOHelperGenerator.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */




/*******************************************************************************
 * DAOHelperGenerator.java
 * 
 * Created: 12 déc. 2005
 * 
 * @author Arnaud Thimel <thimel@codelutin.com>
 * 
 * @version $Revision: 1894 $
 * 
 * Mise a jour: $Date: 2010-04-15 17:44:51 +0200 (jeu., 15 avril 2010) $ par : $Author: tchemit $
 */

package org.nuiton.topia.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.models.object.ObjectModelGenerator;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClass;

/**
 * Ce generateur permet d'avoir une classe permettant de recuperer les DAO
 * sans cast.
 *
 * La classe générée contient aussi une énumération nommée <code>EntityEnum</code> qui permet
 * d'avoir facilement les types d'entités gérées par ce dao.
 *  
 * @author poussin
 * @deprecated since 2.3.0, prefer use the corresponding {@link org.nuiton.eugene.Transformer} :
 * {@link DAOHelperTransformer}.
 * @plexus.component role="org.nuiton.eugene.Template" role-hint="org.nuiton.topia.generator.DAOHelperGenerator"
 */
@Deprecated
public class DAOHelperGenerator extends ObjectModelGenerator {

    private Log log = LogFactory.getLog(DAOHelperGenerator.class);

    @Override
    public String getFilenameForModel(ObjectModel model) {
        
        String modelName = StringUtils.capitalize(model.getName());
        
        return (getProperty("defaultPackage") + ".").replace('.',
                File.separatorChar)
                + modelName + "DAOHelper.java";
    }

    @Override
    public void generateFromModel(Writer output, ObjectModel model)
            throws IOException {
        String copyright = TopiaGeneratorUtil.getCopyright(model);
        if (TopiaGeneratorUtil.notEmpty(copyright)) {
output.write(""+copyright+"\n");
output.write("");
        }
        String packageName = getProperty("defaultPackage");
output.write("package "+packageName+";\n");
output.write("\n");
output.write("");
        String modelName = StringUtils.capitalize(model.getName());
        String modelVersion = model.getVersion();
        String daoHelperClazzName = modelName+"DAOHelper";
        String entityEnumName = modelName+"EntityEnum";
        List<ObjectModelClass> classes = TopiaGeneratorUtil.getEntityClasses(model,true);
        boolean generateOperator = TopiaGeneratorUtil.shouldgenerateOperatorForDAOHelper(null, model);
        
        List<String> imports  = computeImports(generateOperator,packageName, classes);
        if (log.isDebugEnabled()) {
            log.debug("imports for class <" + daoHelperClazzName + ">");
        }
        for (String anImport : imports) {
            if (log.isDebugEnabled()) {
                log.debug("import " + anImport);
            }
output.write("import "+anImport+";\n");
output.write("");
        }
output.write("\n");
output.write("public class "+daoHelperClazzName+" {\n");
output.write("\n");
output.write("");
        
output.write("    /**\n");
output.write("     * no instance for this helper\n");
output.write("     */\n");
output.write("    protected "+daoHelperClazzName+"() {\n");
output.write("    }\n");
output.write("\n");
output.write("    /**\n");
output.write("     * Model version.\n");
output.write("     * \n");
output.write("     * @return model version\n");
output.write("     */\n");
output.write("    public static String getModelVersion() {\n");
output.write("        return \""+modelVersion+"\";\n");
output.write("    }\n");
output.write("");

        for (ObjectModelClass clazz : classes) {
        	String clazzName = clazz.getName();
                String daoClazzName = clazzName + "DAO";
output.write("\n");
output.write("    public static "+daoClazzName+" get"+daoClazzName+"(TopiaContext context) throws TopiaException {\n");
output.write("        TopiaContextImplementor ci = (TopiaContextImplementor) context;\n");
output.write("        "+daoClazzName+" result = ("+daoClazzName+") ci.getDAO("+clazzName+".class);\n");
output.write("        return result;\n");
output.write("    }\n");
output.write("");
        }
output.write("\n");
output.write("    @SuppressWarnings({\"unchecked\"})\n");
output.write("    public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, Class<T> klass) throws TopiaException {\n");
output.write("        TopiaContextImplementor ci = (TopiaContextImplementor) context;\n");
output.write("        "+entityEnumName+" constant = "+entityEnumName+".valueOf(klass);\n");
output.write("        D dao = (D) ci.getDAO(constant.getContract());\n");
output.write("        return dao;\n");
output.write("    }\n");
output.write("\n");
output.write("    @SuppressWarnings({\"unchecked\"})\n");
output.write("    public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, T entity) throws TopiaException {\n");
output.write("        TopiaContextImplementor ci = (TopiaContextImplementor) context;\n");
output.write("        "+entityEnumName+" constant = "+entityEnumName+".valueOf(entity);\n");
output.write("        D dao = (D) ci.getDAO(constant.getContract());\n");
output.write("        return dao;\n");
output.write("    }\n");
output.write("\n");
output.write("    @SuppressWarnings({\"unchecked\"})\n");
output.write("    public static <T extends TopiaEntity> Class<T> getContractClass(Class<T> klass) {\n");
output.write("        "+entityEnumName+" constant = "+entityEnumName+".valueOf(klass);\n");
output.write("        return (Class<T>) constant.getContract();\n");
output.write("    }\n");
output.write("\n");
output.write("    @SuppressWarnings({\"unchecked\"})\n");
output.write("    public static <T extends TopiaEntity> Class<T> getImplementationClass(Class<T> klass) {\n");
output.write("        "+entityEnumName+" constant = "+entityEnumName+".valueOf(klass);\n");
output.write("        return (Class<T>) constant.getImplementation();\n");
output.write("    }\n");
output.write("\n");
output.write("    @SuppressWarnings({\"unchecked\"})\n");
output.write("    public static Class<? extends TopiaEntity>[] getContractClasses() {\n");
output.write("        "+entityEnumName+"[] values = "+entityEnumName+".values();\n");
output.write("        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);\n");
output.write("        for (int i = 0; i < values.length; i++) {\n");
output.write("            result[i] = values[i].getContract();\n");
output.write("        }\n");
output.write("        return result;\n");
output.write("    }\n");
output.write("\n");
output.write("    @SuppressWarnings({\"unchecked\"})\n");
output.write("    public static Class<? extends TopiaEntity>[] getImplementationClasses() {\n");
output.write("        "+entityEnumName+"[] values = "+entityEnumName+".values();\n");
output.write("        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);\n");
output.write("        for (int i = 0; i < values.length; i++) {\n");
output.write("            result[i] = values[i].getImplementation();\n");
output.write("        }\n");
output.write("        return result;\n");
output.write("    }\n");
output.write("\n");
output.write("    public static String getImplementationClassesAsString() {\n");
output.write("        StringBuilder buffer = new StringBuilder();\n");
output.write("        for (Class<? extends TopiaEntity> aClass : getImplementationClasses()) {\n");
output.write("            buffer.append(',').append(aClass.getName());\n");
output.write("        }\n");
output.write("        return buffer.substring(1);\n");
output.write("    }\n");
output.write("\n");
output.write("    public static "+entityEnumName+"[] getContracts() {\n");
output.write("        return "+entityEnumName+".values();\n");
output.write("    }\n");
output.write("");
    if (generateOperator) {
output.write("\n");
output.write("    @SuppressWarnings({\"unchecked\"})\n");
output.write("    public static <T extends TopiaEntity> EntityOperator<T> getOperator(Class<T> klass) {\n");
output.write("        "+entityEnumName+" constant = "+entityEnumName+".valueOf(klass);\n");
output.write("        return (EntityOperator<T>) EntityOperatorStore.getOperator(constant);\n");
output.write("    }\n");
output.write("");
    }
output.write("\n");
output.write("    /*\n");
output.write("     * Enumeration of all types of entities managed by this helper.\n");
output.write("     */\n");
output.write("    public enum "+entityEnumName+" implements org.nuiton.topia.persistence.TopiaEntityEnum {\n");
output.write("");
        
        for (Iterator<ObjectModelClass> i=classes.iterator(); i.hasNext();) {
            ObjectModelClass clazz = i.next();
            String clazzName = clazz.getName();
output.write("\n");
output.write("        "+clazzName+"("+clazzName+".class)"+(i.hasNext() ? "," : ";")+"");
        }
output.write("\n");
output.write("\n");
output.write("        /** the contract of the entity */\n");
output.write("        private Class<? extends TopiaEntity> contract;\n");
output.write("\n");
output.write("        /** the fully qualified name of the implementation of the entity */\n");
output.write("        private String implementationFQN;\n");
output.write("\n");
output.write("        /** the implementation class of the entity (will be lazy computed at runtime)*/\n");
output.write("        private Class<? extends TopiaEntity> implementation;\n");
output.write("\n");
output.write("        "+entityEnumName+"(Class<? extends TopiaEntity > contract) {\n");
output.write("            this.contract = contract;\n");
output.write("            this.implementationFQN = contract.getName()+\"Impl\";\n");
output.write("        }\n");
output.write("\n");
output.write("        @Override\n");
output.write("        public Class<? extends TopiaEntity> getContract() {\n");
output.write("            return contract;\n");
output.write("        }\n");
output.write("       \n");
output.write("        @Deprecated\n");
output.write("        public Class<? extends TopiaEntity> getContractClass() {\n");
output.write("            return getContract();\n");
output.write("        }\n");
output.write("        \n");
output.write("        @Deprecated\n");
output.write("        public Class<? extends TopiaEntity> getImplementationClass() {\n");
output.write("            return getImplementation();\n");
output.write("        }\n");
output.write("\n");
output.write("        @Override\n");
output.write("        public String getImplementationFQN() {\n");
output.write("            return implementationFQN;\n");
output.write("        }\n");
output.write("\n");
output.write("        @Override\n");
output.write("        public synchronized void setImplementationFQN(String implementationFQN) {\n");
output.write("            this.implementationFQN = implementationFQN;\n");
output.write("            this.implementation = null;\n");
output.write("");
        if (generateOperator) {
output.write("            // on reinitialise le magasin d'operators\n");
output.write("            EntityOperatorStore.clear();\n");
output.write("");
        }
output.write("        }\n");
output.write("\n");
output.write("        @Override\n");
output.write("        public boolean accept(Class<? extends TopiaEntity> klass) {\n");
output.write("            return "+daoHelperClazzName+".getContractClass(klass) == contract;\n");
output.write("        }\n");
output.write(" \n");
output.write("        @Override\n");
output.write("        @SuppressWarnings({\"unchecked\"})\n");
output.write("        public Class<? extends TopiaEntity> getImplementation() {\n");
output.write("            if (implementation == null) {\n");
output.write("                try {\n");
output.write("                    implementation = (Class<? extends TopiaEntity>) Class.forName(implementationFQN);\n");
output.write("                } catch (ClassNotFoundException e) {\n");
output.write("                    throw new RuntimeException(\"could not find class \" + implementationFQN);\n");
output.write("                }\n");
output.write("            }\n");
output.write("            return implementation;\n");
output.write("        }\n");
output.write("\n");
output.write("        public static "+entityEnumName+" valueOf(TopiaEntity entity) {\n");
output.write("            return valueOf(entity.getClass());\n");
output.write("        }\n");
output.write("\n");
output.write("        public static "+entityEnumName+" valueOf(Class<?> klass) {\n");
output.write("            if (klass.isInterface()) {\n");
output.write("                return "+entityEnumName+".valueOf(klass.getSimpleName());\n");
output.write("            }\n");
output.write("            for ("+entityEnumName+" entityEnum : "+entityEnumName+".values()) {\n");
output.write("                if (entityEnum.getContract().isAssignableFrom(klass)) {\n");
output.write("                    //todo check it works for inheritance\n");
output.write("                    return entityEnum;\n");
output.write("                }\n");
output.write("            }\n");
output.write("            throw new IllegalArgumentException(\"no entity defined for the class \" + klass + \" in : \" + Arrays.toString("+entityEnumName+".values()));\n");
output.write("        }        \n");
output.write("    }\n");
output.write("");
        String entitiesList = "";
        if (classes.isEmpty()) {
output.write("\n");
output.write("    /**\n");
output.write("      * @eprecated (prefer use {@link #getImplementationClassesAsString()}\n");
output.write("      */ \n");
output.write("    public static final String entitiesList = \"\";\n");
output.write("");
        } else {
output.write("\n");
output.write("    /**\n");
output.write("     * use {@link #getImplementationClassesAsString()}\n");
output.write("     *\n");
output.write("     * @deprecated (will be removed soon).\n");
output.write("     */\n");
output.write("    public static final String entitiesList = \"\" +\n");
output.write("");

            for (Iterator<ObjectModelClass> i=classes.iterator(); i.hasNext();) {
                ObjectModelClass clazz = i.next();
                String doType = TopiaGeneratorUtil.getDOType(clazz, model);
                entitiesList += doType + (i.hasNext()?",":"");
output.write("        \""+doType+""+(i.hasNext()?",\" +":"\";")+"\n");
output.write("");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Full entities list : " + entitiesList);
        }
output.write("\n");
output.write("} //"+daoHelperClazzName+"\n");
output.write("");
    }

    protected List<String> computeImports(boolean generateOperator,String packageName, List<ObjectModelClass> classes) {
        java.util.Set<String> imports = new java.util.HashSet<String>(java.util.Arrays.asList(
                java.lang.reflect.Array.class.getName(),
                java.util.Arrays.class.getName(),
                org.nuiton.topia.TopiaContext.class.getName(),
                org.nuiton.topia.TopiaException.class.getName(),
                org.nuiton.topia.framework.TopiaContextImplementor.class.getName(),
                org.nuiton.topia.persistence.TopiaDAO.class.getName(),                
                org.nuiton.topia.persistence.TopiaEntity.class.getName()));
                if (generateOperator) {
                    imports.add(org.nuiton.topia.persistence.util.EntityOperator.class.getName());
                    imports.add(org.nuiton.topia.persistence.util.EntityOperatorStore.class.getName());

                }
        for (ObjectModelClass clazz : classes) {
            String clazzFQN = clazz.getQualifiedName();
            imports.add(clazzFQN);
            imports.add(clazzFQN + "DAO");
        }
        List<String> cleanImports  = TopiaGeneratorUtil.cleanImports(packageName, imports);
        java.util.Collections.sort(cleanImports);
        return cleanImports;
    }
} //DAOHelperGenerator
