/*
 * *##%
 * ToPIA :: Persistence
 * Copyright (C) 2004 - 2010 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%
 */
package org.nuiton.topia.persistence;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.PropertyValueException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaTestDAOHelper;
import org.nuiton.topiatest.NaturalizedEntity;
import org.nuiton.topiatest.NaturalizedEntityDAO;
import org.nuiton.topiatest.TestUtils;

/**
 * NaturalIdTest
 *
 * Created: 18 févr. 2010
 *
 * @author fdesbois
 * @version $Revision: 1823 $
 *
 * Mise a jour: $Date: 2010-03-06 16:34:23 +0100 (sam., 06 mars 2010) $
 * par : $Author$
 */
public class NaturalIdTest {

    private static final Log log = LogFactory.getLog(NaturalIdTest.class);

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testCreateSucessfull() throws Exception {
        log.info("Test naturalId : create succesfull");
        TopiaContext root = TestUtils.start("naturalIdTest/createSucessfull");
        TopiaContext transaction = root.beginTransaction();

        NaturalizedEntityDAO dao =
                TopiaTestDAOHelper.getNaturalizedEntityDAO(transaction);

        // No exception will be thrown with the two properties
        dao.create(NaturalizedEntity.NATURAL_ID_NOT_NULL, 5,
                   NaturalizedEntity.NATURAL_ID_NULL, "str");
        transaction.commitTransaction();

        // No exception will only the need property
        dao.create(NaturalizedEntity.NATURAL_ID_NOT_NULL, 3);
        transaction.commitTransaction();

        transaction.closeContext();        
        root.closeContext();
    }

    @Test
    public void testCreateFailed() throws Exception {
        log.info("Test naturalId : create failed");
        TopiaContext root = TestUtils.start("naturalIdTest/createFailed");
        TopiaContext transaction = root.beginTransaction();

        NaturalizedEntityDAO dao =
                TopiaTestDAOHelper.getNaturalizedEntityDAO(transaction);

        // Exception will be throw
        try {
            dao.create();
            transaction.commitTransaction();

            // Note : this is possible to create an empty entity if the type
            // is primitive like 'int' which have a default value of '0'
        } catch (PropertyValueException eee) {
            Assert.assertEquals("naturalIdNotNull", eee.getPropertyName());
        }
        
        transaction.closeContext();
        root.closeContext();
    }

    @Test
    public void testUpdateFailed() throws Exception {
        log.info("Test naturalId : update failed");
        TopiaContext root = TestUtils.start("naturalIdTest/updateFailed");

        TopiaContext transaction = root.beginTransaction();

        NaturalizedEntityDAO dao =
                TopiaTestDAOHelper.getNaturalizedEntityDAO(transaction);

        NaturalizedEntity entity = 
                dao.create(NaturalizedEntity.NATURAL_ID_NOT_NULL, 5,
                           NaturalizedEntity.NATURAL_ID_NULL, "str");
        transaction.commitTransaction();

        // Exception will be throw : not allowed to modify a naturalId property
        try {
            entity.setNaturalIdNotNull(8);
            transaction.commitTransaction();
        } catch(TopiaException eee) {
            Assert.assertEquals("org.hibernate.HibernateException",
                    eee.getCause().getClass().getName());
        } finally {
            transaction.closeContext();
            root.closeContext();
        }
    }

    @Test
    public void testFindByNaturalId() throws Exception {
        log.info("Test naturalId : findByNaturalId");
        TopiaContext root = TestUtils.start("naturalIdTest/findByNaturalId");
        TopiaContext transaction = root.beginTransaction();

        NaturalizedEntityDAO dao =
                TopiaTestDAOHelper.getNaturalizedEntityDAO(transaction);

        NaturalizedEntity entity =
                dao.create(NaturalizedEntity.NATURAL_ID_NOT_NULL, 5,
                           NaturalizedEntity.NATURAL_ID_NULL, "str");
        transaction.commitTransaction();

        NaturalizedEntity result = dao.findByNaturalId(5, "str");

        Assert.assertEquals(entity, result);
        
        transaction.closeContext();
        root.closeContext();
    }

    @Test
    public void testExistNaturalId() throws Exception {
        log.info("Test naturalId : existNaturalId");
        TopiaContext root = TestUtils.start("naturalIdTest/existNaturalId");
        TopiaContext transaction = root.beginTransaction();

        NaturalizedEntityDAO dao =
                TopiaTestDAOHelper.getNaturalizedEntityDAO(transaction);

        dao.create(NaturalizedEntity.NATURAL_ID_NOT_NULL, 5,
                   NaturalizedEntity.NATURAL_ID_NULL, "str");
        transaction.commitTransaction();

        boolean result = dao.existNaturalId(5, "str");

        Assert.assertTrue(result);

        // not find with only one correct property
        result = dao.existNaturalId(8, "str");

        Assert.assertFalse(result);
        
        transaction.closeContext();
        root.closeContext();
    }
}
