/* *##% 
 * ToPIA :: Persistence
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*/

/*******************************************************************************
 * ObjectModelToEntityGenerator.java
 *
 * Created: 3 juil. 2004
 *
 * @author Grégoire DESSARD <dessard@codelutin.com> Copyright Code Lutin, Grégoire
 * Dessard
 *
 * @version $Revision: 1732 $
 *
 * Mise a jour: $Date: 2009-12-20 17:29:38 +0100 (dim. 20 déc. 2009) $ par : $Author: tchemit $
 */

package org.nuiton.topia.generator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.AbstractGenerator;
import org.nuiton.eugene.models.object.ObjectModelGenerator;
import org.nuiton.eugene.Template;
import org.nuiton.eugene.Transformer;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.validator.AttributeNamesValidator;
import org.nuiton.eugene.models.object.validator.ClassNamesValidator;
import org.nuiton.eugene.models.object.validator.ObjectModelValidator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.nuiton.eugene.models.object.ObjectModelClass;

/**
 * Cette classe est un Generateur qui constitue le point d'entree dans ToPIA.
 * Il repercute la generation de code sur chacun des generateurs de ToPIA en se
 * positionnant en tant que parent de ces generateurs.
 * @plexus.component role="org.nuiton.eugene.Template" role-hint="org.nuiton.topia.generator.TopiaMetaGenerator"
 * @deprecated since 2.3.0, prefer use the corresponding {@link Transformer} : {@link TopiaMetaTransformer}.
 */
@Deprecated
public class TopiaMetaGenerator extends ObjectModelGenerator {

    protected static Log log = LogFactory.getLog(TopiaMetaGenerator.class);

    /**
     * la liste des generateurs par defaut a utiliser
     */
    protected static final List<Class<? extends ObjectModelGenerator>> DEFAULT_GENERATORS = Collections
            .unmodifiableList(Arrays.asList(
                    EntityInterfaceGenerator.class,
                    EntityAbstractGenerator.class,
                    EntityImplGenerator.class,
                    EntityHibernateMappingGenerator.class,
                    DAOGenerator.class,
                    DAOImplGenerator.class,
                    DAOAbstractGenerator.class,
                    DAOHelperGenerator.class
            ));

    protected boolean validateModel(ObjectModel model) {
        List<ObjectModelValidator> validators = new ArrayList<ObjectModelValidator>();

        AttributeNamesValidator attrValidator = new AttributeNamesValidator(
                model);
        attrValidator.addNameAndReason("next",
                "Le nom d'attribut \"next\" est incompatible avec HSQL");
        attrValidator.addNameAndReason("value",
                        "Le nom d'attribut \"value\" est incompatible avec certains SGBD");
        attrValidator.addNameAndReason("values",
                        "Le nom d'attribut \"values\" est incompatible avec certains SGBD");
        attrValidator.addNameAndReason("begin",
                        "Le nom d'attribut \"begin\" est incompatible avec certains SGBD");
        attrValidator.addNameAndReason("end",
                        "Le nom d'attribut \"end\" est incompatible avec certains SGBD");
        attrValidator.addNameAndReason("authorization",
                        "Le nom d'attribut \"authorization\" est incompatible avec certains SGBD");
        attrValidator.addNameAndReason("order",
                        "Le nom d'attribut \"order\" est incompatible avec certains SGBD");
        validators.add(attrValidator);

        ClassNamesValidator classValidator = new ClassNamesValidator(model);
        classValidator.addNameAndReason("constraint", "Nom de classe incompatible avec certains SGBD");
        classValidator.addNameAndReason("user", "Nom de classe incompatible avec certains SGBD");
        validators.add(classValidator);

        validators.add(new TopiaJavaValidator(model));
        validators.add(new TopiaRelationValidator(model));

        boolean isValid = true;
        for (ObjectModelValidator validator : validators) {
            if (!validator.validate()) {
                for (String error : validator.getErrors()) {
                    log.info("[VALIDATION] " + error);
                }
                isValid = false;
            }
        }
        return isValid;
    }

    @Override
    public void applyTemplate(ObjectModel model, File destDir) throws IOException {

        //On n'empeche pas la génération si le modèle n'est pas valide
        validateModel(model);

        // test before all if there is some entities to generate
        List<ObjectModelClass> classes = TopiaGeneratorUtil.getEntityClasses(model, true);

        if (classes.isEmpty()) {
            // no entity to generate, can stop safely
            log.warn("no entity to generate, " + getClass().getName() + " is skipped");
            return;
        }

        generatePersistence(model, destDir);
    }

    public void generatePersistence(ObjectModel model, File destDir)
            throws IOException {
        for (Class<? extends Template<ObjectModel>> generatorClass : DEFAULT_GENERATORS) {
            Template<ObjectModel> generator;
            if (getExcludeTemplates().contains(generatorClass.getName())) {
                // exclude generator
                log.info("exclude generator " + generatorClass);
                continue;
            }
            try {

                generator = generatorClass.newInstance();

                // init generator

                if (generator instanceof AbstractGenerator) {
                    ((AbstractGenerator<ObjectModel>)generator).setParent(this);
                }
                if (generator instanceof Transformer) {
                    generator.setProperties(properties);
                }
            } catch (Exception e) {
                // should never happens
                if(log.isErrorEnabled()) {
                    log.error("An error occurs when generating persistence", e);
                }
                throw new RuntimeException(e);
            }

            // log
            if(log.isDebugEnabled()) {
                log.debug("call template : " + generatorClass.getSimpleName());
            }
            generator.applyTemplate(model, destDir);
        }
    }

} //TopiaMetaGenerator
