/* *##% ToPIA - Persistence
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*/

/* *
 * TopiaEntity.java
 *
 * Created: 28 déc. 2005 22:48:10
 *
 * @author poussin
 * @version $Revision: 1558 $
 *
 * Last update: $Date: 2009-06-11 06:53:44 +0200 (jeu., 11 juin 2009) $
 * by : $Author: tchemit $
 */

package org.nuiton.topia.persistence;

import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.util.Date;
import java.util.List;

import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

/**
 * TopiaEntity.
 * 
 * Toutes les methodes set ne doivent être utilisé que par le framework. Elle
 * sont publique car on ne peut pas faire autrement sur une interface.
 * 
 * @author poussin
 */
@SearchFields
public interface TopiaEntity {

    public String getTopiaId();

    public void setTopiaId(String v);

    public long getTopiaVersion();

    public void setTopiaVersion(long v);

    /**
     * @return Returns the topiaCreateTime.
     */
    public Date getTopiaCreateDate();

    /**
     * @param topiaCreatedate the topiaCreateTime to set.
     */
    public void setTopiaCreateDate(Date topiaCreatedate);

    public TopiaContext getTopiaContext();

    /**
     * called just after object creation and initialisation
     * each entity impl can overide it to do something after creation
     * @throws TopiaException
     */
    public void postCreate() throws TopiaException;

    public void update() throws TopiaException;

    public void delete() throws TopiaException;

    /**
     * @return all object that must be deleted if this object is deleted
     * @throws TopiaException
     */
    public List<TopiaEntity> getComposite() throws TopiaException;

    /**
     * @return all object that are aggregate with this instance, aggreate object
     * are not removed automaticaly
     * @throws TopiaException
     */
    public List<TopiaEntity> getAggregate() throws TopiaException;

    /**
     * Add listener for property writing.
     * 
     * @param propertyName
     * @param listener
     */
    public void addPropertyChangeListener(String propertyName,
            PropertyChangeListener listener);

    /**
     * Add listener for property writing.
     * 
     * @param listener
     */
    public void addPropertyChangeListener(PropertyChangeListener listener);

    public void addVetoableChangeListener(String propertyName,
            VetoableChangeListener vetoable);

    public void addVetoableChangeListener(VetoableChangeListener vetoable);

    public void removePropertyChangeListener(String propertyName,
            PropertyChangeListener listener);

    public void removePropertyChangeListener(PropertyChangeListener listener);

    public void removeVetoableChangeListener(String propertyName,
            VetoableChangeListener vetoable);

    public void removeVetoableChangeListener(VetoableChangeListener vetoable);

    /**
     * Add listener for property reading.
     * 
     * @param propertyName
     * @param listener
     */
    public void addPropertyListener(String propertyName,
            PropertyChangeListener listener);

    /**
     * Add listener for property reading.
     * 
     * @param listener
     */
    public void addPropertyListener(PropertyChangeListener listener);

    public void addVetoableListener(String propertyName,
            VetoableChangeListener vetoable);

    public void addVetoableListener(VetoableChangeListener vetoable);

    public void removePropertyListener(String propertyName,
            PropertyChangeListener listener);

    public void removePropertyListener(PropertyChangeListener listener);

    public void removeVetoableListener(String propertyName,
            VetoableChangeListener vetoable);

    public void removeVetoableListener(VetoableChangeListener vetoable);

    /**
     * Parcourt de l'entité via un visiteur.
     * 
     * @param visitor visitor le visiteur utilise
     * @throws TopiaException pour toute erreur pendant le parcours
     */
    public void accept(EntityVisitor visitor) throws TopiaException;
    
} //TopiaEntity
