package org.nuiton.topiatest.beangen;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import org.nuiton.topiatest.Personne;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

@Generated(value = "org.nuiton.eugene.java.BeanTransformer", date = "Mon Jan 27 12:06:11 CET 2020")
public abstract class GeneratedVoitureHelper {

    protected static final Function<Voiture, Integer> IMMATRICULATION_FUNCTION = newImmatriculationFunction();

    protected static final Function<Voiture, String> MODELE_FUNCTION = newModeleFunction();

    protected static final Function<Voiture, Personne> PROPRIETAIRE_FUNCTION = newProprietaireFunction();

    public static <BeanType extends Voiture> Class<BeanType> typeOfVoiture() {
        return (Class<BeanType>) Voiture.class;
    }

    public static <BeanType extends Voiture> void copyVoiture(BeanType source, BeanType target) {
        Class<BeanType> sourceType = typeOfVoiture();
        Binder<BeanType, BeanType> binder = BinderFactory.newBinder(sourceType);
        binder.copy(source, target);
    }

    public static <BeanType extends Voiture> void copyVoiture(BeanType source, BeanType target, Binder<BeanType, BeanType> binder) {
        binder.copy(source, target);
    }

    public static <BeanType extends Voiture> Predicate<BeanType> newImmatriculationPredicate(int immatriculation) {
        final int $tmp = immatriculation;
        return new Predicate<BeanType>() {

            @Override
            public boolean apply(BeanType input) {
                return Objects.equal($tmp, input.getImmatriculation());
            }
        };

    }

    public static <BeanType extends Voiture> List<BeanType> filterByImmatriculation(Collection<BeanType> $source, int immatriculation) {
        return Lists.newArrayList(Iterables.filter($source, newImmatriculationPredicate(immatriculation)));
    }

    public static <BeanType extends Voiture> Predicate<BeanType> newModelePredicate(String modele) {
        final String $tmp = modele;
        return new Predicate<BeanType>() {

            @Override
            public boolean apply(BeanType input) {
                return Objects.equal($tmp, input.getModele());
            }
        };

    }

    public static <BeanType extends Voiture> List<BeanType> filterByModele(Collection<BeanType> $source, String modele) {
        return Lists.newArrayList(Iterables.filter($source, newModelePredicate(modele)));
    }

    public static <BeanType extends Voiture> Predicate<BeanType> newProprietairePredicate(Personne proprietaire) {
        final Personne $tmp = proprietaire;
        return new Predicate<BeanType>() {

            @Override
            public boolean apply(BeanType input) {
                return Objects.equal($tmp, input.getProprietaire());
            }
        };

    }

    public static <BeanType extends Voiture> List<BeanType> filterByProprietaire(Collection<BeanType> $source, Personne proprietaire) {
        return Lists.newArrayList(Iterables.filter($source, newProprietairePredicate(proprietaire)));
    }

    public static <BeanType extends Voiture> Function<BeanType, Integer> getImmatriculationFunction() {
        return (Function<BeanType, Integer>) IMMATRICULATION_FUNCTION;

    }

    public static <BeanType extends Voiture> Function<BeanType, Integer> newImmatriculationFunction() {
    return new Function<BeanType, Integer>() {

        @Override
        public Integer apply(BeanType input) {
            return input.getImmatriculation();
        }
    };

}

    public static <BeanType extends Voiture> ImmutableMap<Integer, BeanType> uniqueIndexByImmatriculation(Iterable<BeanType> $source) {
        return Maps.uniqueIndex($source, IMMATRICULATION_FUNCTION);
    }

    public static <BeanType extends Voiture> Function<BeanType, String> getModeleFunction() {
        return (Function<BeanType, String>) MODELE_FUNCTION;

    }

    public static <BeanType extends Voiture> Function<BeanType, String> newModeleFunction() {
    return new Function<BeanType, String>() {

        @Override
        public String apply(BeanType input) {
            return input.getModele();
        }
    };

}

    public static <BeanType extends Voiture> ImmutableMap<String, BeanType> uniqueIndexByModele(Iterable<BeanType> $source) {
        return Maps.uniqueIndex($source, MODELE_FUNCTION);
    }

    public static <BeanType extends Voiture> Function<BeanType, Personne> getProprietaireFunction() {
        return (Function<BeanType, Personne>) PROPRIETAIRE_FUNCTION;

    }

    public static <BeanType extends Voiture> Function<BeanType, Personne> newProprietaireFunction() {
    return new Function<BeanType, Personne>() {

        @Override
        public Personne apply(BeanType input) {
            return input.getProprietaire();
        }
    };

}

    public static <BeanType extends Voiture> ImmutableMap<Personne, BeanType> uniqueIndexByProprietaire(Iterable<BeanType> $source) {
        return Maps.uniqueIndex($source, PROPRIETAIRE_FUNCTION);
    }

} //GeneratedVoitureHelper
