/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.io.File;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import org.fife.ui.rsyntaxtextarea.CodeTemplateManager;
import org.fife.ui.rsyntaxtextarea.DefaultToken;
import org.fife.ui.rsyntaxtextarea.MarkOccurrencesSupport;
import org.fife.ui.rsyntaxtextarea.Parser;
import org.fife.ui.rsyntaxtextarea.ParserManager;
import org.fife.ui.rsyntaxtextarea.ParserNotice;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaHighlighter;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaUI;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.RtfGenerator;
import org.fife.ui.rsyntaxtextarea.RtfTransferable;
import org.fife.ui.rsyntaxtextarea.SquiggleUnderlineHighlightPainter;
import org.fife.ui.rsyntaxtextarea.Style;
import org.fife.ui.rsyntaxtextarea.SyntaxConstants;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rsyntaxtextarea.SyntaxView;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaBase;
import org.fife.ui.rtextarea.RTextAreaUI;

public class RSyntaxTextArea
extends RTextArea
implements SyntaxConstants {
    public static final String ANTIALIAS_PROPERTY = "RSTA.antiAlias";
    public static final String AUTO_INDENT_PROPERTY = "RSTA.autoIndent";
    public static final String BRACKET_MATCHING_PROPERTY = "RSTA.bracketMatching";
    public static final String CLEAR_WHITESPACE_LINES_PROPERTY = "RSTA.clearWhitespaceLines";
    public static final String FRACTIONAL_FONTMETRICS_PROPERTY = "RSTA.fractionalFontMetrics";
    public static final String HYPERLINKS_ENABLED_PROPERTY = "RSTA.hyperlinksEnabled";
    public static final String SYNTAX_SCHEME_PROPERTY = "RSTA.syntaxScheme";
    public static final String SYNTAX_STYLE_PROPERTY = "RSTA.syntaxStyle";
    public static final String VISIBLE_WHITESPACE_PROPERTY = "RSTA.visibleWhitespace";
    private static final Color DEFAULT_BRACKET_MATCH_BG_COLOR = new Color(234, 234, 255);
    private static final Color DEFAULT_BRACKET_MATCH_BORDER_COLOR = new Color(0, 0, 128);
    private static final Color DEFAULT_SELECTION_COLOR = new Color(200, 200, 255);
    private String syntaxStyleKey;
    private SyntaxScheme syntaxScheme;
    private static CodeTemplateManager codeTemplateManager;
    private static boolean templatesEnabled;
    Rectangle match;
    private Color matchedBracketBGColor;
    private Color matchedBracketBorderColor;
    private boolean bracketMatchingEnabled;
    private boolean autoIndentEnabled;
    private boolean clearWhitespaceLines;
    private boolean whitespaceVisible;
    private boolean hyperlinksEnabled;
    private Color hyperlinkFG;
    private int linkScanningMask;
    private RtfGenerator rtfGenerator;
    private MarkOccurrencesSupport markOccurrencesSupport;
    private Color markOccurrencesColor;
    private FontMetrics defaultFontMetrics;
    private ParserManager parserManager;
    private List parserNoticeHighlights;
    private boolean isScanningForLinks;
    private int hoveredOverLinkOffset;
    private SquiggleUnderlineHighlightPainter parserErrorHighlightPainter = new SquiggleUnderlineHighlightPainter(Color.RED);
    private int lineHeight;
    private int maxAscent;
    private String aaHintFieldName;
    private Object aaHint;
    private boolean fractionalFontMetricsEnabled;

    public int getMaxAscent() {
        return this.maxAscent;
    }

    public RSyntaxTextArea() {
        this.init();
    }

    public RSyntaxTextArea(RSyntaxDocument rSyntaxDocument) {
        super(rSyntaxDocument);
        this.init();
    }

    public RSyntaxTextArea(String string) {
        super(string);
        this.init();
    }

    public RSyntaxTextArea(int n, int n2) {
        super(n, n2);
        this.init();
    }

    public RSyntaxTextArea(String string, int n, int n2) {
        super(string, n, n2);
        this.init();
    }

    public RSyntaxTextArea(RSyntaxDocument rSyntaxDocument, String string, int n, int n2) {
        super(rSyntaxDocument, string, n, n2);
        this.init();
    }

    public RSyntaxTextArea(int n) {
        super(n);
        this.init();
    }

    public void addHyperlinkListener(HyperlinkListener hyperlinkListener) {
        this.listenerList.add(HyperlinkListener.class, hyperlinkListener);
    }

    public void addNotify() {
        super.addNotify();
        this.refreshFontMetrics(this.getGraphics2D(this.getGraphics()));
    }

    private void calculateLineHeight() {
        int n;
        Object object;
        this.maxAscent = 0;
        this.lineHeight = 0;
        for (int i = 0; i < this.syntaxScheme.styles.length; ++i) {
            int n2;
            object = this.syntaxScheme.styles[i];
            if (object == null || ((Style)object).font == null) continue;
            FontMetrics fontMetrics = this.getFontMetrics(((Style)object).font);
            n = fontMetrics.getHeight();
            if (n > this.lineHeight) {
                this.lineHeight = n;
            }
            if ((n2 = fontMetrics.getMaxAscent()) <= this.maxAscent) continue;
            this.maxAscent = n2;
        }
        Font font = this.getFont();
        object = this.getFontMetrics(font);
        int n3 = ((FontMetrics)object).getHeight();
        if (n3 > this.lineHeight) {
            this.lineHeight = n3;
        }
        if ((n = ((FontMetrics)object).getMaxAscent()) > this.maxAscent) {
            this.maxAscent = n;
        }
    }

    protected void clearParserNoticeHighlights() {
        Highlighter highlighter = this.getHighlighter();
        if (highlighter != null && this.parserNoticeHighlights != null) {
            int n = this.parserNoticeHighlights.size();
            for (int i = 0; i < n; ++i) {
                highlighter.removeHighlight(this.parserNoticeHighlights.get(i));
            }
            this.parserNoticeHighlights.clear();
        }
        this.repaint();
    }

    private Token cloneTokenList(Token token) {
        if (token == null) {
            return null;
        }
        DefaultToken defaultToken = new DefaultToken();
        defaultToken.copyFrom(token);
        DefaultToken defaultToken2 = defaultToken;
        while ((token = token.getNextToken()) != null) {
            DefaultToken defaultToken3 = new DefaultToken();
            defaultToken3.copyFrom(token);
            defaultToken2.setNextToken(defaultToken3);
            defaultToken2 = defaultToken3;
        }
        return defaultToken;
    }

    public void copyAsRtf() {
        Object object;
        int n;
        int n2 = this.getSelectionStart();
        if (n2 == (n = this.getSelectionEnd())) {
            return;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkSystemClipboardAccess();
            }
            catch (SecurityException securityException) {
                UIManager.getLookAndFeel().provideErrorFeedback(null);
                return;
            }
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        RtfGenerator rtfGenerator = this.getRTFGenerator();
        Token token = this.getTokenListFor(n2, n);
        for (object = token; object != null; object = ((Token)object).getNextToken()) {
            if (!((Token)object).isPaintable()) continue;
            if (((Token)object).textCount == 1 && ((Token)object).text[((Token)object).textOffset] == '\n') {
                rtfGenerator.appendNewline();
                continue;
            }
            Font font = this.getFontForTokenType(((Token)object).type);
            Color color = this.getBackgroundForTokenType(((Token)object).type);
            boolean bl = this.getUnderlineForToken((Token)object);
            if (((Token)object).isWhitespace()) {
                rtfGenerator.appendToDocNoFG(((Token)object).getLexeme(), font, color, bl);
                continue;
            }
            Color color2 = this.getForegroundForToken((Token)object);
            rtfGenerator.appendToDoc(((Token)object).getLexeme(), font, color2, color, bl);
        }
        object = new RtfTransferable(rtfGenerator.getRtf().getBytes());
        try {
            clipboard.setContents((Transferable)object, null);
        }
        catch (IllegalStateException illegalStateException) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
            return;
        }
    }

    protected Document createDefaultModel() {
        return new RSyntaxDocument("text/plain");
    }

    protected RTextAreaBase.RTAMouseListener createMouseListener() {
        return new RSyntaxTextAreaMutableCaretEvent((RTextArea)this);
    }

    protected RTextAreaUI createRTextAreaUI() {
        return new RSyntaxTextAreaUI(this);
    }

    protected final void doBracketMatching() {
        int n;
        if (this.match != null) {
            this.repaint(this.match);
        }
        if ((n = RSyntaxUtilities.getMatchingBracketPosition(this)) > -1) {
            try {
                this.match = this.modelToView(n);
                if (this.match != null) {
                    this.repaint(this.match);
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        } else {
            this.match = null;
        }
    }

    protected void fireCaretUpdate(CaretEvent caretEvent) {
        super.fireCaretUpdate(caretEvent);
        if (this.bracketMatchingEnabled) {
            this.doBracketMatching();
        }
    }

    public void fireHyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$HyperlinkListener == null ? RSyntaxTextArea.class$("javax.swing.event.HyperlinkListener") : class$javax$swing$event$HyperlinkListener)) continue;
            ((HyperlinkListener)objectArray[i + 1]).hyperlinkUpdate(hyperlinkEvent);
        }
    }

    public Color getBackgroundForTokenType(int n) {
        return this.syntaxScheme.styles[n].background;
    }

    public static synchronized CodeTemplateManager getCodeTemplateManager() {
        if (codeTemplateManager == null) {
            codeTemplateManager = new CodeTemplateManager();
        }
        return codeTemplateManager;
    }

    public static final Color getDefaultBracketMatchBGColor() {
        return DEFAULT_BRACKET_MATCH_BG_COLOR;
    }

    public static final Color getDefaultBracketMatchBorderColor() {
        return DEFAULT_BRACKET_MATCH_BORDER_COLOR;
    }

    public static Color getDefaultSelectionColor() {
        return DEFAULT_SELECTION_COLOR;
    }

    public SyntaxScheme getDefaultSyntaxScheme() {
        return new SyntaxScheme(true);
    }

    public Font getFontForTokenType(int n) {
        Font font = this.syntaxScheme.styles[n].font;
        return font != null ? font : this.getFont();
    }

    public FontMetrics getFontMetricsForTokenType(int n) {
        FontMetrics fontMetrics = this.syntaxScheme.styles[n].fontMetrics;
        return fontMetrics != null ? fontMetrics : this.defaultFontMetrics;
    }

    public Color getForegroundForToken(Token token) {
        if (this.getHyperlinksEnabled() && token.isHyperlink() && this.hoveredOverLinkOffset == token.offset) {
            return this.hyperlinkFG;
        }
        Color color = this.syntaxScheme.styles[token.type].foreground;
        return color != null ? color : this.getForeground();
    }

    public boolean getFractionalFontMetricsEnabled() {
        return this.fractionalFontMetricsEnabled;
    }

    private final Graphics2D getGraphics2D(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.aaHint != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.aaHint);
        }
        if (this.fractionalFontMetricsEnabled) {
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        }
        return graphics2D;
    }

    public Color getHyperlinkForeground() {
        return this.hyperlinkFG;
    }

    public boolean getHyperlinksEnabled() {
        return this.hyperlinksEnabled;
    }

    public int getLineHeight() {
        return this.lineHeight;
    }

    public boolean getMarkOccurrences() {
        return this.markOccurrencesSupport != null;
    }

    public Color getMarkOccurrencesColor() {
        return this.markOccurrencesColor;
    }

    boolean getMarkOccurrencesOfTokenType(int n) {
        RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)this.getDocument();
        return rSyntaxDocument.getMarkOccurrencesOfTokenType(n);
    }

    public Color getMatchedBracketBGColor() {
        return this.matchedBracketBGColor;
    }

    public Color getMatchedBracketBorderColor() {
        return this.matchedBracketBorderColor;
    }

    public final Rectangle getMatchRectangle() {
        return this.match;
    }

    private RtfGenerator getRTFGenerator() {
        if (this.rtfGenerator == null) {
            this.rtfGenerator = new RtfGenerator();
        } else {
            this.rtfGenerator.reset();
        }
        return this.rtfGenerator;
    }

    public boolean getShouldIndentNextLine(int n) {
        if (this.isAutoIndentEnabled()) {
            RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)this.getDocument();
            return rSyntaxDocument.getShouldIndentNextLine(n);
        }
        return false;
    }

    public String getSyntaxEditingStyle() {
        return this.syntaxStyleKey;
    }

    public SyntaxScheme getSyntaxScheme() {
        return this.syntaxScheme;
    }

    public static synchronized boolean getTemplatesEnabled() {
        return templatesEnabled;
    }

    public String getTextAntiAliasHint() {
        return this.aaHintFieldName;
    }

    private Token getTokenListFor(int n, int n2) {
        Token token;
        Token token2 = null;
        Token token3 = null;
        Element element = this.getDocument().getDefaultRootElement();
        int n3 = element.getElementIndex(n);
        int n4 = element.getElementIndex(n2);
        for (int i = n3; i <= n4; ++i) {
            Token token4 = this.getTokenListForLine(i);
            token4 = this.cloneTokenList(token4);
            if (token2 == null) {
                token3 = token2 = token4;
                while (token3.getNextToken() != null && token3.getNextToken().isPaintable()) {
                    token3 = token3.getNextToken();
                }
            } else {
                token3.setNextToken(token4);
                while (token3.getNextToken() != null && token3.getNextToken().isPaintable()) {
                    token3 = token3.getNextToken();
                }
            }
            if (i >= n4) continue;
            int n5 = element.getElement(i).getEndOffset() - 1;
            token4 = new DefaultToken(new char[]{'\n'}, 0, 0, n5, 16);
            token3.setNextToken(token4);
            token3 = token4;
        }
        if (n >= token2.offset) {
            while (!token2.containsPosition(n)) {
                token2 = token2.getNextToken();
            }
            token2.makeStartAt(n);
        }
        for (token = token2; token != null && !token.containsPosition(n2); token = token.getNextToken()) {
        }
        if (token != null) {
            token.textCount = n2 - token.offset;
            token.setNextToken(null);
        }
        return token2;
    }

    public Token getTokenListForLine(int n) {
        return ((RSyntaxDocument)this.getDocument()).getTokenListForLine(n);
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        String string = this.parserManager == null ? null : this.parserManager.getToolTipText(mouseEvent);
        return string != null ? string : super.getToolTipText(mouseEvent);
    }

    public boolean getUnderlineForToken(Token token) {
        return token.isHyperlink() && this.getHyperlinksEnabled() || this.syntaxScheme.styles[token.type].underline;
    }

    protected void init() {
        Font font = this.getFont();
        this.setFont(new Font("Monospaced", font.getStyle(), font.getSize()));
        this.syntaxStyleKey = "text/plain";
        this.setMatchedBracketBGColor(RSyntaxTextArea.getDefaultBracketMatchBGColor());
        this.setMatchedBracketBorderColor(RSyntaxTextArea.getDefaultBracketMatchBorderColor());
        this.setBracketMatchingEnabled(true);
        this.setSelectionColor(RSyntaxTextArea.getDefaultSelectionColor());
        this.setAutoIndentEnabled(true);
        this.setClearWhitespaceLinesEnabled(true);
        this.setHyperlinksEnabled(true);
        this.setLinkScanningMask(128);
        this.setHyperlinkForeground(Color.BLUE);
        this.isScanningForLinks = false;
        this.restoreDefaultSyntaxScheme();
    }

    public boolean isAutoIndentEnabled() {
        return this.autoIndentEnabled;
    }

    public final boolean isBracketMatchingEnabled() {
        return this.bracketMatchingEnabled;
    }

    public boolean isClearWhitespaceLinesEnabled() {
        return this.clearWhitespaceLines;
    }

    public boolean isWhitespaceVisible() {
        return this.whitespaceVisible;
    }

    private Token modelToToken(int n) {
        if (n >= 0) {
            try {
                int n2 = this.getLineOfOffset(n);
                for (Token token = this.getTokenListForLine(n2); token != null && token.isPaintable(); token = token.getNextToken()) {
                    if (!token.containsPosition(n)) continue;
                    return token;
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        return null;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(this.getGraphics2D(graphics));
    }

    private void refreshFontMetrics(Graphics2D graphics2D) {
        this.defaultFontMetrics = graphics2D.getFontMetrics(this.getFont());
        this.syntaxScheme.refreshFontMetrics(graphics2D);
        if (!this.getLineWrap()) {
            SyntaxView syntaxView = (SyntaxView)this.getUI().getRootView(this).getView(0);
            syntaxView.calculateLongestLine();
        }
    }

    void refreshParserNoticeHighlights(Iterator iterator) {
        this.clearParserNoticeHighlights();
        if (this.parserNoticeHighlights == null) {
            this.parserNoticeHighlights = new ArrayList();
        }
        if (iterator != null) {
            Highlighter highlighter = this.getHighlighter();
            while (iterator.hasNext()) {
                ParserNotice parserNotice = (ParserNotice)iterator.next();
                int n = parserNotice.getOffset();
                int n2 = parserNotice.getLength();
                try {
                    this.parserNoticeHighlights.add(highlighter.addHighlight(n, n + n2, this.parserErrorHighlightPainter));
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        }
    }

    public void removeHyperlinkListener(HyperlinkListener hyperlinkListener) {
        this.listenerList.remove(HyperlinkListener.class, hyperlinkListener);
    }

    public void removeNotify() {
        if (this.parserManager != null) {
            this.parserManager.setParser(null);
        }
        super.removeNotify();
    }

    public void restoreDefaultSyntaxScheme() {
        this.setSyntaxScheme(this.getDefaultSyntaxScheme());
    }

    public static synchronized boolean saveTemplates() {
        if (!RSyntaxTextArea.getTemplatesEnabled()) {
            return false;
        }
        return RSyntaxTextArea.getCodeTemplateManager().saveTemplates();
    }

    public void setAutoIndentEnabled(boolean bl) {
        if (this.autoIndentEnabled != bl) {
            this.autoIndentEnabled = bl;
            this.firePropertyChange(AUTO_INDENT_PROPERTY, !bl, bl);
        }
    }

    public void setBracketMatchingEnabled(boolean bl) {
        if (bl != this.bracketMatchingEnabled) {
            this.bracketMatchingEnabled = bl;
            this.repaint();
            this.firePropertyChange(BRACKET_MATCHING_PROPERTY, !bl, bl);
        }
    }

    public void setClearWhitespaceLinesEnabled(boolean bl) {
        if (bl != this.clearWhitespaceLines) {
            this.clearWhitespaceLines = bl;
            this.firePropertyChange(CLEAR_WHITESPACE_LINES_PROPERTY, !bl, bl);
        }
    }

    public void setDocument(Document document) {
        if (!(document instanceof RSyntaxDocument)) {
            throw new IllegalArgumentException("Documents for RSyntaxTextArea must be instances of RSyntaxDocument!");
        }
        super.setDocument(document);
    }

    public void setFont(Font font) {
        Font font2 = super.getFont();
        super.setFont(font);
        if (this.isDisplayable()) {
            this.refreshFontMetrics(this.getGraphics2D(this.getGraphics()));
            this.calculateLineHeight();
            this.updateMarginLineX();
            this.forceCurrentLineHighlightRepaint();
            this.firePropertyChange("font", font2, font);
            this.revalidate();
        }
    }

    public void setFractionalFontMetricsEnabled(boolean bl) {
        if (this.fractionalFontMetricsEnabled != bl) {
            this.fractionalFontMetricsEnabled = bl;
            if (this.isDisplayable()) {
                this.refreshFontMetrics(this.getGraphics2D(this.getGraphics()));
            }
            this.firePropertyChange(FRACTIONAL_FONTMETRICS_PROPERTY, !bl, bl);
        }
    }

    public void setHighlighter(Highlighter highlighter) {
        if (!(highlighter instanceof RSyntaxTextAreaHighlighter)) {
            throw new IllegalArgumentException("RSyntaxTextArea requires an RSyntaxTextAreaHighlighter for its Highlighter");
        }
        super.setHighlighter(highlighter);
    }

    public void setHyperlinkForeground(Color color) {
        if (color == null) {
            throw new NullPointerException("fg cannot be null");
        }
        this.hyperlinkFG = color;
    }

    public void setHyperlinksEnabled(boolean bl) {
        if (this.hyperlinksEnabled != bl) {
            this.hyperlinksEnabled = bl;
            this.repaint();
            this.firePropertyChange(HYPERLINKS_ENABLED_PROPERTY, !bl, bl);
        }
    }

    public void setLinkScanningMask(int n) {
        if (n == 128 || n == 256 || n == 512 || n == 64) {
            this.linkScanningMask = n;
        }
    }

    public void setMarkOccurrences(boolean bl) {
        if (bl) {
            if (this.markOccurrencesSupport == null) {
                this.markOccurrencesSupport = new MarkOccurrencesSupport();
                this.markOccurrencesSupport.install(this);
            }
        } else if (this.markOccurrencesSupport != null) {
            this.markOccurrencesSupport.uninstall();
            this.markOccurrencesSupport = null;
        }
    }

    public void setMarkOccurrencesColor(Color color) {
        this.markOccurrencesColor = color;
        if (this.markOccurrencesSupport != null) {
            this.markOccurrencesSupport.setColor(color);
        }
    }

    public void setMatchedBracketBGColor(Color color) {
        this.matchedBracketBGColor = color;
        if (this.match != null) {
            this.repaint();
        }
    }

    public void setMatchedBracketBorderColor(Color color) {
        this.matchedBracketBorderColor = color;
        if (this.match != null) {
            this.repaint();
        }
    }

    public void setParser(Parser parser) {
        if (this.parserManager == null) {
            this.parserManager = new ParserManager(this);
        }
        this.clearParserNoticeHighlights();
        this.parserManager.setParser(parser);
    }

    public void setSyntaxEditingStyle(String string) {
        if (string == null) {
            string = "text/plain";
        }
        if (!string.equals(this.syntaxStyleKey)) {
            String string2 = this.syntaxStyleKey;
            this.syntaxStyleKey = string;
            ((RSyntaxDocument)this.getDocument()).setSyntaxStyle(string);
            this.firePropertyChange(SYNTAX_STYLE_PROPERTY, string2, string);
        }
    }

    public void setSyntaxScheme(SyntaxScheme syntaxScheme) {
        SyntaxScheme syntaxScheme2 = this.syntaxScheme;
        this.syntaxScheme = syntaxScheme;
        this.calculateLineHeight();
        if (this.isDisplayable()) {
            this.refreshFontMetrics(this.getGraphics2D(this.getGraphics()));
        }
        this.updateMarginLineX();
        this.forceCurrentLineHighlightRepaint();
        this.revalidate();
        this.firePropertyChange(SYNTAX_SCHEME_PROPERTY, syntaxScheme2, this.syntaxScheme);
    }

    public static synchronized boolean setTemplateDirectory(String string) {
        if (RSyntaxTextArea.getTemplatesEnabled() && string != null) {
            File file = new File(string);
            if (file.isDirectory()) {
                return RSyntaxTextArea.getCodeTemplateManager().setTemplateDirectory(file) > -1;
            }
            boolean bl = file.mkdir();
            if (bl) {
                return RSyntaxTextArea.getCodeTemplateManager().setTemplateDirectory(file) > -1;
            }
        }
        return false;
    }

    public static synchronized void setTemplatesEnabled(boolean bl) {
        templatesEnabled = bl;
    }

    public void setTextAntiAliasHint(String string) {
        if (string == null && this.aaHintFieldName != null) {
            String string2 = this.aaHintFieldName;
            this.aaHint = null;
            this.aaHintFieldName = null;
            if (this.isDisplayable()) {
                this.refreshFontMetrics(this.getGraphics2D(this.getGraphics()));
            }
            this.firePropertyChange(ANTIALIAS_PROPERTY, string2, null);
            this.repaint();
        } else if (string != null && !string.equals(this.aaHintFieldName)) {
            String string3 = this.aaHintFieldName;
            try {
                Field field = RenderingHints.class.getDeclaredField(string);
                this.aaHint = field.get(null);
                this.aaHintFieldName = string;
            }
            catch (RuntimeException runtimeException) {
            }
            catch (Exception exception) {
                this.aaHint = RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
                this.aaHintFieldName = "VALUE_TEXT_ANTIALIAS_OFF";
            }
            if (this.isDisplayable()) {
                this.refreshFontMetrics(this.getGraphics2D(this.getGraphics()));
            }
            this.firePropertyChange(ANTIALIAS_PROPERTY, string3, this.aaHintFieldName);
            this.repaint();
        }
    }

    public void setWhitespaceVisible(boolean bl) {
        if (this.whitespaceVisible != bl) {
            this.whitespaceVisible = bl;
            ((RSyntaxDocument)this.getDocument()).setWhitespaceVisible(bl, this);
            this.repaint();
            this.firePropertyChange(VISIBLE_WHITESPACE_PROPERTY, !bl, bl);
        }
    }

    private Token viewToToken(Point point) {
        return this.modelToToken(this.viewToModel(point));
    }

    private class RSyntaxTextAreaMutableCaretEvent
    extends RTextArea.RTextAreaMutableCaretEvent {
        protected RSyntaxTextAreaMutableCaretEvent(RTextArea rTextArea) {
            super(RSyntaxTextArea.this, rTextArea);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (RSyntaxTextArea.this.getHyperlinksEnabled() && RSyntaxTextArea.this.isScanningForLinks && RSyntaxTextArea.this.hoveredOverLinkOffset > -1) {
                Object object;
                Token token = RSyntaxTextArea.this.modelToToken(RSyntaxTextArea.this.hoveredOverLinkOffset);
                URL uRL = null;
                String string = null;
                try {
                    object = token.getLexeme();
                    if (((String)object).startsWith("www.")) {
                        object = "http://" + (String)object;
                    }
                    uRL = new URL((String)object);
                }
                catch (MalformedURLException malformedURLException) {
                    string = malformedURLException.getMessage();
                }
                object = new HyperlinkEvent(this, HyperlinkEvent.EventType.ACTIVATED, uRL, string);
                RSyntaxTextArea.this.fireHyperlinkUpdate((HyperlinkEvent)object);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            super.mouseMoved(mouseEvent);
            if (RSyntaxTextArea.this.getHyperlinksEnabled()) {
                if ((mouseEvent.getModifiersEx() & RSyntaxTextArea.this.linkScanningMask) != 0) {
                    RSyntaxTextArea.this.isScanningForLinks = true;
                    Token token = RSyntaxTextArea.this.viewToToken(mouseEvent.getPoint());
                    Cursor cursor = null;
                    if (token != null && token.isHyperlink()) {
                        RSyntaxTextArea.this.hoveredOverLinkOffset = token.offset;
                        cursor = Cursor.getPredefinedCursor(12);
                    } else {
                        cursor = Cursor.getPredefinedCursor(2);
                        RSyntaxTextArea.this.hoveredOverLinkOffset = -1;
                    }
                    if (RSyntaxTextArea.this.getCursor() != cursor) {
                        RSyntaxTextArea.this.setCursor(cursor);
                        RSyntaxTextArea.this.repaint();
                    }
                } else if (RSyntaxTextArea.this.isScanningForLinks) {
                    Cursor cursor = RSyntaxTextArea.this.getCursor();
                    RSyntaxTextArea.this.isScanningForLinks = false;
                    RSyntaxTextArea.this.hoveredOverLinkOffset = -1;
                    if (cursor != null && cursor.getType() == 12) {
                        RSyntaxTextArea.this.setCursor(Cursor.getPredefinedCursor(2));
                        RSyntaxTextArea.this.repaint();
                    }
                }
            }
        }
    }
}

