/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.spgeed;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.spgeed.Chunk;
import org.nuiton.spgeed.ChunkArrayList;
import org.nuiton.spgeed.Facets;

public class SpgeedUtils {
    private static Log log = LogFactory.getLog(SpgeedUtils.class);

    public static Optional<Class> getElementType(Type c) {
        Class result = null;
        if (c instanceof ParameterizedType) {
            Type tmp;
            ParameterizedType pType = (ParameterizedType)c;
            Type raw = pType.getRawType();
            if (raw instanceof Class && Collection.class.isAssignableFrom((Class)raw) && (tmp = pType.getActualTypeArguments()[0]) instanceof Class) {
                result = (Class)tmp;
            }
        } else if (c instanceof Class && ((Class)c).isArray()) {
            result = ((Class)c).getComponentType();
        }
        return Optional.ofNullable(result);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Collection newCollectionInstance(Class returnType) {
        void var1_5;
        if (!Collection.class.isAssignableFrom(returnType)) {
            throw new IllegalArgumentException("Class is not a collection: " + returnType);
        }
        if (Modifier.isAbstract(returnType.getModifiers()) || returnType.isInterface()) {
            if (returnType.isAssignableFrom(Chunk.class)) {
                ChunkArrayList chunkArrayList = new ChunkArrayList();
                return var1_5;
            } else if (returnType.isAssignableFrom(Set.class)) {
                HashSet hashSet = new HashSet();
                return var1_5;
            } else {
                if (!returnType.isAssignableFrom(List.class) && !returnType.isAssignableFrom(Collection.class)) throw new IllegalArgumentException("Can't find instanciable class for :" + returnType);
                ArrayList arrayList = new ArrayList();
            }
            return var1_5;
        }
        try {
            Collection collection = (Collection)returnType.newInstance();
            return var1_5;
        }
        catch (IllegalAccessException | InstantiationException eee) {
            throw new IllegalArgumentException("Can't create new instance of class :" + returnType);
        }
    }

    public static Object convertToNumber(Object v, Class elementType) {
        try {
            if (v == null || elementType.isInstance(v)) {
                return v;
            }
            Method m = Number.class.getMethod(elementType.getSimpleName().toLowerCase().replace("integer", "int") + "Value", new Class[0]);
            return m.invoke(v, new Object[0]);
        }
        catch (Exception eee) {
            throw new RuntimeException(String.format("Can't convert '%s' to '%s'", v, elementType.getName()), eee);
        }
    }

    public static boolean returningChunk(Class returnType) {
        boolean result = Chunk.class.isAssignableFrom(returnType);
        return result;
    }

    public static boolean returningFacets(Class returnType) {
        boolean result = Facets.class.isAssignableFrom(returnType);
        return result;
    }

    public static boolean returningCollection(Class returnType) {
        boolean result = Collection.class.isAssignableFrom(returnType);
        return result;
    }

    public static boolean returningArray(Class returnType) {
        boolean result = returnType.isArray();
        return result;
    }

    public static boolean returningPrimitive(Class elementType) {
        boolean result = ClassUtils.isPrimitiveOrWrapper((Class)elementType) || elementType.equals(String.class) || elementType.equals(UUID.class) || elementType.isEnum();
        return result;
    }

    public static <T, C extends Chunk<T>> C newChunk(Class<C> returnType, Class<T> elementType, long fetch, long first, long next, long total) {
        try {
            Chunk result = (Chunk)returnType.newInstance();
            result.setElementType(elementType);
            result.setFetch(fetch);
            result.setFirst(first);
            result.setNext(next);
            result.setTotal(total);
            return (C)result;
        }
        catch (IllegalAccessException | InstantiationException eee) {
            throw new IllegalArgumentException("Chunk child class must have no args constructor", eee);
        }
    }

    public static String getTimer(long nb) {
        if (nb <= 0L) {
            return "0ms";
        }
        long[] multipliers = new long[]{3600000L, 60000L, 1000L, 1L};
        String[] units = new String[]{"h", "m", "s", "ms"};
        String result = "";
        for (int i = 0; i < units.length; ++i) {
            long multiplier = multipliers[i];
            String unit = units[i];
            if (nb / multiplier <= 0L) continue;
            result = result + nb / multiplier + unit;
            if ((nb %= multiplier) == 0L) continue;
            result = result + " ";
        }
        return result;
    }

    public static Long parsePeriod(String period) {
        if (period == null) {
            return null;
        }
        boolean isPassed = false;
        Pattern periodPattern = Pattern.compile("([0-9]+)((ms)|([hdms]))");
        period = period.toLowerCase(Locale.ENGLISH);
        Matcher matcher = periodPattern.matcher(period);
        Instant instant = Instant.EPOCH;
        while (matcher.find()) {
            String typ;
            isPassed = true;
            int num = Integer.parseInt(matcher.group(1));
            switch (typ = matcher.group(2)) {
                case "ms": {
                    instant = instant.plus(Duration.ofMillis(num));
                    break;
                }
                case "m": {
                    instant = instant.plus(Duration.ofMinutes(num));
                    break;
                }
                case "s": {
                    instant = instant.plus(Duration.ofSeconds(num));
                    break;
                }
                case "h": {
                    instant = instant.plus(Duration.ofHours(num));
                    break;
                }
                case "d": {
                    instant = instant.plus(Duration.ofDays(num));
                }
            }
        }
        if (!isPassed) {
            throw new IllegalArgumentException(String.format("Wrong format %s doesn't exist\n", period));
        }
        return instant.toEpochMilli();
    }
}

