/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.scmwebeditor.uiweb.actions;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.scmwebeditor.api.ScmProvider;
import org.nuiton.scmwebeditor.uiweb.ScmWebEditorConfig;
import org.nuiton.scmwebeditor.uiweb.actions.AbstractScmWebEditorAction;

public class DetectScmAction
extends AbstractScmWebEditorAction {
    private static final Log log = LogFactory.getLog(DetectScmAction.class);
    protected String address;
    protected String detectedScm;

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getDetectedScm() {
        return this.detectedScm;
    }

    public void setDetectedScm(String detectedScm) {
        this.detectedScm = detectedScm;
    }

    public String execute() {
        ArrayList supportedScms = Lists.newArrayList(ScmWebEditorConfig.getProviders().keySet());
        for (String scm : supportedScms) {
            ScmProvider provider = ScmWebEditorConfig.getProvider((String)scm);
            if (!provider.addressSeemsCompatible(this.address)) continue;
            this.detectedScm = scm;
            return "success";
        }
        this.detectedScm = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Detected SCM '" + this.detectedScm + "' for address " + this.address));
        }
        return "success";
    }
}

