/*
 * *##% 
 * Nuiton processor library
 * Copyright (C) 2002 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */

/* *
 * ProcessorReader.java
 *
 * Created: Wed Jan 14 2004
 *
 * @author  <poussin@codelutin.com>
 * Copyright Code Lutin
 * @version $Revision: 268 $
 *
 * Mise a jour: $Date: 2009-08-29 18:46:57 +0200 (sam., 29 août 2009) $
 * par : $Author: tchemit $
 */
package org.nuiton.processor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

import org.nuiton.processor.filters.Filter;

/**
 * TODO doc.
 *
 * @author poussin
 */
public class ProcessorReader extends BufferedReader {

    protected BufferedReader input;
    protected Filter filter;
    protected String lineSeparator;

    protected ProcessorReader() {
        super(new StringReader(""));
    }

    public ProcessorReader(BufferedReader input, Filter filter) {
        this();
        setInput(input);
        this.filter = filter;
        lineSeparator = System.getProperty("line.separator");
    }

    public void setInput(BufferedReader input) {
        this.input = input;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public String readLine() throws IOException {
        if (input.ready()) {
            String line = input.readLine();
            if (line != null) {
                if (!(input instanceof ProcessorReader)) {
                    line += lineSeparator;
                }
                String parse = filter.parse(line);
                return parse;
            }
        }
        if (filter.hasCachedData()) {
            return filter.flush();
        }
        return null;
    }

    @Override
    public boolean ready() {
        try {
            boolean ready = input.ready();
            if (ready) {
                return true;
            }
            return filter.hasCachedData();
        } catch (IOException eee) {
            return false;
        }
    }

    @Override
    public void close() throws IOException {
        input.close();
    }
}
