/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.processor;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Logger;
import org.nuiton.processor.ProcessorReader;
import org.nuiton.processor.ProcessorWriter;
import org.nuiton.processor.filters.Filter;
import org.nuiton.processor.filters.NoActionFilter;

public class Processor {
    private static Logger log = Logger.getLogger("org.nuiton.processor.Processor");
    protected Filter[] inputFilter = new Filter[]{new NoActionFilter()};
    protected Filter outputFilter = new NoActionFilter();

    public Processor() {
    }

    public Processor(Filter[] filters) {
        this.setInputFilter(filters);
    }

    public void setInputFilter(Filter inFilter) {
        this.setInputFilter(new Filter[]{inFilter});
    }

    public void setInputFilter(Filter[] inFilter) {
        this.inputFilter = inFilter;
    }

    public void setOutputFilter(Filter outFilter) {
        this.outputFilter = outFilter;
    }

    protected BufferedReader getReader(Reader externalInput) {
        BufferedReader result = new BufferedReader(externalInput);
        for (int i = 0; i < this.inputFilter.length; ++i) {
            result = new ProcessorReader(result, this.inputFilter[i]);
        }
        return result;
    }

    public void process(Reader externalInput, Writer externalOutput) throws IOException {
        log.finest("Debug du process");
        BufferedReader input = this.getReader(externalInput);
        ProcessorWriter output = new ProcessorWriter(new BufferedWriter(externalOutput), this.outputFilter);
        log.finest("input: " + input);
        log.finest("output: " + output);
        String line = input.readLine();
        while (line != null) {
            log.finest("Ligne lu: " + line);
            output.writeLine(line);
            line = input.readLine();
        }
        output.flush();
    }
}

