/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.config.plugin.io;

import com.google.common.base.Joiner;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.commons.configuration2.INIConfiguration;
import org.apache.commons.configuration2.SubnodeConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.config.plugin.io.ConfigModelIO;
import org.nuiton.config.plugin.io.ReadConfigModelException;
import org.nuiton.config.plugin.io.WriteConfigModelException;
import org.nuiton.config.plugin.model.ActionModel;
import org.nuiton.config.plugin.model.ConfigModel;
import org.nuiton.config.plugin.model.OptionModel;

public class ConfigModelIOIniImpl
implements ConfigModelIO {
    private static final String DESCRIPTION = "description";
    private static final String KEY = "key";
    private static final String TYPE = "type";
    private static final String DEFAULT_VALUE = "defaultValue";
    private static final String TRANSIENT = "transient";
    private static final String FINAL = "final";
    private static final String ACTION = "action";
    private static final String ALIASES = "aliases";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ConfigModel read(Path path) throws ReadConfigModelException {
        try (BufferedReader reader = Files.newReader((File)path.toFile(), (Charset)StandardCharsets.UTF_8);){
            INIConfiguration iniConfiguration = new INIConfiguration();
            iniConfiguration.read((Reader)reader);
            ConfigModel configModel = new ConfigModel();
            configModel.setDescription(iniConfiguration.getString(DESCRIPTION));
            LinkedList<OptionModel> options = new LinkedList<OptionModel>();
            LinkedList<ActionModel> actions = new LinkedList<ActionModel>();
            configModel.setOptions(options);
            configModel.setActions(actions);
            for (String section : iniConfiguration.getSections()) {
                String description;
                if (section == null) continue;
                if (section.startsWith("option ")) {
                    String _final;
                    SubnodeConfiguration optionSection = iniConfiguration.getSection(section);
                    OptionModel optionModel = new OptionModel();
                    String optionName = StringUtils.removeStart((String)section, (String)"option ");
                    optionModel.setName(optionName);
                    description = optionSection.getString(DESCRIPTION, "");
                    optionModel.setDescription(description);
                    String key = optionSection.getString(KEY);
                    optionModel.setKey(key);
                    String type = optionSection.getString(TYPE);
                    optionModel.setType(type);
                    String defaultValue = optionSection.getString(DEFAULT_VALUE);
                    optionModel.setDefaultValue(defaultValue);
                    String _transient = optionSection.getString(TRANSIENT);
                    if (StringUtils.isNotEmpty((CharSequence)_transient)) {
                        optionModel.setTransient(Boolean.valueOf(_transient));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)(_final = optionSection.getString(FINAL)))) {
                        optionModel.setTransient(Boolean.valueOf(_final));
                    }
                    options.add(optionModel);
                    continue;
                }
                if (!section.startsWith("action ")) continue;
                SubnodeConfiguration actionSection = iniConfiguration.getSection(section);
                ActionModel actionModel = new ActionModel();
                String actionName = StringUtils.removeStart((String)section, (String)"action ");
                actionModel.setName(actionName);
                description = actionSection.getString(DESCRIPTION, "");
                actionModel.setDescription(description);
                String action = actionSection.getString(ACTION);
                actionModel.setAction(action);
                String aliases = actionSection.getString(ALIASES);
                if (StringUtils.isNotEmpty((CharSequence)aliases)) {
                    actionModel.setAliases(aliases.split("\\s*,\\s*"));
                }
                actions.add(actionModel);
            }
            ConfigModel configModel2 = configModel;
            return configModel2;
        }
        catch (Exception e) {
            throw new ReadConfigModelException("Can't real ini config model from file: " + path, e);
        }
    }

    @Override
    public void write(ConfigModel configModel, Path path) throws WriteConfigModelException {
        try (BufferedWriter writer = Files.newWriter((File)path.toFile(), (Charset)StandardCharsets.UTF_8);){
            SubnodeConfiguration section;
            INIConfiguration iniConfiguration = new INIConfiguration();
            iniConfiguration.addProperty(DESCRIPTION, (Object)configModel.getDescription());
            for (OptionModel optionModel : configModel.getOptions()) {
                section = iniConfiguration.getSection("option " + optionModel.getName());
                section.addProperty(DESCRIPTION, (Object)optionModel.getDescription());
                section.addProperty(KEY, (Object)optionModel.getKey());
                section.addProperty(TYPE, (Object)optionModel.getType());
                if (optionModel.getDefaultValue() != null) {
                    section.addProperty(DEFAULT_VALUE, (Object)optionModel.getDefaultValue());
                }
                if (optionModel.isTransient()) {
                    section.addProperty(TRANSIENT, (Object)"true");
                }
                if (!optionModel.isFinal()) continue;
                section.addProperty(FINAL, (Object)"true");
            }
            for (ActionModel actionModel : configModel.getActions()) {
                section = iniConfiguration.getSection("action " + actionModel.getName());
                section.addProperty(DESCRIPTION, (Object)actionModel.getDescription());
                section.addProperty(ACTION, (Object)actionModel.getAction());
                if (actionModel.getAliases().length <= 0) continue;
                section.addProperty(ALIASES, (Object)Joiner.on((String)",").join(Arrays.asList(actionModel.getAliases())));
            }
            iniConfiguration.write((Writer)writer);
        }
        catch (Exception e) {
            throw new WriteConfigModelException("Can't write ini config model from file: " + path, e);
        }
    }
}

