/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.plugin;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.nuiton.jredmine.model.News;
import org.nuiton.jredmine.plugin.AbstractRedmineMojo;
import org.nuiton.plugin.PluginHelper;

public class PublishNewsMojo
extends AbstractRedmineMojo {
    protected File newsContentFile;
    protected String newsSummary;
    protected String newsTitle;
    protected boolean skipPublishNews;
    protected boolean dryRun;
    protected boolean runOnce;

    public PublishNewsMojo() {
        super(true, false, true);
    }

    @Override
    protected boolean isGoalSkip() {
        return this.skipPublishNews;
    }

    @Override
    protected boolean checkRunOnceDone() {
        return this.isRunOnce() && !this.isExecutionRoot();
    }

    @Override
    protected boolean isRunOnce() {
        return this.runOnce;
    }

    @Override
    protected void init() throws Exception {
        this.runOnceDone = false;
        if (this.isRunOnce()) {
            this.runOnceDone = this.checkRunOnceDone();
            if (this.runOnceDone) {
                return;
            }
        }
        if (this.newsSummary == null || this.newsSummary.trim().isEmpty()) {
            this.newsSummary = this.project.getUrl();
        }
        if (!this.newsContentFile.exists()) {
            throw new MojoExecutionException("could not find the template " + this.newsContentFile);
        }
        this.newsTitle = this.newsTitle.trim();
        if (this.newsTitle.length() > 60) {
            this.getLog().warn((CharSequence)("News title can not be longer than 60 caracters, but was " + this.newsTitle.length()));
            this.newsTitle = this.newsTitle.substring(0, 59);
            this.getLog().warn((CharSequence)("will use the restricted title : " + this.newsTitle));
        }
        super.init();
    }

    @Override
    protected void doAction() throws Exception {
        if (this.dryRun) {
            this.getLog().info((CharSequence)"\n  dryRun flag is on, no data will be send!\n");
        }
        News news = new News();
        news.setAuthorId(this.releaseUser.getId());
        news.setProjectId(this.releaseProject.getId());
        news.setTitle(this.newsTitle);
        news.setSummary(this.newsSummary);
        String newsContent = PluginHelper.readAsString((File)this.newsContentFile, (String)this.encoding);
        news.setDescription(newsContent);
        if (this.dryRun) {
            this.getLog().info((CharSequence)("news title   : " + news.getTitle()));
            this.getLog().info((CharSequence)("news summary : " + news.getSummary()));
            this.getLog().info((CharSequence)("news content :\n" + newsContent));
            return;
        }
        this.getLog().info((CharSequence)("publish news " + news.getTitle()));
        if (this.verbose) {
            this.getLog().info((CharSequence)("redmine announcement :\n" + newsContent));
        }
        news = this.service.addNews(this.projectId, news);
        if (this.verbose) {
            this.getLog().info((CharSequence)("done. news id : " + news.getId()));
        }
    }
}

