/*
 * *##% 
 * JRedmine client
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package org.nuiton.jredmine;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.nuiton.io.rest.RestClientConfiguration;
import org.nuiton.jredmine.model.Attachment;
import org.nuiton.jredmine.model.Issue;
import org.nuiton.jredmine.model.IssueCategory;
import org.nuiton.jredmine.model.IssuePriority;
import org.nuiton.jredmine.model.IssueStatus;
import org.nuiton.jredmine.model.News;
import org.nuiton.jredmine.model.Project;
import org.nuiton.jredmine.model.Tracker;
import org.nuiton.jredmine.model.User;
import org.nuiton.jredmine.model.Version;
import org.nuiton.jredmine.rest.RedmineRestClient;

/**
 *
 * @author chemit
 */
public class DefaultRedmineServiceTest {

    /**
     * shared rest client (open only one session for all the test)
     */
    static RedmineRestClient client;
    /**
     * service to test
     */
    RedmineService service;

    @BeforeClass
    public static void setUpClass() throws Exception {
        RestClientConfiguration configuration = TestHelper.getTestConfiguration();

        client = new RedmineRestClient(configuration);
        try {

            client.open();
        } catch (Exception e) {

            // could not log
            System.out.println("can not connect to server " + configuration.getRestUrl() + ", will skip test " + DefaultRedmineServiceTest.class.getName());
        } finally {
            Assume.assumeTrue(client != null && client.isOpen());
        }
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        if (client != null) {
            client.close();
        }
    }

    @Before
    public void setUp() throws Exception {
        service = new DefaultRedmineService();

        ((RedmineServiceImplementor) service).init(client);
    }

    @After
    public void tearDown() throws Exception {

        service = null;
    }

    @Test
    public void isInit() throws Exception {

        Assert.assertFalse(new DefaultRedmineService().isInit());

    }

    @Test
    public void getProjects() throws Exception {
        Project[] projects = service.getProjects();
    }

    @Test
    public void getIssuePriorities() throws Exception {
        IssuePriority[] suePriorities = service.getIssuePriorities();
    }

    @Test
    public void getIssueStatuses() throws Exception {
        IssueStatus[] sueStatuses = service.getIssueStatuses();
    }

    @Test
    public void getProject() throws Exception {
        Project project = service.getProject("one");
    }

    @Test
    public void getIssueCategories() throws Exception {
        IssueCategory[] sueCategories = service.getIssueCategories("one");
    }

    @Test
    public void getTrackers() throws Exception {
        Tracker[] trackers = service.getTrackers("one");
    }

    @Test
    public void getNews() throws Exception {
        News[] news = service.getNews("one");
    }

    @Test
    public void getUsers() throws Exception {
        User[] users = service.getUsers("one");
    }

    @Test
    public void getVersions() throws Exception {
        Version[] versions = service.getVersions("one");
    }

    @Test
    public void getVersion() throws Exception {
        Version version = service.getVersion("one", "1.0.0");
    }

    @Test
    public void getIssues() throws Exception {
        Issue[] sues = service.getIssues("one", "1.0.0");
    }

    @Test
    public void getAttachments() throws Exception {
        Attachment[] attachments = service.getAttachments("one", "1.0.0");
    }

    @Test
    public void addVersion() throws Exception {
    }

    @Test
    public void addAttachment() throws Exception {
    }

    @Test
    public void addNews() throws Exception {
    }

    @Test
    public void updateVersion() throws Exception {
    }

    @Test
    public void nextVersion() throws Exception {
    }
}
