/*
 * *##% 
 * JRedmine client
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package org.nuiton.jredmine.model;

/**
 * Un énumération pour connaitre l'ensemble des classes du modèle.
 *
 * @author chemit
 * @since 1.0.0
 */
public enum RedmineModelEnum {

    issueStatus(IssueStatus.class, RedmineModelScope.none),
    issuePriority(IssuePriority.class, RedmineModelScope.none),
    project(Project.class, RedmineModelScope.none),
    issueCategory(IssueCategory.class, RedmineModelScope.project),
    tracker(Tracker.class, RedmineModelScope.project),
    user(User.class, RedmineModelScope.project),
    news(News.class, RedmineModelScope.project),
    version(Version.class, RedmineModelScope.project),
    issue(Issue.class, RedmineModelScope.version),
    attachment(Attachment.class, RedmineModelScope.version);
    private final Class<?> modelType;
    private final RedmineModelScope scope;

    private RedmineModelEnum(Class<?> modelType, RedmineModelScope scope) {
        this.modelType = modelType;
        this.scope = scope;
    }

    public Class<?> getModelType() {
        return modelType;
    }

    public RedmineModelScope getScope() {
        return scope;
    }

    public static RedmineModelEnum valueOf(Class<?> type) {
        for (RedmineModelEnum e : values()) {
            if (type == e.getModelType()) {
                return e;
            }
        }
        return null;
    }

    public static RedmineModelEnum safeValueOf(Class<?> type) {
        if (type == null) {
            throw new NullPointerException("klass parameter can not be null");
        }

        // check dataType is authorized

        RedmineModelEnum r = valueOf(type);
        if (r == null) {
            throw new IllegalArgumentException("the type " + type.getName() + " is not allowed!");
        }

        return r;
    }
}
