package org.nuiton.jaxx.runtime.swing;

import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.plaf.basic.ExtendedBasicDatePickerUI;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.SwingUtil;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;

public class JAXXDatePicker extends JXDatePicker implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_PATTERN_LAYOUT = "patternLayout";
    public static final String PROPERTY_SHOW_POPUP_BUTTON = "showPopupButton";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1Tu24TQRS9NnFCHPIAJOpICQQJmIUOyYiHYyIcGRIRRbJww9g7sddZzwwzd/GmSUFBxw9Q0NKg/ENEhURD639AyidwZ9d4XdjhscWudnTumXPvPefLTyhYA7eVaTMZBagk6/I4ZiaSGPQE235Sr+80u6KFFWFbJtCoDKRPLg/5Biz4o3OLwBo1YvJSJs8xeUMmb1P1tJJCjhGValC0eBQK2xECEW5OLW5Z6+2NkKVYR2Z410TVk+76/v7eICcqH/MAsSb5M9T2rX8gyLqeqUE+8BGu1Lr8LfdCLtskzgSyTQ0turPNkFv7gvfEGziGuRrMam6IDOHOf40noUuoYo2wtL5dr3AUu0HrUJi7OH15tk+akhVmeK0TplmEZdtR/V2lI12OkGoRLjvtzPXDykqFgssMvag5ojCyxo8UwWElw6a9Z9CiiFFIX/j7VYT7TlyXTHKISqeKYqZDfsCa3AYt9nSILbu/TOZ+lfgM3JjWGhmCZYbIdpNrQMFEdIywNt2Lzk4vCZUaaW26kdw1CfDdybH53D8b/HZPjsSt/qlqLCi0Sm2UFgYDp205tU6EQeg957rUgHkrQkpZkqKN85XvDZGknlSkS3NM7Bm3HWIrzA1Ov157/eMC5LegGCrub3GHr8I8dgxNTIV+rB89TsRd6l+k94qTOckSSw98jny1GUifNvcwpnFtnD+ukbqTnbNvnz5cPx0f2frfVGZjK7yC2UCGgRRJ5IZpmhixBW1F5KssKpPCk3Pfq1rrX/GR3Bj3BAAA";
    private static final Log log = LogFactory.getLog(JAXXDatePicker.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected ExtendedBasicDatePickerUI extendedUI;
    protected String patternLayout;
    protected Boolean showPopupButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JAXXDatePicker $JXDatePicker0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
    
            setUI(extendedUI);
    
            addPropertyChangeListener(PROPERTY_SHOW_POPUP_BUTTON, new PropertyChangeListener() {
    
                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    extendedUI.setShowPopupButton((Boolean) evt.getNewValue());
                }
            });
    
            addPropertyChangeListener(PROPERTY_PATTERN_LAYOUT, new PropertyChangeListener() {
    
                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    setFormats(new SimpleDateFormat((String) evt.getNewValue()));
                }
            });
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JAXXDatePicker(Date param0) {
        super(param0);
        $initialize();
    }

    public JAXXDatePicker(JAXXContext parentContext, Date param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public JAXXDatePicker(Locale param0) {
        super(param0);
        $initialize();
    }

    public JAXXDatePicker(JAXXContext parentContext, Locale param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public JAXXDatePicker(Date param0, Locale param1) {
        super(param0 ,param1);
        $initialize();
    }

    public JAXXDatePicker(JAXXContext parentContext, Date param1, Locale param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public JAXXDatePicker() {
        $initialize();
    }

    public JAXXDatePicker(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public ExtendedBasicDatePickerUI getExtendedUI() {
        return extendedUI;
    }

    public String getPatternLayout() {
        return patternLayout;
    }

    public Boolean getShowPopupButton() {
        return showPopupButton;
    }

    public Boolean isShowPopupButton() {
        return showPopupButton !=null && showPopupButton;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setPatternLayout(String patternLayout) {
        String oldValue = this.patternLayout;
        this.patternLayout = patternLayout;
        firePropertyChange(PROPERTY_PATTERN_LAYOUT, oldValue, patternLayout);
    }

    public void setShowPopupButton(Boolean showPopupButton) {
        Boolean oldValue = this.showPopupButton;
        this.showPopupButton = showPopupButton;
        firePropertyChange(PROPERTY_SHOW_POPUP_BUTTON, oldValue, showPopupButton);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createExtendedUI() {
        $objectMap.put("extendedUI", extendedUI = new ExtendedBasicDatePickerUI());
    }

    protected void createPatternLayout() {
        $objectMap.put("patternLayout", patternLayout = "dd/MM/yyyy");
    }

    protected void createShowPopupButton() {
        $objectMap.put("showPopupButton", showPopupButton = Boolean.TRUE);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $JXDatePicker0 = this;
        $initialize_01_createComponents();
        $initialize_02_registerDataBindings();
        $initialize_03_finalizeCreateComponents();
        $initialize_04_applyDataBindings();
        $initialize_05_setProperties();
        $initialize_06_finalizeInitialize();
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JXDatePicker0", $JXDatePicker0);
        createShowPopupButton();
        createPatternLayout();
        createExtendedUI();
        // inline creation of $JXDatePicker0
        setName("$JXDatePicker0");
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 0 data bindings
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 1 property setters
        extendedUI.setShowPopupButton(showPopupButton);
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}